/*
 * Decompiled with CFR 0.152.
 */
package battery;

import device.SensorNode;
import java.awt.Color;
import java.awt.Graphics;
import map.MapLayer;
import utilities.UColor;

public class Battery
implements Cloneable {
    public double eMax;
    private double level;
    private SensorNode sensorNode;

    public Battery(SensorNode sensorNode) {
        this.level = this.eMax = 19160.0;
        this.sensorNode = sensorNode;
    }

    public double getEMax() {
        return this.eMax;
    }

    public double getLevel() {
        return this.level;
    }

    public int getLevelInPercent() {
        return (int)(this.level * 1.0 / this.eMax * 100.0);
    }

    public void setLevel(double capacity) {
        this.level = capacity;
    }

    public void setEMax(double eMax) {
        this.eMax = eMax;
        this.level = eMax;
    }

    public void init() {
        this.level = this.eMax;
    }

    public void consume(double v) {
        this.level -= v;
        if (this.level < 0.0) {
            this.level = 0.0;
        }
    }

    public double getBatteryConsumption() {
        return this.eMax - this.level;
    }

    public boolean empty() {
        return this.level <= 0.0;
    }

    public Battery clone() throws CloneNotSupportedException {
        Battery newBattery = (Battery)super.clone();
        return newBattery;
    }

    public void draw(Graphics g, int x, int y, int dx) {
        g.setColor(UColor.WHITE_LTRANSPARENT);
        g.fillRect(x - dx, y - 25, 6, 50);
        g.setColor(UColor.GREEN);
        if (this.getLevel() / this.getEMax() < 0.5) {
            g.setColor(UColor.ORANGE);
        }
        if (this.getLevel() / this.getEMax() < 0.2) {
            g.setColor(UColor.RED);
        }
        g.fillRect(x - dx, y - (int)(this.getLevel() / this.getEMax() * 100.0 / 2.0) + 25, 6, (int)(this.getLevel() / this.getEMax() * 100.0 / 2.0));
        g.setColor(Color.DARK_GRAY);
        if (MapLayer.dark) {
            g.setColor(Color.WHITE);
        }
        g.drawRect(x - dx, y - 25, 6, 50);
        g.drawString("Battery" + this.sensorNode.getId() + ": " + (int)this.getLevel(), x - dx - 10, y + 35);
    }
}

