/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon;

import action.CupAction;
import action.CupActionAddIoTNode;
import action.CupActionAddRadioModule;
import action.CupActionBlock;
import action.CupActionDeleteRadioModule;
import action.CupActionModifDeviceElevation;
import action.CupActionModifDeviceGpsFile;
import action.CupActionModifDeviceId;
import action.CupActionModifDeviceLatitude;
import action.CupActionModifDeviceLongitude;
import action.CupActionModifDeviceNatEventFile;
import action.CupActionModifDeviceRadius;
import action.CupActionModifDeviceScriptFile;
import action.CupActionModifDirectionalSensorUnitCoverage;
import action.CupActionModifDirectionalSensorUnitDirection;
import action.CupActionModifRadioCR;
import action.CupActionModifRadioCh;
import action.CupActionModifRadioConsoRxModel;
import action.CupActionModifRadioConsoTxModel;
import action.CupActionModifRadioDataRate;
import action.CupActionModifRadioEListen;
import action.CupActionModifRadioERx;
import action.CupActionModifRadioESleep;
import action.CupActionModifRadioETx;
import action.CupActionModifRadioMy;
import action.CupActionModifRadioNId;
import action.CupActionModifRadioPl;
import action.CupActionModifRadioRadius;
import action.CupActionModifRadioSF;
import action.CupActionModifSensorCurrentRadio;
import action.CupActionModifSensorDrift;
import action.CupActionModifSensorElevation;
import action.CupActionModifSensorEnergyMax;
import action.CupActionModifSensorGpsFile;
import action.CupActionModifSensorId;
import action.CupActionModifSensorLatitude;
import action.CupActionModifSensorLongitude;
import action.CupActionModifSensorRadius;
import action.CupActionModifSensorScriptFile;
import action.CupActionModifSensorUART;
import action.CupActionModifSensorUnitESensing;
import action.CupActionModifSensorUnitRadius;
import action.CupActionStack;
import arduino.Arduino;
import buildings.BuildingList;
import cupcarbon.ConsoleController;
import cupcarbon.ConsoleWindow;
import cupcarbon.CupCarbonApp;
import cupcarbon.CupCarbonContextMenu;
import cupcarbon.EnergyDrawWindow;
import cupcarbon.ExecutorPathConfigWindow;
import cupcarbon.NaturalEventGenerator;
import cupcarbon.ProgramWindow;
import cupcarbon.RadioStandardModel;
import cupcarbon.SenScriptWindow;
import cupcarbon_script.CupCarbonFileNames;
import cupcarbon_script.CupCarbonServer;
import device.Device;
import device.DeviceList;
import device.IoTNode;
import device.MapObject;
import device.SensorNode;
import fault_injection.FaultInjector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingNode;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jsonlib.JSONArray;
import jsonlib.JSONObject;
import map.MapLayer;
import map.NetworkParameters;
import map.WorldMap;
import markers.MarkerList;
import markers.Routes;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import perso.ExampleClass;
import perso.MonAlgoClass;
import perso.MyClass;
import project.Project;
import radio_module.RadioModule;
import radio_module.RadioModule_Lora;
import senscript.SenScriptEditor;
import simulation.Executor;
import simulation.IoTSimulation;
import simulation.Simulation;
import simulation.SimulationInputs;
import simulation.WisenSimulation;
import solver.CycleFromNode;
import solver.EnvelopeJarvis;
import solver.EnvelopeLPCN;
import solver.EnvelopeLPCN_wc;
import solver.NetworkCenter;
import solver.NetworkEnvelopeC;
import solver.NetworkEnvelopeP;
import solver.NetworkPerso;
import solver.SensorSetCover;
import utilities.MapCalc;
import visibility.VisibilityLauncher;

public class CupCarbonController
implements Initializable {
    private WorldMap map = null;
    protected FaultInjector faultInjector = null;
    public ConsoleWindow console;
    public WisenSimulation wisenSimulation;
    public IoTSimulation iotSimulation;
    @FXML
    private TextField nodeMessage;
    @FXML
    private CheckBox markedCheckBox;
    @FXML
    private TextField wbsNumber;
    @FXML
    private TextField suCoverage;
    @FXML
    private TextField suDirection;
    @FXML
    private Label labelInfo1;
    @FXML
    private Label labelInfo2;
    @FXML
    private Label labelInfo3;
    @FXML
    private Label labelInfo4;
    @FXML
    private Label labelInfo5;
    @FXML
    private Label labelInfo6;
    @FXML
    private Label labelInfo7;
    @FXML
    private Label labelInfo8;
    @FXML
    private Label labelInfo9;
    @FXML
    private Label labelInfo10;
    @FXML
    private Label labelInfo11;
    @FXML
    private Label labelInfo12;
    @FXML
    private Label labelInfo13;
    @FXML
    private Label labelInfo14;
    @FXML
    private Label labelInfo15;
    @FXML
    private Label labelInfo16;
    @FXML
    private Label labelInfo17;
    @FXML
    private Label labelInfo18;
    @FXML
    private Text textReady;
    @FXML
    private SwingNode swingNode;
    @FXML
    private VBox vbox;
    @FXML
    public Slider bg_slider;
    @FXML
    public Button saveButton;
    @FXML
    public MenuItem openRecentProjectItem1;
    @FXML
    public MenuItem openRecentProjectItem2;
    @FXML
    public MenuItem openRecentProjectItem3;
    @FXML
    public MenuItem openRecentProjectItem4;
    @FXML
    public MenuItem openRecentProjectItem5;
    @FXML
    public MenuItem openRecentProjectItem6;
    @FXML
    public MenuItem openRecentProjectItem7;
    @FXML
    public MenuItem openRecentProjectItem8;
    @FXML
    public MenuItem openRecentProjectItem9;
    @FXML
    public MenuItem openRecentProjectItem10;
    @FXML
    public TextField resultsWPeriod;
    @FXML
    public ComboBox<String> radio_spreading_factor;
    @FXML
    public ComboBox<String> radio_code_rate;
    @FXML
    public ComboBox<String> radio_conso_tx_model;
    @FXML
    public ComboBox<String> radio_conso_rx_model;
    @FXML
    public Button spreading_factor_apply_button;
    @FXML
    public Button code_rate_apply_button;
    @FXML
    public Label simulationTimeLabel;
    @FXML
    public Label zoomLabel;
    @FXML
    public MenuItem resetItem;
    @FXML
    public MenuItem newProjectItem;
    @FXML
    public MenuItem newProjectFromCurrentItem;
    @FXML
    public MenuItem openProjectItem;
    @FXML
    public MenuItem openLastProjectItem;
    @FXML
    public MenuItem saveProjectItem;
    @FXML
    public MenuItem undoItem;
    @FXML
    public MenuItem redoItem;
    @FXML
    public MenuItem selectAllItem;
    @FXML
    public TitledPane markerPane;
    @FXML
    public TitledPane radioParamPane;
    @FXML
    public TitledPane deviceParamPane;
    @FXML
    public ComboBox<String> scriptFileComboBox;
    @FXML
    public ComboBox<String> gpsFileComboBox;
    @FXML
    public ComboBox<String> nateventFileComboBox;
    @FXML
    public ComboBox<String> uartComboBox;
    @FXML
    public CheckBox visibilityCheckBox;
    @FXML
    public CheckBox macCheckBox;
    @FXML
    public TextField macProbaTextField;
    @FXML
    public CheckBox ackCheckBox;
    @FXML
    public CheckBox symmetricalLinkCheckBox;
    @FXML
    public CheckBox clockDriftCheckBox;
    @FXML
    public CheckBox logCheckBox;
    @FXML
    public CheckBox resultsCheckBox;
    @FXML
    public CheckBox ackShowCheckBox;
    @FXML
    public ComboBox<String> probaComboBox;
    @FXML
    public TextField probaTextField;
    @FXML
    public TextField simulationTimeTextField;
    @FXML
    public CheckBox mobilityCheckBox;
    @FXML
    public TextField simulationSpeedTextField;
    @FXML
    public TextField arrowSpeedTextField;
    @FXML
    public TextField txtFileName;
    @FXML
    public TextField txtTitle;
    @FXML
    public TextField txtFrom;
    @FXML
    public TextField txtTo;
    @FXML
    public CheckBox loopCheckBox;
    @FXML
    public TextField loopAfter;
    @FXML
    public TextField loopNumber;
    @FXML
    public TextField bytxtfield;
    @FXML
    public TitledPane acc1;
    @FXML
    public StackPane pane;
    @FXML
    public Accordion accord;
    @FXML
    public ProgressBar progress;
    @FXML
    public ComboBox<RadioStandardModel> radioStdComboBox;
    @FXML
    public ComboBox<String> radioNameComboBox;
    @FXML
    public ListView<String> radioListView;
    @FXML
    public SplitPane split;
    @FXML
    public MenuBar menuBar;
    @FXML
    public TextField radio_nid;
    @FXML
    public TextField radio_my;
    @FXML
    public TextField radio_ch;
    @FXML
    public TextField radio_pl;
    @FXML
    public TextField radio_radius;
    @FXML
    public TextField radio_etx;
    @FXML
    public TextField radio_erx;
    @FXML
    public TextField radio_esleep;
    @FXML
    public TextField radio_elisten;
    @FXML
    public TextField radio_drate;
    @FXML
    public CheckMenuItem addSelectionMenuItem;
    @FXML
    public CheckBox addSelectionCheckBox;
    @FXML
    public Label sensorName;
    @FXML
    public Label numberOfDevices;
    @FXML
    public ListView<String> gpsListView;
    @FXML
    public ListView<String> deviceListView;
    @FXML
    public ListView<String> eventListView;
    @FXML
    public Menu menuEdition;
    @FXML
    public Menu menuSelection;
    static SenScriptEditor editor = null;
    @FXML
    public RadioMenuItem mapItem0;
    @FXML
    public RadioMenuItem mapItem1;
    @FXML
    public RadioMenuItem mapItem2;
    @FXML
    public RadioMenuItem mapItem3;
    @FXML
    public RadioMenuItem mapItem4;
    @FXML
    public RadioMenuItem mapItem5;
    @FXML
    public RadioMenuItem mapItem6;
    @FXML
    public RadioMenuItem mapItem7;
    @FXML
    public RadioMenuItem mapItem8;
    @FXML
    public RadioMenuItem mapItem9;
    @FXML
    public RadioMenuItem mapItem10;
    @FXML
    public RadioMenuItem mapItem11;
    @FXML
    public RadioMenuItem mapItem12;
    @FXML
    public TextField device_id;
    @FXML
    public TextField device_longitude;
    @FXML
    public TextField device_latitude;
    @FXML
    public TextField device_elevation;
    @FXML
    public TextField device_radius;
    @FXML
    public TextField sensor_radius;
    @FXML
    public TextField device_emax;
    @FXML
    public TextField device_eSensing;
    @FXML
    public TextField device_drift;
    public Device currentDevice;
    @FXML
    public Button runSimulationButton;
    @FXML
    public Button qRunSimulationButton;
    @FXML
    public Button qStopSimulationButton;
    @FXML
    public Button qRunIoTSimulationButton;
    @FXML
    public Button qStopIoTSimulationButton;
    @FXML
    public Label stlabel;
    private Color goodMessColor1 = new Color(0.2, 0.72, 0.1, 0.9);
    private Color goodMessColor2 = new Color(0.2, 0.72, 0.8, 0.9);

    @FXML
    public void closeLeftMenu() {
        this.split.setDividerPositions(0.0);
        this.map.repaint();
        this.mapFocus();
    }

    @FXML
    public void openLeftMenu() {
        this.split.setDividerPositions(0.19);
        this.map.repaint();
        this.mapFocus();
    }

    public void mapFocus() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.numberOfDevices.setText("N = " + DeviceList.getSize());
                CupCarbonController.this.swingNode.requestFocus();
                MapLayer.repaint();
            }
        });
    }

    public void splitPaneShowHide() {
        if (this.split.getDividerPositions()[0] > 0.1) {
            this.split.setDividerPositions(0.0);
        } else {
            this.split.setDividerPositions(0.19);
        }
        this.map.repaint();
        this.mapFocus();
    }

    public void initComboBoxes() {
        this.radio_spreading_factor.getItems().removeAll((Collection<?>)this.radio_spreading_factor.getItems());
        this.radio_spreading_factor.getItems().addAll((String[])new String[]{"", "7", "8", "9", "10", "11", "12"});
        this.radio_spreading_factor.getSelectionModel().select(0);
        this.radio_code_rate.getItems().removeAll((Collection<?>)this.radio_code_rate.getItems());
        this.radio_code_rate.getItems().addAll((String[])new String[]{"0", "1", "2", "3", "4"});
        this.radio_code_rate.getSelectionModel().select(0);
        this.radio_conso_tx_model.getItems().removeAll((Collection<?>)this.radio_conso_tx_model.getItems());
        this.radio_conso_tx_model.getItems().addAll((String[])new String[]{"Classical (Tx)", "Heinzelman (Tx)", "(n/8.0)*etx*p", "0.00000005*n+0.0000000001*n*(r*p)"});
        this.radio_conso_tx_model.setValue("");
        this.radio_conso_rx_model.getItems().removeAll((Collection<?>)this.radio_conso_rx_model.getItems());
        this.radio_conso_rx_model.getItems().addAll((String[])new String[]{"Classical (Rx)", "Heinzelman (Rx)", "(n/8.0)*erx", "0.00000005*n"});
        this.radio_conso_rx_model.setValue("");
        this.radioStdComboBox.getItems().removeAll((Collection<?>)this.radioStdComboBox.getItems());
        this.radioStdComboBox.getItems().addAll((RadioStandardModel[])new RadioStandardModel[]{new RadioStandardModel("802.15.4", "ZIGBEE"), new RadioStandardModel("WiFi", "WIFI"), new RadioStandardModel("LoRa", "LORA")});
        this.radioStdComboBox.getSelectionModel().select(0);
        this.probaComboBox.getItems().removeAll((Collection<?>)this.probaComboBox.getItems());
        this.probaComboBox.getItems().addAll((String[])new String[]{"Probability", "a-Distribution", "AWGN"});
        this.probaComboBox.getSelectionModel().select(0);
        this.uartComboBox.getItems().removeAll((Collection<?>)this.uartComboBox.getItems());
        this.uartComboBox.getItems().addAll((String[])new String[]{"-", "2400", "3600", "4800", "9600", "38400", "115200"});
        this.uartComboBox.getSelectionModel().select(0);
        this.radioNameComboBox.getItems().removeAll((Collection<?>)this.radioNameComboBox.getItems());
        this.radioNameComboBox.getItems().addAll((String[])new String[]{"radio1", "radio2", "radio3", "radio4", "radio5", "radio6", "radio7", "radio8", "radio9", "radio10"});
        this.radioNameComboBox.getSelectionModel().select(0);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        if (CupCarbonApp.macos) {
            this.selectAllItem.setAccelerator(new KeyCodeCombination(KeyCode.A, KeyCombination.META_DOWN));
            this.undoItem.setAccelerator(new KeyCodeCombination(KeyCode.Z, KeyCombination.META_DOWN));
            this.redoItem.setAccelerator(new KeyCodeCombination(KeyCode.Y, KeyCombination.META_DOWN));
            this.newProjectItem.setAccelerator(new KeyCodeCombination(KeyCode.N, KeyCombination.META_DOWN));
            this.newProjectFromCurrentItem.setAccelerator(new KeyCodeCombination(KeyCode.N, KeyCombination.META_DOWN, KeyCombination.SHIFT_DOWN));
            this.openProjectItem.setAccelerator(new KeyCodeCombination(KeyCode.O, KeyCombination.META_DOWN));
            this.openLastProjectItem.setAccelerator(new KeyCodeCombination(KeyCode.O, KeyCombination.META_DOWN, KeyCombination.SHIFT_DOWN));
            this.saveProjectItem.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.META_DOWN));
            this.resetItem.setAccelerator(new KeyCodeCombination(KeyCode.R, KeyCombination.META_DOWN, KeyCombination.SHIFT_DOWN));
            this.menuBar.setUseSystemMenuBar(true);
        }
        this.initComboBoxes();
        this.gpsListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.deviceListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.eventListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.initRecentProjectMenu();
        this.initMap();
        try {
            System.out.println("> Welcome to CupCarbon");
            String licence = "-------------------------------------------------------------------------------------\nCopyright (C) 2025 CupCarbon\n-------------------------------------------------------------------------------------\nCupCarbon Klines 7.2\nSenScript V 5.1\n-------------------------------------------------------------------------------------\nwww.cupcarbon.com\n-------------------------------------------------------------------------------------\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.\n-------------------------------------------------------------------------------------\nThis is free software, and you are welcome to redistribute it\nunder certain conditions; see <http://www.gnu.org/licenses/>.\n-------------------------------------------------------------------------------------\nBy Ahcene Bounceur\n-------------------------------------------------------------------------------------";
            System.out.println(licence);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CupCarbonApp.internetIsAvailable()) {
            System.out.println("Connection: OK");
            WorldMap.changeMap(1);
        } else {
            System.out.println("Connection: NO");
        }
        try {
            this.console = new ConsoleWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void zoomP() {
        this.map.setZoom(this.map.getZoomSlider().getValue() - 1);
        MapLayer.updateFont();
        this.zoomLabel.setText("" + (19 - MapLayer.mapViewer.getZoom()));
        MapObject sensor = null;
        for (SensorNode s : DeviceList.sensors) {
            if (!s.isSelected()) continue;
            sensor = s;
            break;
        }
        if (sensor != null) {
            MapLayer.mapViewer.setCenterPosition(new GeoPosition(sensor.getLatitude(), sensor.getLongitude()));
        }
        this.mapFocus();
    }

    @FXML
    public void zoomM() {
        this.map.setZoom(this.map.getZoomSlider().getValue() + 1);
        MapLayer.updateFont();
        this.zoomLabel.setText("" + (19 - MapLayer.mapViewer.getZoom()));
        this.mapFocus();
    }

    @FXML
    public void simulateAgent() {
        WorldMap.simulate();
    }

    @FXML
    public void simulateAllAgent() {
        WorldMap.simulateAll();
    }

    @FXML
    public void simulateSensors() {
        WorldMap.simulateSensors();
    }

    @FXML
    public void simulateMobiles() {
        WorldMap.simulateMobiles();
    }

    @FXML
    public void stopAgentSimulation() {
        DeviceList.stopAgentSimulation();
    }

    @FXML
    public void initializeAll() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                ConsoleController.controller.clear();
                DeviceList.initAll();
                MapLayer.repaint();
                IoTSimulation.initAllProcesses();
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void openConsole() {
        this.console.toFront();
    }

    @FXML
    public void runFaultInjection() {
        this.faultInjector = new FaultInjector();
        this.faultInjector.start();
    }

    @FXML
    public void stopFaultInjection() {
        if (this.faultInjector != null) {
            this.faultInjector.stopInjection();
        }
    }

    @FXML
    public void generateArduinoCode() {
        Arduino.generateCode();
    }

    public static void runSenScriptEditor() {
        if (editor == null) {
            SwingUtilities.invokeLater(() -> {
                try {
                    UIManager.setLookAndFeel(UIManager.getLookAndFeel());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                editor = new SenScriptEditor();
                editor.setDefaultCloseOperation(1);
                editor.setVisible(true);
            });
        } else {
            editor.setVisible(true);
        }
    }

    @FXML
    public void openSenScriptWindow() {
        if (!Project.projectName.equals("")) {
            try {
                new SenScriptWindow();
            }
            catch (IOException iOException) {}
        } else {
            this.displayLongErrMessageTh("Project must be created first!");
        }
    }

    @FXML
    public void openPythonWindow() {
        if (!Project.projectName.equals("")) {
            try {
                new ProgramWindow();
            }
            catch (IOException iOException) {}
        } else {
            this.displayLongErrMessageTh("Project must be created first!");
        }
    }

    @FXML
    public void openMqttWindow() {
        try {
            new ExecutorPathConfigWindow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @FXML
    public void openNaturalEventGenerator() throws IOException {
        if (!Project.projectName.equals("")) {
            new NaturalEventGenerator();
        } else {
            this.displayLongErrMessageTh("Project must be created first!");
        }
    }

    @FXML
    public void addSensor() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                WorldMap.addNodeInMap('1');
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void addIoTNode() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                WorldMap.addNodeInMap('9');
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void addIoTRNode() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                WorldMap.addNodeInMap('&');
                CupCarbonController.this.mapFocus();
            }
        });
    }

    public void getShips() {
        try {
            String s = "[{\"AIS\":{\"MMSI\":403709610,\"TIMESTAMP\":\"2023-11-16 12:31:32 UTC\",\"LATITUDE\":26.62946,\"LONGITUDE\":50.15753,\"COURSE\":176.7,\"SPEED\":5.1,\"HEADING\":173,\"NAVSTAT\":0,\"IMO\":9312731,\"NAME\":\"QATIF\",\"CALLSIGN\":\"HZG5709\",\"TYPE\":90,\"A\":0,\"B\":0,\"C\":0,\"D\":0,\"DRAUGHT\":4.0,\"DESTINATION\":\"SFNY\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-13 04:00\",\"ETA\":\"2023-11-13 04:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":403731410,\"TIMESTAMP\":\"2023-11-16 11:34:07 UTC\",\"LATITUDE\":26.62833,\"LONGITUDE\":50.15833,\"COURSE\":360.0,\"SPEED\":0.0,\"HEADING\":511,\"NAVSTAT\":8,\"IMO\":0,\"NAME\":\"ALGOSAIBI 8\",\"CALLSIGN\":\"HZG5052\",\"TYPE\":52,\"A\":5,\"B\":14,\"C\":2,\"D\":4,\"DRAUGHT\":0.0,\"DESTINATION\":\"\",\"LOCODE\":\"\",\"ETA_AIS\":\"00-00 00:00\",\"ETA\":\"\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":356910000,\"TIMESTAMP\":\"2023-11-16 11:28:52 UTC\",\"LATITUDE\":26.63,\"LONGITUDE\":50.15833,\"COURSE\":161.0,\"SPEED\":0.0,\"HEADING\":511,\"NAVSTAT\":5,\"IMO\":9762209,\"NAME\":\"EXPRESS 89\",\"CALLSIGN\":\"HP3189\",\"TYPE\":40,\"A\":12,\"B\":28,\"C\":5,\"D\":2,\"DRAUGHT\":1.7,\"DESTINATION\":\"TANAJIB PIER\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-14 16:00\",\"ETA\":\"2023-11-14 16:00:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":572600220,\"TIMESTAMP\":\"2023-11-16 13:28:57 UTC\",\"LATITUDE\":26.63908,\"LONGITUDE\":50.17492,\"COURSE\":327.2,\"SPEED\":0.5,\"HEADING\":2,\"NAVSTAT\":1,\"IMO\":9962342,\"NAME\":\"RAWABI TITANIUM\",\"CALLSIGN\":\"T2XN5\",\"TYPE\":52,\"A\":14,\"B\":14,\"C\":6,\"D\":5,\"DRAUGHT\":4.8,\"DESTINATION\":\"RASTANURA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-12 01:00\",\"ETA\":\"2023-11-12 01:00:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":9,\"ETA_PREDICTED\":\"2023-11-16 05:38:43 UTC\"}},{\"AIS\":{\"MMSI\":572465220,\"TIMESTAMP\":\"2023-11-16 12:22:45 UTC\",\"LATITUDE\":26.66943,\"LONGITUDE\":50.1788,\"COURSE\":121.7,\"SPEED\":0.3,\"HEADING\":2,\"NAVSTAT\":0,\"IMO\":9912036,\"NAME\":\"RAWABI FREEDOM\",\"CALLSIGN\":\"T2SI5\",\"TYPE\":52,\"A\":11,\"B\":20,\"C\":4,\"D\":7,\"DRAUGHT\":5.8,\"DESTINATION\":\"RAS TANURAH\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-13 08:25\",\"ETA\":\"2023-11-13 08:25:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":10,\"ETA_PREDICTED\":\"2023-11-14 16:56:39 UTC\"}},{\"AIS\":{\"MMSI\":431877000,\"TIMESTAMP\":\"2023-11-16 14:37:19 UTC\",\"LATITUDE\":26.6794,\"LONGITUDE\":50.18613,\"COURSE\":115.7,\"SPEED\":2.0,\"HEADING\":102,\"NAVSTAT\":0,\"IMO\":9814117,\"NAME\":\"GEN-EI\",\"CALLSIGN\":\"7KBW\",\"TYPE\":80,\"A\":285,\"B\":54,\"C\":34,\"D\":26,\"DRAUGHT\":11.3,\"DESTINATION\":\">SA RTA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-15 12:00\",\"ETA\":\"2023-11-15 12:00:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":160,\"ETA_PREDICTED\":\"2023-11-18 08:13:47 UTC\"}},{\"AIS\":{\"MMSI\":576450000,\"TIMESTAMP\":\"2023-11-16 13:23:27 UTC\",\"LATITUDE\":26.60993,\"LONGITUDE\":50.1909,\"COURSE\":233.9,\"SPEED\":0.1,\"HEADING\":13,\"NAVSTAT\":1,\"IMO\":9586954,\"NAME\":\"LACOSTE TIDE\",\"CALLSIGN\":\"YJQV2\",\"TYPE\":52,\"A\":13,\"B\":46,\"C\":6,\"D\":7,\"DRAUGHT\":4.4,\"DESTINATION\":\"FREIGHTER ANCHORAGE\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-14 04:00\",\"ETA\":\"2023-11-14 04:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":375857000,\"TIMESTAMP\":\"2023-11-16 11:29:05 UTC\",\"LATITUDE\":26.62,\"LONGITUDE\":50.19166,\"COURSE\":243.0,\"SPEED\":0.0,\"HEADING\":511,\"NAVSTAT\":1,\"IMO\":9631515,\"NAME\":\"STANFORD HUNTER\",\"CALLSIGN\":\"J8B4826\",\"TYPE\":52,\"A\":10,\"B\":47,\"C\":9,\"D\":5,\"DRAUGHT\":4.4,\"DESTINATION\":\"MARJAN OF\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-14 10:00\",\"ETA\":\"2023-11-14 10:00:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":572464220,\"TIMESTAMP\":\"2023-11-16 18:39:05 UTC\",\"LATITUDE\":26.67166,\"LONGITUDE\":50.19166,\"COURSE\":116.0,\"SPEED\":0.0,\"HEADING\":511,\"NAVSTAT\":1,\"IMO\":9912024,\"NAME\":\"RAWABI PEARL\",\"CALLSIGN\":\"T2SH5\",\"TYPE\":52,\"A\":11,\"B\":20,\"C\":7,\"D\":4,\"DRAUGHT\":5.7,\"DESTINATION\":\"RAS TANURA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-11 04:22\",\"ETA\":\"2023-11-11 04:22:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":10,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":565056000,\"TIMESTAMP\":\"2023-11-16 13:16:22 UTC\",\"LATITUDE\":26.61374,\"LONGITUDE\":50.19487,\"COURSE\":4.1,\"SPEED\":0.0,\"HEADING\":8,\"NAVSTAT\":1,\"IMO\":9733648,\"NAME\":\"BRITOIL 73\",\"CALLSIGN\":\"9V2646\",\"TYPE\":52,\"A\":10,\"B\":45,\"C\":8,\"D\":7,\"DRAUGHT\":5.4,\"DESTINATION\":\"RT FREIGHTER ANCH.\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-14 21:30\",\"ETA\":\"2023-11-14 21:30:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":565443000,\"TIMESTAMP\":\"2023-11-16 11:29:48 UTC\",\"LATITUDE\":26.61,\"LONGITUDE\":50.195,\"COURSE\":150.0,\"SPEED\":0.0,\"HEADING\":511,\"NAVSTAT\":0,\"IMO\":9441661,\"NAME\":\"BRITOIL 22\",\"CALLSIGN\":\"9V6858\",\"TYPE\":36,\"A\":10,\"B\":31,\"C\":6,\"D\":6,\"DRAUGHT\":5.2,\"DESTINATION\":\"RAS TANURA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-15 09:15\",\"ETA\":\"2023-11-15 09:15:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":239,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":377709000,\"TIMESTAMP\":\"2023-11-16 13:04:51 UTC\",\"LATITUDE\":26.60639,\"LONGITUDE\":50.20153,\"COURSE\":150.5,\"SPEED\":0.0,\"HEADING\":10,\"NAVSTAT\":1,\"IMO\":9513945,\"NAME\":\"OCEAN CLEVER\",\"CALLSIGN\":\"J8B6044\",\"TYPE\":52,\"A\":18,\"B\":43,\"C\":8,\"D\":8,\"DRAUGHT\":4.4,\"DESTINATION\":\"FREIGHTER ANCHORAGE\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-12 18:00\",\"ETA\":\"2023-11-12 18:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":413518990,\"TIMESTAMP\":\"2023-11-16 13:30:52 UTC\",\"LATITUDE\":26.61977,\"LONGITUDE\":50.20174,\"COURSE\":196.5,\"SPEED\":0.0,\"HEADING\":4,\"NAVSTAT\":1,\"IMO\":9985356,\"NAME\":\"XIN CHEN DA YUN\",\"CALLSIGN\":\"BPGA9\",\"TYPE\":70,\"A\":16,\"B\":124,\"C\":21,\"D\":16,\"DRAUGHT\":3.4,\"DESTINATION\":\"RASTANURA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-08 09:00\",\"ETA\":\"2023-11-08 09:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":8,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":403591000,\"TIMESTAMP\":\"2023-11-16 17:40:22 UTC\",\"LATITUDE\":26.65536,\"LONGITUDE\":50.2087,\"COURSE\":181.0,\"SPEED\":3.6,\"HEADING\":207,\"NAVSTAT\":0,\"IMO\":9384227,\"NAME\":\"JALADI\",\"CALLSIGN\":\"HZHE\",\"TYPE\":0,\"A\":282,\"B\":51,\"C\":25,\"D\":35,\"DRAUGHT\":11.0,\"DESTINATION\":\"SARTA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-14 06:00\",\"ETA\":\"2023-11-14 06:00:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":10,\"ETA_PREDICTED\":\"2023-11-16 20:20:52 UTC\"}},{\"AIS\":{\"MMSI\":576254000,\"TIMESTAMP\":\"2023-11-16 13:11:28 UTC\",\"LATITUDE\":26.60595,\"LONGITUDE\":50.21017,\"COURSE\":339.9,\"SPEED\":0.0,\"HEADING\":0,\"NAVSTAT\":1,\"IMO\":9582180,\"NAME\":\"KIRKCONNELL TIDE\",\"CALLSIGN\":\"YJVV6\",\"TYPE\":52,\"A\":9,\"B\":50,\"C\":7,\"D\":7,\"DRAUGHT\":4.2,\"DESTINATION\":\"MANIFA INNER ANCH.\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-14 16:30\",\"ETA\":\"2023-11-14 16:30:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":576391000,\"TIMESTAMP\":\"2023-11-16 13:13:47 UTC\",\"LATITUDE\":26.6288,\"LONGITUDE\":50.22085,\"COURSE\":278.0,\"SPEED\":8.6,\"HEADING\":284,\"NAVSTAT\":0,\"IMO\":9421697,\"NAME\":\"DAY TIDE\",\"CALLSIGN\":\"YJVK3\",\"TYPE\":96,\"A\":18,\"B\":52,\"C\":7,\"D\":9,\"DRAUGHT\":4.5,\"DESTINATION\":\"RAS TANURA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-09 16:00\",\"ETA\":\"2023-11-09 16:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":8,\"ETA_PREDICTED\":\"2023-11-16 14:10:13 UTC\"}},{\"AIS\":{\"MMSI\":403101001,\"TIMESTAMP\":\"2023-11-16 13:41:51 UTC\",\"LATITUDE\":26.67224,\"LONGITUDE\":50.22168,\"COURSE\":106.4,\"SPEED\":3.0,\"HEADING\":88,\"NAVSTAT\":0,\"IMO\":9290294,\"NAME\":\"AL HABIBAH\",\"CALLSIGN\":\"HZLJ\",\"TYPE\":89,\"A\":210,\"B\":33,\"C\":20,\"D\":23,\"DRAUGHT\":8.0,\"DESTINATION\":\"RASTANURA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-16 13:00\",\"ETA\":\"2023-11-16 13:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":11,\"ETA_PREDICTED\":\"2023-11-16 17:07:55 UTC\"}},{\"AIS\":{\"MMSI\":565986000,\"TIMESTAMP\":\"2023-11-16 13:24:57 UTC\",\"LATITUDE\":26.62185,\"LONGITUDE\":50.22738,\"COURSE\":187.6,\"SPEED\":0.0,\"HEADING\":280,\"NAVSTAT\":5,\"IMO\":8769860,\"NAME\":\"COSLCONFIDENCE\",\"CALLSIGN\":\"9VGF7\",\"TYPE\":90,\"A\":49,\"B\":20,\"C\":17,\"D\":51,\"DRAUGHT\":8.5,\"DESTINATION\":\"\",\"LOCODE\":\"\",\"ETA_AIS\":\"00-00 24:60\",\"ETA\":\"\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":463036101,\"TIMESTAMP\":\"2023-11-16 18:43:38 UTC\",\"LATITUDE\":26.63745,\"LONGITUDE\":50.22876,\"COURSE\":315.0,\"SPEED\":0.6,\"HEADING\":22,\"NAVSTAT\":0,\"IMO\":9277541,\"NAME\":\"LAHORE\",\"CALLSIGN\":\"AQQC\",\"TYPE\":80,\"A\":209,\"B\":38,\"C\":30,\"D\":12,\"DRAUGHT\":6.0,\"DESTINATION\":\"RASTANURA KSA\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-14 16:00\",\"ETA\":\"2023-11-14 16:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":636015502,\"TIMESTAMP\":\"2023-11-16 13:02:30 UTC\",\"LATITUDE\":26.65786,\"LONGITUDE\":50.24106,\"COURSE\":104.2,\"SPEED\":0.1,\"HEADING\":13,\"NAVSTAT\":1,\"IMO\":9580417,\"NAME\":\"NAVE ESTELLA\",\"CALLSIGN\":\"D5BD6\",\"TYPE\":80,\"A\":188,\"B\":40,\"C\":20,\"D\":12,\"DRAUGHT\":12.4,\"DESTINATION\":\"SA JUB>SA RTA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-13 09:00\",\"ETA\":\"2023-11-13 09:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":11,\"ETA_PREDICTED\":\"2023-11-17 20:45:05 UTC\"}},{\"AIS\":{\"MMSI\":636021670,\"TIMESTAMP\":\"2023-11-16 15:18:17 UTC\",\"LATITUDE\":26.64436,\"LONGITUDE\":50.24143,\"COURSE\":66.2,\"SPEED\":2.1,\"HEADING\":20,\"NAVSTAT\":0,\"IMO\":9916185,\"NAME\":\"NAVE CELESTE\",\"CALLSIGN\":\"5LFC9\",\"TYPE\":80,\"A\":287,\"B\":52,\"C\":36,\"D\":24,\"DRAUGHT\":10.7,\"DESTINATION\":\"SA RTA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-16 13:00\",\"ETA\":\"2023-11-16 13:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":11,\"ETA_PREDICTED\":\"2023-11-16 19:34:25 UTC\"}},{\"AIS\":{\"MMSI\":352002324,\"TIMESTAMP\":\"2023-11-16 13:08:59 UTC\",\"LATITUDE\":26.63437,\"LONGITUDE\":50.24877,\"COURSE\":289.5,\"SPEED\":0.0,\"HEADING\":324,\"NAVSTAT\":1,\"IMO\":9944405,\"NAME\":\"BGMS BADER\",\"CALLSIGN\":\"3E2258\",\"TYPE\":80,\"A\":78,\"B\":19,\"C\":7,\"D\":11,\"DRAUGHT\":4.4,\"DESTINATION\":\"RAS TANNURA\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-15 19:49\",\"ETA\":\"2023-11-15 19:49:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":408570000,\"TIMESTAMP\":\"2023-11-16 12:57:06 UTC\",\"LATITUDE\":26.63984,\"LONGITUDE\":50.26552,\"COURSE\":287.6,\"SPEED\":0.2,\"HEADING\":129,\"NAVSTAT\":1,\"IMO\":9588110,\"NAME\":\"HADI 37\",\"CALLSIGN\":\"A9KR\",\"TYPE\":36,\"A\":11,\"B\":37,\"C\":5,\"D\":6,\"DRAUGHT\":2.5,\"DESTINATION\":\"RTE7EASTANCHORAGE\",\"LOCODE\":\"\",\"ETA_AIS\":\"00-00 00:00\",\"ETA\":\"\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":436000380,\"TIMESTAMP\":\"2023-11-16 03:00:02 UTC\",\"LATITUDE\":26.66069,\"LONGITUDE\":50.2683,\"COURSE\":277.7,\"SPEED\":1.3,\"HEADING\":73,\"NAVSTAT\":0,\"IMO\":9841031,\"NAME\":\"KABANBAY BATYR\",\"CALLSIGN\":\"UNIY\",\"TYPE\":0,\"A\":12,\"B\":13,\"C\":5,\"D\":6,\"DRAUGHT\":2.9,\"DESTINATION\":\"RAS TANURAH\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-13 14:30\",\"ETA\":\"2023-11-13 14:30:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":24,\"ETA_PREDICTED\":\"2023-11-14 01:37:00 UTC\"}},{\"AIS\":{\"MMSI\":403524001,\"TIMESTAMP\":\"2023-11-16 13:01:36 UTC\",\"LATITUDE\":26.63267,\"LONGITUDE\":50.26993,\"COURSE\":263.7,\"SPEED\":0.0,\"HEADING\":78,\"NAVSTAT\":1,\"IMO\":9660231,\"NAME\":\"ZAMIL 503\",\"CALLSIGN\":\"HZCH\",\"TYPE\":38,\"A\":10,\"B\":51,\"C\":10,\"D\":6,\"DRAUGHT\":4.0,\"DESTINATION\":\"FREIGHTER ANCHORAGE\",\"LOCODE\":\"\",\"ETA_AIS\":\"10-11 16:00\",\"ETA\":\"2023-10-11 16:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":305806000,\"TIMESTAMP\":\"2023-11-16 13:11:58 UTC\",\"LATITUDE\":26.60968,\"LONGITUDE\":50.27781,\"COURSE\":159.8,\"SPEED\":0.3,\"HEADING\":106,\"NAVSTAT\":1,\"IMO\":9811995,\"NAME\":\"BBC MANILA\",\"CALLSIGN\":\"V2HM3\",\"TYPE\":70,\"A\":132,\"B\":15,\"C\":6,\"D\":17,\"DRAUGHT\":7.0,\"DESTINATION\":\"SADMM\",\"LOCODE\":\"SADMM\",\"ETA_AIS\":\"11-16 16:00\",\"ETA\":\"2023-11-16 16:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":13,\"ETA_PREDICTED\":\"2023-11-18 08:29:09 UTC\"}},{\"AIS\":{\"MMSI\":377684000,\"TIMESTAMP\":\"2023-11-16 12:38:27 UTC\",\"LATITUDE\":26.63033,\"LONGITUDE\":50.28176,\"COURSE\":294.1,\"SPEED\":0.4,\"HEADING\":89,\"NAVSTAT\":0,\"IMO\":9901465,\"NAME\":\"DMS KITE\",\"CALLSIGN\":\"J8B5996\",\"TYPE\":52,\"A\":12,\"B\":20,\"C\":3,\"D\":6,\"DRAUGHT\":3.4,\"DESTINATION\":\"RAS TANURAH KSA\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-08 21:00\",\"ETA\":\"2023-11-08 21:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":376347000,\"TIMESTAMP\":\"2023-11-16 13:15:12 UTC\",\"LATITUDE\":26.6242,\"LONGITUDE\":50.28256,\"COURSE\":230.2,\"SPEED\":0.0,\"HEADING\":79,\"NAVSTAT\":1,\"IMO\":9545194,\"NAME\":\"ZAKHER CREST\",\"CALLSIGN\":\"J8B4229\",\"TYPE\":52,\"A\":11,\"B\":49,\"C\":3,\"D\":11,\"DRAUGHT\":3.7,\"DESTINATION\":\"RAS TANURA\",\"LOCODE\":\"SARTA\",\"ETA_AIS\":\"11-02 23:45\",\"ETA\":\"2023-11-02 23:45:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":11,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":352003014,\"TIMESTAMP\":\"2023-11-16 13:12:04 UTC\",\"LATITUDE\":26.62751,\"LONGITUDE\":50.28978,\"COURSE\":342.9,\"SPEED\":0.0,\"HEADING\":123,\"NAVSTAT\":1,\"IMO\":9654359,\"NAME\":\"BGP VICTOR\",\"CALLSIGN\":\"3E4753\",\"TYPE\":90,\"A\":18,\"B\":60,\"C\":10,\"D\":7,\"DRAUGHT\":4.8,\"DESTINATION\":\"RTE 7 ANCH\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-05 13:50\",\"ETA\":\"2023-11-05 13:50:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":470337000,\"TIMESTAMP\":\"2023-11-16 13:13:22 UTC\",\"LATITUDE\":26.64516,\"LONGITUDE\":50.29166,\"COURSE\":234.0,\"SPEED\":0.0,\"HEADING\":173,\"NAVSTAT\":1,\"IMO\":9577513,\"NAME\":\"NPCC SAADIYAT\",\"CALLSIGN\":\"A6E2408\",\"TYPE\":52,\"A\":18,\"B\":30,\"C\":7,\"D\":6,\"DRAUGHT\":3.8,\"DESTINATION\":\"RT7\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-16 03:00\",\"ETA\":\"2023-11-16 03:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}},{\"AIS\":{\"MMSI\":215622000,\"TIMESTAMP\":\"2023-11-16 13:53:41 UTC\",\"LATITUDE\":26.6247,\"LONGITUDE\":50.30686,\"COURSE\":62.9,\"SPEED\":10.5,\"HEADING\":60,\"NAVSTAT\":0,\"IMO\":9331919,\"NAME\":\"TAXIDIARA\",\"CALLSIGN\":\"9HA5214\",\"TYPE\":70,\"A\":162,\"B\":28,\"C\":13,\"D\":19,\"DRAUGHT\":6.2,\"DESTINATION\":\"AE MSA\",\"LOCODE\":\"AEMSA\",\"ETA_AIS\":\"11-17 12:00\",\"ETA\":\"2023-11-17 12:00:00\",\"SRC\":\"TER\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":316,\"ETA_PREDICTED\":\"2023-11-17 20:00:51 UTC\"}},{\"AIS\":{\"MMSI\":563086000,\"TIMESTAMP\":\"2023-11-16 11:28:37 UTC\",\"LATITUDE\":26.655,\"LONGITUDE\":50.31166,\"COURSE\":279.0,\"SPEED\":0.0,\"HEADING\":511,\"NAVSTAT\":1,\"IMO\":9324588,\"NAME\":\"PACIFIC 68\",\"CALLSIGN\":\"9V6473\",\"TYPE\":52,\"A\":10,\"B\":54,\"C\":10,\"D\":6,\"DRAUGHT\":4.2,\"DESTINATION\":\"RASTANURA, KSA\",\"LOCODE\":\"\",\"ETA_AIS\":\"11-10 16:00\",\"ETA\":\"2023-11-10 16:00:00\",\"SRC\":\"SAT\",\"ZONE\":\"Persian Gulf\",\"ECA\":false,\"DISTANCE_REMAINING\":null,\"ETA_PREDICTED\":null}}]";
            Platform.runLater(() -> {
                JSONArray jsonArray = new JSONArray(s);
                int i = 0;
                while (i < jsonArray.length()) {
                    int j = i++;
                    new Thread(() -> {
                        JSONObject vessel = jsonArray.getJSONObject(j).getJSONObject("AIS");
                        double lat = vessel.getDouble("LATITUDE");
                        double lon = vessel.getDouble("LONGITUDE");
                        System.out.println(lat);
                        String name = vessel.getString("NAME");
                        IoTNode iot = new IoTNode(lon, lat, 0.0, 0.0, 100.0, 20.0, -1, 10);
                        iot.setName(vessel.getString("NAME"));
                        iot.setMmsi("" + vessel.getInt("MMSI"));
                        iot.setImo("" + vessel.getInt("IMO"));
                        iot.setSpeed("" + vessel.getDouble("SPEED"));
                        iot.setShipType("" + vessel.getInt("TYPE"));
                        iot.setTimeStamp(vessel.getString("TIMESTAMP"));
                        iot.setDestination(vessel.getString("DESTINATION"));
                        iot.setCourse("" + vessel.getDouble("COURSE"));
                        boolean exist = false;
                        try {
                            for (IoTNode node : DeviceList.getIoTNodes()) {
                                if (!name.equals(node.getName())) continue;
                                exist = true;
                            }
                            if (!exist) {
                                CupActionAddIoTNode action = new CupActionAddIoTNode(iot);
                                MapLayer.addAction(action);
                                CupActionStack.execute();
                                MapLayer.repaint();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }).start();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getShips2() {
        Platform.runLater(() -> new Thread(() -> {
            try {
                IoTNode ioTNode = DeviceList.getSelectedIoTNode();
                double latm = ioTNode.getLatitude();
                double lonm = ioTNode.getLongitude();
                String imo = ioTNode.getImo();
                Object url = "";
                url = imo.isEmpty() ? "https://api.datalastic.com/api/v0/vessel_inradius?api-key=7be932bb-d704-477c-8186-e3f856d6cff4&lat=" + latm + "&lon=" + lonm + "&radius=50" : "https://api.datalastic.com/api/v0/vessel_inradius?api-key=7be932bb-d704-477c-8186-e3f856d6cff4&imo=" + imo + "&radius=50";
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                Request request = new Request.Builder().url((String)url).method("GET", null).build();
                Response response = client.newCall(request).execute();
                String s = response.body().string();
                JSONArray json = new JSONObject(s).getJSONObject("data").getJSONArray("vessels");
                int i = 0;
                while (i < json.length()) {
                    int j = i++;
                    new Thread(() -> {
                        JSONObject vessel = json.getJSONObject(j);
                        double lat = vessel.getDouble("lat");
                        double lon = vessel.getDouble("lon");
                        String name = vessel.getString("name");
                        IoTNode iot = new IoTNode(lon, lat, 0.0, 0.0, 100.0, 20.0, -1, 10);
                        iot.setName(vessel.getString("name"));
                        iot.setMmsi(vessel.getString("mmsi"));
                        iot.setImo(vessel.getString("imo"));
                        iot.setSpeed("" + vessel.getInt("speed"));
                        iot.setShipType(vessel.getString("type"));
                        iot.setTimeStamp("");
                        iot.setDestination(vessel.getString("destination"));
                        iot.setCourse("" + vessel.getInt("course"));
                        boolean exist = false;
                        for (IoTNode node : DeviceList.getIoTNodes()) {
                            if (!name.equals(node.getName())) continue;
                            exist = true;
                        }
                        if (!exist) {
                            CupActionAddIoTNode action = new CupActionAddIoTNode(iot);
                            MapLayer.addAction(action);
                            CupActionStack.execute();
                            MapLayer.repaint();
                        }
                    }).start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start());
    }

    @FXML
    public void runIoTSimulation() {
        this.runIoTSimulation2();
    }

    @FXML
    public void runIoTSimulation2() {
        MapLayer.wsnSimulation = false;
        if (!Project.projectName.equals("")) {
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    if (Executor.executorList.isEmpty()) {
                        System.err.println("Undefined Executor Path!");
                        CupCarbonController.this.displayLongErrMessageTh("Undefined Executor Path!");
                        try {
                            new ExecutorPathConfigWindow();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        System.out.println("Executor Path Defined!");
                        ConsoleController.controller.clear();
                        if (CupCarbonController.this.iotSimulation == null) {
                            CupCarbonController.this.iotSimulation = new IoTSimulation();
                        }
                        if (CupCarbonController.this.iotSimulation.ready()) {
                            CupCarbonController.this.qRunIoTSimulationButton.setDisable(true);
                            new Thread(CupCarbonController.this.iotSimulation).start();
                        } else {
                            CupCarbonController.this.displayLongErrMessageTh("IoT Nodes without Program!");
                        }
                    }
                }
            });
        } else {
            this.displayLongErrMessageTh("Project must be created first!");
        }
        this.mapFocus();
    }

    @FXML
    public void stopIoTSimulation() {
        Platform.runLater(() -> new Thread(() -> {
            this.displayShortGoodMessage("END of IoT Simulation!");
            MapLayer.iotSimulation = false;
            Simulation.setSimulating(false);
            this.qRunIoTSimulationButton.setDisable(false);
            for (SensorNode iotNode : DeviceList.sensors) {
                if (iotNode.getType() != 13) continue;
                ((IoTNode)iotNode).stopIoTScript();
            }
            IoTSimulation.initAllProcesses();
            MapLayer.repaint();
        }).start());
        this.mapFocus();
    }

    @FXML
    public void addGas() {
        WorldMap.addNodeInMap('2');
        this.mapFocus();
    }

    @FXML
    public void addWeather() {
        if (DeviceList.weather == null) {
            WorldMap.addNodeInMap('7');
            this.mapFocus();
        }
    }

    @FXML
    public void addDirectionalSensor() {
        WorldMap.addNodeInMap('4');
        this.mapFocus();
    }

    @FXML
    public void addBaseStation() {
        WorldMap.addNodeInMap('5');
        this.mapFocus();
    }

    @FXML
    public void addMobile() {
        WorldMap.addNodeInMap('6');
        this.mapFocus();
    }

    @FXML
    public void addMarker() {
        WorldMap.addNodeInMap('8');
        this.mapFocus();
    }

    @FXML
    public void connection() {
        this.saveButton.setDisable(false);
        DeviceList.resetPropagations();
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void propagation() {
        this.saveButton.setDisable(false);
        DeviceList.calculatePropagations();
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void propagation_vt() {
        this.saveButton.setDisable(false);
        DeviceList.calculatePropagations();
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void visibility() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                VisibilityLauncher.calculate();
            }
        });
    }

    @FXML
    public void stopSimulation() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.saveButton.setDisable(false);
                CupCarbonController.this.runSimulationButton.setDisable(false);
                CupCarbonController.this.qRunSimulationButton.setDisable(false);
                if (CupCarbonController.this.wisenSimulation != null) {
                    CupCarbonController.this.wisenSimulation.stopSimulation();
                }
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void runSimulation() {
        MapLayer.wsnSimulation = true;
        if (!Project.projectName.equals("")) {
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleController.controller.clear();
                    CupCarbonController.this.saveButton.setDisable(false);
                    CupCarbonController.this.runSimulationButton.setDisable(true);
                    CupCarbonController.this.qRunSimulationButton.setDisable(true);
                    CupCarbonController.this.simulationParametersApply();
                    CupCarbonController.this.wisenSimulation = new WisenSimulation();
                    if (CupCarbonController.this.wisenSimulation.ready()) {
                        Thread th = new Thread(CupCarbonController.this.wisenSimulation);
                        th.start();
                    } else {
                        WisenSimulation.updateButtons();
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("SenScript");
                        alert.setHeaderText(null);
                        alert.setContentText("Sensors without Script!");
                        alert.showAndWait();
                        CupCarbonController.this.selectSensorsWithoutScript();
                    }
                }
            });
        } else {
            this.displayLongErrMessageTh("Project must be created first!");
        }
        this.mapFocus();
    }

    @FXML
    public void simulationParametersApply() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.saveButton.setDisable(false);
                SimulationInputs.simulationTime = Double.parseDouble(CupCarbonController.this.simulationTimeTextField.getText());
                SimulationInputs.mobilityAndEvents = CupCarbonController.this.mobilityCheckBox.isSelected();
                SimulationInputs.visualDelay = Integer.parseInt(CupCarbonController.this.simulationSpeedTextField.getText());
                SimulationInputs.resultsWritingPeriod = Double.parseDouble(CupCarbonController.this.resultsWPeriod.getText());
                SimulationInputs.arrowsDelay = Integer.parseInt(CupCarbonController.this.arrowSpeedTextField.getText());
                SimulationInputs.displayLog = CupCarbonController.this.logCheckBox.isSelected();
                SimulationInputs.displayResults = CupCarbonController.this.resultsCheckBox.isSelected();
                SimulationInputs.ackType = CupCarbonController.this.probaComboBox.getSelectionModel().getSelectedIndex();
                double proba = Double.parseDouble(CupCarbonController.this.probaTextField.getText());
                SimulationInputs.ackProba = proba > 1.0 ? 1.0 : proba;
                SimulationInputs.showAckLinks = CupCarbonController.this.ackShowCheckBox.isSelected();
                SimulationInputs.ack = CupCarbonController.this.ackCheckBox.isSelected();
                SimulationInputs.symmetricalLinks = CupCarbonController.this.symmetricalLinkCheckBox.isSelected();
                SimulationInputs.clockDrift = CupCarbonController.this.clockDriftCheckBox.isSelected();
                SimulationInputs.visibility = CupCarbonController.this.visibilityCheckBox.isSelected();
                SimulationInputs.macLayer = CupCarbonController.this.macCheckBox.isSelected();
                proba = Double.parseDouble(CupCarbonController.this.macProbaTextField.getText());
                SimulationInputs.macProba = proba > 1.0 ? 1.0 : proba;
                MapLayer.repaint();
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void magnetic() throws Exception {
        MapLayer.magnetic = !MapLayer.magnetic;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void loopChecked() {
        if (this.loopCheckBox.isSelected()) {
            this.loopAfter.setDisable(false);
            this.loopNumber.setDisable(false);
        } else {
            this.loopAfter.setDisable(true);
            this.loopNumber.setDisable(true);
        }
        this.mapFocus();
    }

    @FXML
    public void deleteRoute() {
        String fileName = (String)this.gpsListView.getSelectionModel().getSelectedItem();
        File file = new File(Project.getProjectGpsPath() + File.separator + fileName);
        boolean delete = false;
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Delete " + fileName + "!");
        alert.setHeaderText(null);
        alert.setContentText("Delete the file?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            delete = true;
        }
        if (delete) {
            this.saveButton.setDisable(false);
            file.delete();
            this.getListOfRoutes();
            this.initScriptGpsEventComboBoxes();
            this.mapFocus();
        }
    }

    @FXML
    public void saveRoute() {
        if (!Project.projectName.equals("")) {
            if (MarkerList.size() > 0) {
                File gpsFolder = new File(Project.getProjectGpsPath());
                File[] gpsFiles = gpsFolder.listFiles();
                boolean found = false;
                String fileName = Project.getGpsFileExtension(this.txtFileName.getText());
                for (int i = 0; i < gpsFiles.length && !found; ++i) {
                    if (!gpsFiles[i].getName().equals(fileName)) continue;
                    found = true;
                }
                boolean saveOk = true;
                if (found) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Save " + this.txtFileName.getText() + " File!");
                    alert.setHeaderText(null);
                    alert.setContentText("Replace the file?");
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.CANCEL) {
                        saveOk = false;
                    }
                }
                if (saveOk) {
                    this.saveButton.setDisable(false);
                    this.txtFileName.setText(Project.getGpsFileExtension(this.txtFileName.getText()));
                    MarkerList.saveGpsCoords(this.txtFileName.getText(), this.txtTitle.getText(), this.txtFrom.getText(), this.txtTo.getText(), this.loopCheckBox.isSelected(), Integer.parseInt(this.loopAfter.getText()), Integer.parseInt(this.loopNumber.getText()), Integer.parseInt(this.wbsNumber.getText()));
                    this.getListOfRoutes();
                    this.initScriptGpsEventComboBoxes();
                    this.mapFocus();
                }
            } else {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("Warning!");
                alert.setHeaderText(null);
                alert.setContentText("No Markers.");
                alert.showAndWait();
            }
        } else {
            this.displayLongErrMessageTh("Project must be created first!");
        }
    }

    @FXML
    public void ackChecked() {
        if (this.ackCheckBox.isSelected()) {
            this.probaComboBox.setDisable(false);
            this.probaTextField.setDisable(false);
            this.ackShowCheckBox.setDisable(false);
        } else {
            this.probaComboBox.setDisable(true);
            this.probaTextField.setDisable(true);
            this.ackShowCheckBox.setDisable(true);
        }
        this.mapFocus();
    }

    @FXML
    public void macChecked() {
        if (this.macCheckBox.isSelected()) {
            this.macProbaTextField.setDisable(false);
        } else {
            this.macProbaTextField.setDisable(true);
        }
        this.mapFocus();
    }

    @FXML
    public void addRadioStd() {
        String radioName = (String)this.radioNameComboBox.getSelectionModel().getSelectedItem();
        String radioStd = ((RadioStandardModel)this.radioStdComboBox.getSelectionModel().getSelectedItem()).getStd();
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            RadioModule radioModule = RadioModule.newRadioModule(sensor, radioName, radioStd);
            CupActionAddRadioModule action = new CupActionAddRadioModule(sensor, radioModule);
            block.addAction(action);
            this.currentDevice = sensor;
        }
        if (block.size() > 0) {
            CupActionStack.add(block);
            CupActionStack.execute();
        }
        this.getNodeInformations();
        this.mapFocus();
    }

    @FXML
    public void removeRadioStd() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected() || sensor.getRadioModuleList().size() <= 1) continue;
            RadioModule radioModule = sensor.getRadioModuleByName(((String)this.radioListView.getSelectionModel().getSelectedItem()).split(" ")[0]);
            CupActionDeleteRadioModule action = new CupActionDeleteRadioModule(radioModule);
            block.addAction(action);
            this.currentDevice = sensor;
        }
        if (block.size() > 0) {
            CupActionStack.add(block);
            CupActionStack.execute();
        }
        this.getNodeInformations();
        this.mapFocus();
    }

    @FXML
    public void newProject() {
        Stage stage = new Stage();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("New CupCarbon Project");
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("CupCarbon", "*.*"));
        File file = fileChooser.showSaveDialog(stage);
        if (file != null) {
            Project.newProject(file.getParentFile().toString() + File.separator + file.getName().toString(), file.getName().toString(), true);
            CupCarbonApp.stage.setTitle("CupCarbon Klines 7.2 [" + file.getAbsolutePath().toString() + "]");
        }
        this.initScriptGpsEventComboBoxes();
    }

    @FXML
    public void newProjectFromCurrent() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("New CupCarbon Project");
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("CupCarbon", "*.*"));
        File file = fileChooser.showSaveDialog(CupCarbonApp.stage);
        if (file != null) {
            Project.newProject(file.getParentFile().toString() + File.separator + file.getName().toString(), file.getName().toString(), false);
            CupCarbonApp.stage.setTitle("CupCarbon Klines 7.2 [" + file.getAbsolutePath().toString() + "]");
            Project.saveProject();
            this.saveButton.setDisable(true);
        }
    }

    @FXML
    public void openProject() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Open CupCarbon file");
                fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("CupCarbon Sources", "*.cup"));
                File file = fileChooser.showOpenDialog(CupCarbonApp.stage);
                if (file != null) {
                    Project.openProject(file.getParentFile().toString(), file.getName().toString());
                    CupCarbonApp.stage.setTitle("CupCarbon Klines 7.2 [" + file.getAbsolutePath().toString() + "]");
                    CupCarbonController.this.openProjectLoadParameters();
                    CupCarbonController.this.displayShortMessage(file.getName());
                    CupCarbonController.this.qRunIoTSimulationButton.setDisable(false);
                }
            }
        });
    }

    public void createContextMenu() {
        CupCarbonContextMenu.create(this.swingNode, this);
    }

    public void openProjectLoadParameters() {
        CupCarbonApp.cupCarbonController.simulationParametersApply();
        this.loadSimulationParams();
        this.getListOfRoutes();
        this.updateObjectListView();
        this.initScriptGpsEventComboBoxes();
        this.createContextMenu();
        this.mapFocus();
    }

    @FXML
    public void reset() {
        CupCarbonApp.stage.setTitle("CupCarbon Klines 7.2");
        Project.reset();
    }

    @FXML
    public void quit() {
        System.exit(0);
    }

    public void initMap() {
        CupCarbonApp.cupCarbonController = this;
        this.map = new WorldMap();
        this.map.setZoomSliderVisible(false);
        this.map.setZoomButtonsVisible(false);
        this.map.setMiniMapVisible(false);
        this.map.getZoomSlider().setSnapToTicks(false);
        this.map.getZoomSlider().setPaintTicks(false);
        this.swingNode.setContent(this.map);
        this.swingNode.requestFocus();
        new Thread(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.textReady.setFill(new Color(0.1, 0.8, 0.8, 1.0));
                CupCarbonController.this.textReady.setText("CupCarbon Klines 7.2");
                CupCarbonController.this.textReady.setVisible(false);
                CupCarbonController.this.swingNode.setVisible(false);
                CupCarbonController.this.vbox.setVisible(true);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CupCarbonController.this.swingNode.setVisible(true);
                CupCarbonController.this.vbox.setVisible(false);
                for (int i = 250; i >= 0; --i) {
                    MapLayer.bg_transparency = i;
                    MapLayer.repaint();
                    try {
                        Thread.sleep(5L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                CupCarbonController.this.textReady.setVisible(true);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CupCarbonController.this.textReady.setVisible(false);
            }
        }).start();
    }

    public void loadSimulationParams() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FileInputStream in = new FileInputStream(Project.projectPath + File.separator + "config" + File.separator + "simulationParams.cfg");
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    CupCarbonController.this.simulationTimeTextField.setText(br.readLine().split(":")[1]);
                    CupCarbonController.this.mobilityCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.simulationSpeedTextField.setText(br.readLine().split(":")[1]);
                    CupCarbonController.this.arrowSpeedTextField.setText(br.readLine().split(":")[1]);
                    CupCarbonController.this.logCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.resultsCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.probaComboBox.getSelectionModel().select((int)Double.parseDouble(br.readLine().split(":")[1]));
                    CupCarbonController.this.probaTextField.setText(br.readLine().split(":")[1]);
                    CupCarbonController.this.ackShowCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.ackCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.symmetricalLinkCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.clockDriftCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.visibilityCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.resultsWPeriod.setText(br.readLine().split(":")[1]);
                    CupCarbonController.this.macCheckBox.setSelected(Boolean.parseBoolean(br.readLine().split(":")[1]));
                    CupCarbonController.this.macProbaTextField.setText(br.readLine().split(":")[1]);
                    CupCarbonController.this.ackChecked();
                    CupCarbonController.this.macChecked();
                    br.close();
                    in.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @FXML
    public void scriptFileApply() {
        CupAction action;
        String currentScriptFileName;
        CupActionBlock block = new CupActionBlock();
        String newScriptFileName = (String)this.scriptFileComboBox.getSelectionModel().getSelectedItem();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            currentScriptFileName = sensor.getScriptFileName();
            action = new CupActionModifSensorScriptFile(sensor, currentScriptFileName, newScriptFileName);
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            currentScriptFileName = device.getScriptFileName();
            action = new CupActionModifDeviceScriptFile(device, currentScriptFileName, newScriptFileName);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void nateventFileApply() {
        CupActionBlock block = new CupActionBlock();
        String newNatEventFileName = (String)this.nateventFileComboBox.getSelectionModel().getSelectedItem();
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            String currentNatEventFileName = device.getNatEventFileName();
            CupActionModifDeviceNatEventFile action = new CupActionModifDeviceNatEventFile(device, currentNatEventFileName, newNatEventFileName);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void gpsFileApply() {
        CupAction action;
        String currentGpsFileName;
        CupActionBlock block = new CupActionBlock();
        String newGpsFileName = (String)this.gpsFileComboBox.getSelectionModel().getSelectedItem();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            currentGpsFileName = sensor.getGPSFileName();
            action = new CupActionModifSensorGpsFile(sensor, currentGpsFileName, newGpsFileName);
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            currentGpsFileName = device.getGPSFileName();
            action = new CupActionModifDeviceGpsFile(device, currentGpsFileName, newGpsFileName);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void idApply() {
        CupAction action;
        int currentId;
        CupActionBlock block = new CupActionBlock();
        int newId = Integer.parseInt(this.device_id.getText());
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            currentId = sensor.getId();
            action = new CupActionModifSensorId(sensor, currentId, newId);
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            currentId = device.getId();
            action = new CupActionModifDeviceId(device, currentId, newId);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void longitudeApply() {
        CupActionBlock block = new CupActionBlock();
        double newLongitude = Double.parseDouble(this.device_longitude.getText());
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            double lo = sensor.getLongitude();
            double la = sensor.getLatitude();
            int[] coord = MapCalc.geoToPixelMapA(la, lo);
            System.out.println(coord[0]);
            System.out.println(coord[1]);
            double currentLongitude = sensor.getLongitude();
            CupActionModifSensorLongitude action = new CupActionModifSensorLongitude(sensor, currentLongitude, newLongitude);
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            double currentLongitude = device.getLongitude();
            CupActionModifDeviceLongitude action = new CupActionModifDeviceLongitude(device, currentLongitude, newLongitude);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void latitudeApply() {
        CupAction action;
        double currentLatitude;
        CupActionBlock block = new CupActionBlock();
        double newLatitude = Double.parseDouble(this.device_latitude.getText());
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            currentLatitude = sensor.getLatitude();
            action = new CupActionModifSensorLatitude(sensor, currentLatitude, newLatitude);
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            currentLatitude = device.getLatitude();
            action = new CupActionModifDeviceLatitude(device, currentLatitude, newLatitude);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void elevationApply() {
        CupAction action;
        double currentElevation;
        CupActionBlock block = new CupActionBlock();
        double newElevation = Double.parseDouble(this.device_elevation.getText());
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            currentElevation = sensor.getElevation();
            action = new CupActionModifSensorElevation(sensor, currentElevation, newElevation);
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            currentElevation = device.getElevation();
            action = new CupActionModifDeviceElevation(device, currentElevation, newElevation);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radiusApply() {
        CupAction action;
        double currentRadius;
        CupActionBlock block = new CupActionBlock();
        double newRadius = Double.parseDouble(this.device_radius.getText());
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            currentRadius = sensor.getRadius();
            action = new CupActionModifSensorRadius(sensor, currentRadius, newRadius);
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            currentRadius = device.getRadius();
            action = new CupActionModifDeviceRadius(device, currentRadius, newRadius);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void sensorRadiusApply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            double currentSradius = sensor.getSensorUnitRadius();
            double sRadius = Double.parseDouble(this.sensor_radius.getText());
            CupActionModifSensorUnitRadius action = new CupActionModifSensorUnitRadius(sensor, currentSradius, sRadius);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void suCoverageApply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            double currentCoverage = sensor.getSensorUnit().getCoverage();
            double sCoverage = Double.parseDouble(this.suCoverage.getText());
            if (sCoverage > 0.628) {
                sCoverage = 0.628;
            }
            if (sCoverage < 0.0) {
                sCoverage = 0.0;
            }
            this.suCoverage.setText("" + sCoverage);
            CupActionModifDirectionalSensorUnitCoverage action = new CupActionModifDirectionalSensorUnitCoverage(sensor, currentCoverage, sCoverage);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void markedChecked() {
        for (SensorNode sensorNode : DeviceList.getIoTNodes()) {
            if (!sensorNode.isSelected()) continue;
            sensorNode.setMarked(this.markedCheckBox.isSelected());
        }
        MapLayer.repaint();
    }

    @FXML
    public void nodeMessageApply() {
        for (SensorNode sensorNode : DeviceList.getIoTNodes()) {
            if (!sensorNode.isSelected()) continue;
            sensorNode.setMessage(this.nodeMessage.getText());
        }
        MapLayer.repaint();
    }

    public void setNodeMessageField(SensorNode sensor) {
        this.nodeMessage.setText(sensor.getMessage());
        MapLayer.repaint();
    }

    @FXML
    public void suDirectionApply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            double currentDirection = sensor.getSensorUnit().getDirection();
            double sDirection = Double.parseDouble(this.suDirection.getText());
            if (sDirection > 6.28) {
                sDirection = 6.28;
            }
            if (sDirection < 0.0) {
                sDirection = 0.0;
            }
            this.suDirection.setText("" + sDirection);
            CupActionModifDirectionalSensorUnitDirection action = new CupActionModifDirectionalSensorUnitDirection(sensor, currentDirection, sDirection);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void energyMaxApply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            double currentEmax = sensor.getBatteryLevel();
            double eMax = Double.parseDouble(this.device_emax.getText());
            CupActionModifSensorEnergyMax action = new CupActionModifSensorEnergyMax(sensor, currentEmax, eMax);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void sensingConsApply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            double currentCons = sensor.getBatteryConsumption();
            double newCons = Double.parseDouble(this.device_eSensing.getText());
            CupActionModifSensorUnitESensing action = new CupActionModifSensorUnitESensing(sensor, currentCons, newCons);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void uartApply() {
        CupActionBlock block = new CupActionBlock();
        long newRate = 0L;
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            long currentRate = sensor.getUartDataRate();
            if (this.uartComboBox.getSelectionModel().getSelectedIndex() != 0) {
                newRate = Long.parseLong((String)this.uartComboBox.getSelectionModel().getSelectedItem());
            }
            CupActionModifSensorUART action = new CupActionModifSensorUART(sensor, currentRate, newRate);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void driftApply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            double currentDrift = sensor.getSigmaOfDriftTime();
            double newDrift = Double.parseDouble(this.device_drift.getText());
            CupActionModifSensorDrift action = new CupActionModifSensorDrift(sensor, currentDrift, newDrift);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_nid_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            int currentNID = rm.getNId();
            int newNID = Integer.parseInt(this.radio_nid.getText());
            CupActionModifRadioNId action = new CupActionModifRadioNId(rm, currentNID, newNID);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void spreading_factor_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            int currentSF = ((RadioModule_Lora)rm).getSpreadingFactor();
            int newSP = Integer.parseInt((String)this.radio_spreading_factor.getSelectionModel().getSelectedItem());
            CupActionModifRadioSF action = new CupActionModifRadioSF(rm, currentSF, newSP);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void code_rate_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            int currentCR = ((RadioModule_Lora)rm).getCodeRate();
            int newCR = Integer.parseInt((String)this.radio_code_rate.getSelectionModel().getSelectedItem());
            CupActionModifRadioCR action = new CupActionModifRadioCR(rm, currentCR, newCR);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_conso_tx_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            String currentCM = rm.getRadioConsoTxModel();
            String newCM = (String)this.radio_conso_tx_model.getSelectionModel().getSelectedItem();
            CupActionModifRadioConsoTxModel action = new CupActionModifRadioConsoTxModel(rm, currentCM, newCM);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_conso_rx_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            String currentCM = rm.getRadioConsoRxModel();
            String newCM = (String)this.radio_conso_rx_model.getSelectionModel().getSelectedItem();
            CupActionModifRadioConsoRxModel action = new CupActionModifRadioConsoRxModel(rm, currentCM, newCM);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_my_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            int currentMy = rm.getMy();
            int newMy = Integer.parseInt(this.radio_my.getText());
            CupActionModifRadioMy action = new CupActionModifRadioMy(rm, currentMy, newMy);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_ch_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            int currentCh = rm.getCh();
            int newCh = Integer.parseInt(this.radio_ch.getText());
            CupActionModifRadioCh action = new CupActionModifRadioCh(rm, currentCh, newCh);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_pl_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            double currentPl = rm.getPl();
            double newPl = Double.parseDouble(this.radio_pl.getText());
            CupActionModifRadioPl action = new CupActionModifRadioPl(rm, currentPl, newPl);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_radius_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            double currentRadius = rm.getRadioRangeRadius();
            double newRadius = Double.parseDouble(this.radio_radius.getText());
            CupActionModifRadioRadius action = new CupActionModifRadioRadius(rm, currentRadius, newRadius);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_erx_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            double currentERx = rm.getERx();
            double newERx = Double.parseDouble(this.radio_erx.getText());
            CupActionModifRadioERx action = new CupActionModifRadioERx(rm, currentERx, newERx);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_etx_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            double currentETx = rm.getETx();
            double newETx = Double.parseDouble(this.radio_etx.getText());
            CupActionModifRadioETx action = new CupActionModifRadioETx(rm, currentETx, newETx);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_esleep_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            double currentESleep = rm.getESleep();
            double newESleep = Double.parseDouble(this.radio_esleep.getText());
            CupActionModifRadioESleep action = new CupActionModifRadioESleep(rm, currentESleep, newESleep);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_elisten_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            double currentEListen = rm.getEListen();
            double newEListen = Double.parseDouble(this.radio_elisten.getText());
            CupActionModifRadioEListen action = new CupActionModifRadioEListen(rm, currentEListen, newEListen);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void radio_drate_Apply() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String s = (String)this.radioListView.getItems().get(this.radioListView.getSelectionModel().getSelectedIndex());
            String radioName = s.split(" ")[0];
            RadioModule rm = sensor.getRadioModuleByName(radioName);
            int currentDataRate = rm.getRadioDataRate();
            int newDataRate = Integer.parseInt(this.radio_drate.getText());
            CupActionModifRadioDataRate action = new CupActionModifRadioDataRate(rm, currentDataRate, newDataRate);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    @FXML
    public void deleteSelected() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                MapLayer.nodeList.deleteIfSelected();
                MapLayer.markerList.deleteIfSelected();
                MapLayer.buildingList.deleteIfSelected();
                MapLayer.repaint();
                CupCarbonController.this.updateObjectListView();
                CupCarbonController.this.mapFocus();
            }
        });
    }

    public void checkMapMenuItem(int idx) {
        switch (idx) {
            case 0: {
                this.mapItem0.setSelected(true);
                break;
            }
            case 1: {
                this.mapItem1.setSelected(true);
                break;
            }
            case 2: {
                this.mapItem2.setSelected(true);
                break;
            }
            case 3: {
                this.mapItem3.setSelected(true);
                break;
            }
            case 4: {
                this.mapItem4.setSelected(true);
                break;
            }
            case 5: {
                this.mapItem5.setSelected(true);
                break;
            }
            case 6: {
                this.mapItem6.setSelected(true);
                break;
            }
            case 7: {
                this.mapItem7.setSelected(true);
                break;
            }
            case 8: {
                this.mapItem8.setSelected(true);
                break;
            }
            case 9: {
                this.mapItem9.setSelected(true);
                break;
            }
            case 10: {
                this.mapItem10.setSelected(true);
                break;
            }
            case 11: {
                this.mapItem11.setSelected(true);
                break;
            }
            case 12: {
                this.mapItem12.setSelected(true);
            }
        }
    }

    @FXML
    public void setMap0() {
        WorldMap.changeMap(0);
    }

    @FXML
    public void setMap1() {
        WorldMap.changeMap(1);
    }

    @FXML
    public void setMap2() {
        WorldMap.changeMap(2);
    }

    @FXML
    public void setMap3() {
        WorldMap.changeMap(3);
    }

    @FXML
    public void setMap4() {
        WorldMap.changeMap(4);
    }

    @FXML
    public void setMap5() {
        WorldMap.changeMap(5);
    }

    @FXML
    public void setMap6() {
        WorldMap.changeMap(6);
    }

    @FXML
    public void setMap7() {
        WorldMap.changeMap(7);
    }

    @FXML
    public void setMap8() {
        WorldMap.changeMap(8);
    }

    @FXML
    public void setMap9() {
        WorldMap.changeMap(9);
    }

    @FXML
    public void setMap10() {
        WorldMap.changeMap(10);
    }

    @FXML
    public void setMap11() {
        WorldMap.changeMap(11);
    }

    @FXML
    public void setMap12() {
        WorldMap.changeMap(12);
    }

    @FXML
    public void displayConnections() {
        for (SensorNode sensorNode : DeviceList.sensors) {
            sensorNode.setHide(1);
        }
        for (Device device : DeviceList.devices) {
            device.setHide(1);
        }
        NetworkParameters.drawRadioLinks = true;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void displayNodes() {
        for (SensorNode sensorNode : DeviceList.sensors) {
            sensorNode.setHide(1);
        }
        for (Device device : DeviceList.devices) {
            device.setHide(1);
        }
        NetworkParameters.drawRadioLinks = false;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void displaySensors() {
        for (SensorNode sensorNode : DeviceList.sensors) {
            sensorNode.setHide(4);
        }
        for (Device device : DeviceList.devices) {
            device.setHide(4);
        }
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void displayRadios() {
        NetworkParameters.drawRadioLinks = false;
        for (SensorNode d : DeviceList.sensors) {
            d.setHide(5);
        }
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void displayAll() {
        for (SensorNode sensorNode : DeviceList.sensors) {
            sensorNode.setHide(0);
        }
        for (Device device : DeviceList.devices) {
            device.setHide(0);
        }
        NetworkParameters.drawRadioLinks = true;
        MapLayer.repaint();
        this.mapFocus();
    }

    public void updateCoords() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (CupCarbonController.this.currentDevice != null) {
                    CupCarbonController.this.getDeviceInformations();
                }
            }
        });
    }

    public void getNodeInformations() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.initAllFields();
                CupCarbonController.this.currentDevice = null;
                for (Device device : DeviceList.devices) {
                    if (device == null || !device.isSelected() && !device.isInside()) continue;
                    CupCarbonController.this.currentDevice = device;
                    CupCarbonController.this.getDeviceInformations();
                }
                for (SensorNode sensorNode : DeviceList.sensors) {
                    if (sensorNode == null || !sensorNode.isSelected() && !sensorNode.isInside()) continue;
                    CupCarbonController.this.currentDevice = sensorNode;
                    CupCarbonController.this.getSensorInformations();
                    CupCarbonController.this.getRadioList();
                }
            }
        });
    }

    public void getDeviceInformations() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.initScriptGpsEventComboBoxes();
                CupCarbonController.this.scriptFileComboBox.setValue("");
                CupCarbonController.this.gpsFileComboBox.setValue("");
                CupCarbonController.this.nateventFileComboBox.setValue("");
                if (!CupCarbonController.this.currentDevice.getScriptFileName().equals("")) {
                    String[] scriptFile = CupCarbonController.this.currentDevice.getScriptFileName().split(Pattern.quote(File.separator));
                    String scriptFileName = scriptFile[scriptFile.length - 1];
                    CupCarbonController.this.scriptFileComboBox.setValue(scriptFileName);
                }
                if (!CupCarbonController.this.currentDevice.getGPSFileName().equals("")) {
                    String[] gpsFile = CupCarbonController.this.currentDevice.getGPSFileName().split(Pattern.quote(File.separator));
                    String gpsFileName = gpsFile[gpsFile.length - 1];
                    CupCarbonController.this.gpsFileComboBox.setValue(gpsFileName);
                }
                if (!CupCarbonController.this.currentDevice.getNatEventFileName().equals("")) {
                    String[] nateventFile = CupCarbonController.this.currentDevice.getNatEventFileName().split(Pattern.quote(File.separator));
                    String nateventFileName = nateventFile[nateventFile.length - 1];
                    CupCarbonController.this.nateventFileComboBox.setValue(nateventFileName);
                }
                CupCarbonController.this.device_id.setText("" + CupCarbonController.this.currentDevice.getId());
                CupCarbonController.this.device_longitude.setText("" + CupCarbonController.this.currentDevice.getLongitude());
                CupCarbonController.this.device_latitude.setText("" + CupCarbonController.this.currentDevice.getLatitude());
                CupCarbonController.this.device_elevation.setText("" + CupCarbonController.this.currentDevice.getElevation());
                CupCarbonController.this.device_radius.setText("" + CupCarbonController.this.currentDevice.getRadius());
                CupCarbonController.this.uartComboBox.setValue("" + CupCarbonController.this.currentDevice.getUartDataRate());
                CupCarbonController.this.device_drift.setText("" + CupCarbonController.this.currentDevice.getSigmaOfDriftTime());
                CupCarbonController.this.nodeMessage.setText(CupCarbonController.this.currentDevice.getMessage());
                CupCarbonController.this.markedCheckBox.setSelected(CupCarbonController.this.currentDevice.isMarked());
                CupCarbonController.this.updateLabeLInfos();
            }
        });
    }

    public void getSensorInformations() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (CupCarbonController.this.currentDevice != null) {
                    CupCarbonController.this.sensorName.setText(" of " + CupCarbonController.this.currentDevice.getName());
                }
                CupCarbonController.this.initScriptGpsEventComboBoxes();
                CupCarbonController.this.scriptFileComboBox.setValue("");
                CupCarbonController.this.gpsFileComboBox.setValue("");
                CupCarbonController.this.nateventFileComboBox.setValue("");
                if (CupCarbonController.this.currentDevice != null) {
                    String gpsFileName;
                    String[] gpsFile;
                    if (!CupCarbonController.this.currentDevice.getScriptFileName().equals("")) {
                        String[] scriptFile = CupCarbonController.this.currentDevice.getScriptFileName().split(Pattern.quote(File.separator));
                        String scriptFileName = scriptFile[scriptFile.length - 1];
                        CupCarbonController.this.scriptFileComboBox.setValue(scriptFileName);
                    }
                    if (!CupCarbonController.this.currentDevice.getGPSFileName().equals("")) {
                        gpsFile = CupCarbonController.this.currentDevice.getGPSFileName().split(Pattern.quote(File.separator));
                        gpsFileName = gpsFile[gpsFile.length - 1];
                        CupCarbonController.this.gpsFileComboBox.setValue(gpsFileName);
                    }
                    if (!CupCarbonController.this.currentDevice.getNatEventFileName().equals("")) {
                        gpsFile = CupCarbonController.this.currentDevice.getNatEventFileName().split(Pattern.quote(File.separator));
                        gpsFileName = gpsFile[gpsFile.length - 1];
                        CupCarbonController.this.nateventFileComboBox.setValue(gpsFileName);
                    }
                    CupCarbonController.this.device_id.setText("" + CupCarbonController.this.currentDevice.getId());
                    CupCarbonController.this.device_longitude.setText("" + CupCarbonController.this.currentDevice.getLongitude());
                    CupCarbonController.this.device_latitude.setText("" + CupCarbonController.this.currentDevice.getLatitude());
                    CupCarbonController.this.device_elevation.setText("" + CupCarbonController.this.currentDevice.getElevation());
                    CupCarbonController.this.device_radius.setText("" + CupCarbonController.this.currentDevice.getRadius());
                    CupCarbonController.this.sensor_radius.setText("" + CupCarbonController.this.currentDevice.getSensorUnitRadius());
                    CupCarbonController.this.suCoverage.setText("" + CupCarbonController.this.currentDevice.getSUCoverage());
                    CupCarbonController.this.suDirection.setText("" + CupCarbonController.this.currentDevice.getSUDirection());
                    CupCarbonController.this.device_emax.setText("" + CupCarbonController.this.currentDevice.getBatteryLevel());
                    CupCarbonController.this.device_eSensing.setText("" + CupCarbonController.this.currentDevice.getESensing());
                    CupCarbonController.this.uartComboBox.setValue("" + CupCarbonController.this.currentDevice.getUartDataRate());
                    CupCarbonController.this.device_drift.setText("" + CupCarbonController.this.currentDevice.getSigmaOfDriftTime());
                    CupCarbonController.this.nodeMessage.setText(CupCarbonController.this.currentDevice.getMessage());
                    CupCarbonController.this.markedCheckBox.setSelected(CupCarbonController.this.currentDevice.isMarked());
                    CupCarbonController.this.updateLabeLInfos();
                }
            }
        });
    }

    public void initScriptGpsEventComboBoxes() {
        File gpsFiles = new File(Project.getProjectGpsPath());
        String[] s = gpsFiles.list();
        if (s == null) {
            s = new String[1];
        }
        this.gpsFileComboBox.getItems().removeAll((Collection<?>)this.gpsFileComboBox.getItems());
        this.gpsFileComboBox.getItems().add("");
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null || s[i].startsWith(".")) continue;
            this.gpsFileComboBox.getItems().add(s[i]);
        }
        File scriptFiles = new File(Project.getProjectScriptPath());
        s = scriptFiles.list();
        if (s == null) {
            s = new String[1];
        }
        this.scriptFileComboBox.getItems().removeAll((Collection<?>)this.scriptFileComboBox.getItems());
        this.scriptFileComboBox.getItems().add("");
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null || s[i].startsWith(".")) continue;
            this.scriptFileComboBox.getItems().add(s[i]);
        }
        File neteventFiles = new File(Project.getProjectNatEventPath());
        s = neteventFiles.list();
        if (s == null) {
            s = new String[1];
        }
        this.nateventFileComboBox.getItems().removeAll((Collection<?>)this.nateventFileComboBox.getItems());
        this.nateventFileComboBox.getItems().add("");
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null || s[i].startsWith(".")) continue;
            this.nateventFileComboBox.getItems().add(s[i]);
        }
    }

    public void getRadioList() {
        SensorNode sensor = (SensorNode)this.currentDevice;
        this.radioListView.getItems().removeAll((Collection<?>)this.radioListView.getItems());
        int i = 0;
        int idx = 0;
        for (RadioModule radio : sensor.getRadioModuleList()) {
            String s = "";
            if (radio == ((SensorNode)this.currentDevice).getCurrentRadioModule()) {
                s = "<-";
                idx = i;
            }
            this.radioListView.getItems().add(radio.getName() + " [" + radio.getStandardName() + "] " + s);
            ++i;
        }
        this.radioListView.getSelectionModel().select(idx);
    }

    @FXML
    public void getRadioInformations() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (!CupCarbonController.this.radioListView.getSelectionModel().isEmpty()) {
                    String s = (String)CupCarbonController.this.radioListView.getItems().get(CupCarbonController.this.radioListView.getSelectionModel().getSelectedIndex());
                    String radioName = s.split(" ")[0];
                    RadioModule rm = ((SensorNode)CupCarbonController.this.currentDevice).getRadioModuleByName(radioName);
                    CupCarbonController.this.radio_my.setText("" + rm.getMy());
                    CupCarbonController.this.radio_ch.setText("" + rm.getCh());
                    CupCarbonController.this.radio_pl.setText("" + rm.getPl());
                    CupCarbonController.this.radio_nid.setText("" + rm.getNId());
                    CupCarbonController.this.radio_radius.setText("" + rm.getRadioRangeRadius());
                    CupCarbonController.this.radio_etx.setText("" + rm.getETx());
                    CupCarbonController.this.radio_erx.setText("" + rm.getERx());
                    CupCarbonController.this.radio_esleep.setText("" + rm.getESleep());
                    CupCarbonController.this.radio_elisten.setText("" + rm.getEListen());
                    CupCarbonController.this.radio_drate.setText("" + rm.getRadioDataRate());
                    if (rm.getSpreadingFactor() == -1) {
                        CupCarbonController.this.radio_spreading_factor.setDisable(true);
                        CupCarbonController.this.spreading_factor_apply_button.setDisable(true);
                        CupCarbonController.this.radio_spreading_factor.getSelectionModel().select(0);
                    } else {
                        CupCarbonController.this.radio_spreading_factor.setDisable(false);
                        CupCarbonController.this.spreading_factor_apply_button.setDisable(false);
                        CupCarbonController.this.radio_spreading_factor.getSelectionModel().select("" + rm.getSpreadingFactor());
                    }
                    if (rm.getCodeRate() == -1) {
                        CupCarbonController.this.radio_code_rate.setDisable(true);
                        CupCarbonController.this.code_rate_apply_button.setDisable(true);
                        CupCarbonController.this.radio_code_rate.getSelectionModel().select(0);
                    } else {
                        CupCarbonController.this.radio_code_rate.setDisable(false);
                        CupCarbonController.this.code_rate_apply_button.setDisable(false);
                        CupCarbonController.this.radio_code_rate.getSelectionModel().select("" + rm.getCodeRate());
                    }
                    CupCarbonController.this.radio_conso_tx_model.getSelectionModel().select(rm.getRadioConsoTxModel());
                    CupCarbonController.this.radio_conso_rx_model.getSelectionModel().select(rm.getRadioConsoRxModel());
                }
            }
        });
    }

    @FXML
    public void setCurrentRadio() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String currentRadioModule = sensor.getCurrentRadioModule().getName();
            String newRadioModule = ((String)this.radioListView.getSelectionModel().getSelectedItem()).split(" ")[0];
            CupActionModifSensorCurrentRadio action = new CupActionModifSensorCurrentRadio(sensor, currentRadioModule, newRadioModule);
            block.addAction(action);
            this.currentDevice = sensor;
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        this.getNodeInformations();
        if (DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
        MapLayer.repaint();
    }

    @FXML
    public void openHelpWindow() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Help!");
        alert.setHeaderText("Please, visit our web page www.cupcarbon.com");
        alert.setContentText(null);
        alert.showAndWait();
    }

    @FXML
    public void openAboutWindow() throws IOException {
        Stage stage = new Stage();
        stage.setTitle("About CupCarbon");
        stage.initStyle(StageStyle.TRANSPARENT);
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(this.getClass().getResource("about.fxml"));
        VBox panneau = (VBox)loader.load();
        Scene scene = new Scene(panneau, Color.TRANSPARENT);
        stage.setScene(scene);
        stage.initOwner(CupCarbonApp.stage);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
    }

    @FXML
    public void myAction() {
        MyClass myclass = new MyClass();
        myclass.start();
    }

    @FXML
    public void example() {
        ExampleClass exc = new ExampleClass();
        exc.start();
    }

    @FXML
    public void monAlgo() {
        MonAlgoClass monAlgo = new MonAlgoClass();
        monAlgo.start();
    }

    @FXML
    public void sensorCoverage() {
        SensorSetCover.sensorSetCover();
    }

    @FXML
    public void sensorCycle() {
        CycleFromNode cfm = new CycleFromNode();
        cfm.start();
    }

    @FXML
    public void targetCoverage() {
        SensorSetCover.sensorTargetSetCover();
    }

    @FXML
    public void networkCenter() {
        NetworkCenter netcenter = new NetworkCenter();
        netcenter.start();
    }

    @FXML
    public void pEnvelope() {
        NetworkEnvelopeP npb = new NetworkEnvelopeP(true);
        npb.start();
    }

    @FXML
    public void pEnvelopeWithConnections() {
        NetworkEnvelopeP npb = new NetworkEnvelopeP(false);
        npb.start();
    }

    @FXML
    public void runJarvisAlgorithm() {
        EnvelopeJarvis envJarvis = new EnvelopeJarvis();
        envJarvis.start();
    }

    @FXML
    public void runLPCNAlgorithm_wc() {
        EnvelopeLPCN_wc lpcn = new EnvelopeLPCN_wc();
        lpcn.start();
    }

    @FXML
    public void runLPCNAlgorithm() {
        EnvelopeLPCN lpcn = new EnvelopeLPCN();
        lpcn.start();
    }

    @FXML
    public void runGrahamAlgo() {
        NetworkEnvelopeC npb = new NetworkEnvelopeC();
        npb.start();
    }

    @FXML
    public void runPersonalAlgo() {
        NetworkPerso npb = new NetworkPerso();
        npb.start();
    }

    @FXML
    public void selectAll() {
        WorldMap.setSelectionOfAllNodes(true, -1, true);
        WorldMap.setSelectionOfAllMarkers(true, true);
        this.deviceListView.getSelectionModel().selectAll();
        this.eventListView.getSelectionModel().selectAll();
        this.initScriptGpsEventComboBoxes();
        MapLayer.multipleSelection = true;
        this.getNodeInformations();
        MapLayer.lastKey = '\u0000';
        this.mapFocus();
    }

    @FXML
    public void deselectAll() {
        WorldMap.setSelectionOfAllNodes(false, -1, false);
        WorldMap.setSelectionOfAllMarkers(false, true);
        WorldMap.setSelectionOfAllBuildings(false, false);
        this.deviceListView.getSelectionModel().clearSelection();
        this.eventListView.getSelectionModel().clearSelection();
        this.mapFocus();
    }

    @FXML
    public void selectInv() {
        WorldMap.invertSelection();
        this.updateSelectionInListView();
    }

    @FXML
    public void selectById() {
        DeviceList.selectById(this.bytxtfield.getText());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectByMy() {
        DeviceList.selectByMy(this.bytxtfield.getText());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectByLed() {
        DeviceList.selectByLed(this.bytxtfield.getText());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectSensorsWithoutScript() {
        DeviceList.selectWitoutScript();
        this.updateSelectionInListView();
    }

    @FXML
    public void selectSensorsWithoutGps() {
        DeviceList.selectWitoutGps();
        this.updateSelectionInListView();
    }

    @FXML
    public void selectMarkedSensors() {
        DeviceList.selectMarkedSensors();
        this.updateSelectionInListView();
    }

    @FXML
    public void selectDeadSensors() {
        DeviceList.selectDeadSensors();
        this.updateSelectionInListView();
    }

    @FXML
    public void selectAllSensors() {
        WorldMap.setSelectionOfAllNodes(true, 1, this.addSelectionMenuItem.isSelected());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectAllnaturalEvents() {
        WorldMap.setSelectionOfAllNodes(true, 2, this.addSelectionMenuItem.isSelected());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectAllMobiles() {
        WorldMap.setSelectionOfAllNodes(true, 6, this.addSelectionMenuItem.isSelected());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectAllMobileSensors() {
        WorldMap.setSelectionOfAllMobileNodes(true, 1, this.addSelectionMenuItem.isSelected());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectAllDirectionalSensors() {
        WorldMap.setSelectionOfAllNodes(true, 5, this.addSelectionMenuItem.isSelected());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectAllBaseStations() {
        WorldMap.setSelectionOfAllNodes(true, 4, this.addSelectionMenuItem.isSelected());
        this.updateSelectionInListView();
    }

    @FXML
    public void selectAllMarkers() {
        WorldMap.setSelectionOfAllMarkers(true, this.addSelectionMenuItem.isSelected());
        this.mapFocus();
    }

    @FXML
    public void selectAllBuildings() {
        WorldMap.setSelectionOfAllBuildings(true, this.addSelectionMenuItem.isSelected());
        this.updateSelectionInListView();
    }

    @FXML
    public void deselectAllSensors() {
        WorldMap.setSelectionOfAllNodes(false, 1, false);
        this.updateSelectionInListView();
    }

    @FXML
    public void deselectAllnaturalEvents() {
        WorldMap.setSelectionOfAllNodes(false, 2, true);
        this.updateSelectionInListView();
    }

    @FXML
    public void deselectAllMobiles() {
        WorldMap.setSelectionOfAllNodes(false, 6, true);
        this.updateSelectionInListView();
    }

    @FXML
    public void deselectAllMobileSensors() {
        WorldMap.setSelectionOfAllMobileNodes(false, 1, true);
        this.updateSelectionInListView();
    }

    @FXML
    public void deselectAllDirectionalSensors() {
        WorldMap.setSelectionOfAllNodes(false, 5, true);
        this.updateSelectionInListView();
    }

    @FXML
    public void deselectAllBaseStations() {
        WorldMap.setSelectionOfAllNodes(false, 4, true);
        this.updateSelectionInListView();
    }

    @FXML
    public void deselectAllMarkers() {
        WorldMap.setSelectionOfAllMarkers(false, true);
        this.updateSelectionInListView();
    }

    @FXML
    public void deselectAllBuildings() {
        WorldMap.setSelectionOfAllBuildings(false, this.addSelectionCheckBox.isSelected());
        this.updateSelectionInListView();
    }

    @FXML
    public void routeFromMarkers() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.saveButton.setDisable(false);
                MarkerList.generateOSMRouteFile();
                CupCarbonController.this.selectAllMarkers();
                CupCarbonController.this.mapFocus();
            }
        });
    }

    public void initAllFields() {
        this.scriptFileComboBox.getSelectionModel().select(0);
        this.gpsFileComboBox.getSelectionModel().select(0);
        this.nateventFileComboBox.getSelectionModel().select(0);
        this.device_id.setText("");
        this.device_longitude.setText("");
        this.device_latitude.setText("");
        this.device_elevation.setText("");
        this.device_radius.setText("");
        this.sensor_radius.setText("");
        this.device_emax.setText("");
        this.device_eSensing.setText("");
        this.uartComboBox.getSelectionModel().select(0);
        this.device_drift.setText("");
        this.sensorName.setText("");
        this.radioListView.getItems().removeAll((Collection<?>)this.radioListView.getItems());
        this.radioNameComboBox.getSelectionModel().select(0);
        this.radio_my.setText("");
        this.radio_ch.setText("");
        this.radio_pl.setText("");
        this.radio_nid.setText("");
        this.radio_radius.setText("");
        this.radio_etx.setText("");
        this.radio_erx.setText("");
        this.radio_esleep.setText("");
        this.radio_elisten.setText("");
        this.radio_drate.setText("");
        this.radio_spreading_factor.getSelectionModel().select(0);
        this.radio_code_rate.getSelectionModel().select(0);
        this.radio_conso_tx_model.setValue("");
        this.radio_conso_rx_model.setValue("");
        this.nodeMessage.setText("");
        this.markedCheckBox.setSelected(false);
        this.numberOfDevices.setText("N = " + DeviceList.getSize());
    }

    public void initListViewSelections() {
        this.deviceListView.getSelectionModel().clearSelection();
        this.eventListView.getSelectionModel().clearSelection();
    }

    @FXML
    public void updateObjectListView() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.deviceListView.getItems().removeAll((Collection<?>)CupCarbonController.this.deviceListView.getItems());
                CupCarbonController.this.eventListView.getItems().removeAll((Collection<?>)CupCarbonController.this.eventListView.getItems());
                for (Device device : DeviceList.devices) {
                    if (device.getType() == 2) {
                        CupCarbonController.this.eventListView.getItems().add(device.getName());
                        continue;
                    }
                    CupCarbonController.this.deviceListView.getItems().add(device.getName());
                }
                for (int i = 0; i < DeviceList.sensors.size(); ++i) {
                    CupCarbonController.this.deviceListView.getItems().add(DeviceList.sensors.get(i).getName());
                }
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void updateSelectionInListView() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                int i;
                CupCarbonController.this.deviceListView.getSelectionModel().clearSelection();
                CupCarbonController.this.eventListView.getSelectionModel().clearSelection();
                for (i = 0; i < DeviceList.devices.size(); ++i) {
                    if (DeviceList.devices.get(i).getType() == 2) {
                        if (!DeviceList.devices.get(i).isSelected()) continue;
                        CupCarbonController.this.eventListView.getSelectionModel().select(DeviceList.devices.get(i).getName());
                        continue;
                    }
                    if (!DeviceList.devices.get(i).isSelected()) continue;
                    CupCarbonController.this.deviceListView.getSelectionModel().select(DeviceList.devices.get(i).getName());
                }
                for (i = 0; i < DeviceList.sensors.size(); ++i) {
                    if (!DeviceList.sensors.get(i).isSelected()) continue;
                    CupCarbonController.this.deviceListView.getSelectionModel().select(DeviceList.sensors.get(i).getName());
                }
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void selectDevicesOfTheListView() {
        DeviceList.deselectAllObjects();
        ObservableList<String> selectedItems = this.deviceListView.getSelectionModel().getSelectedItems();
        for (String name : selectedItems) {
            DeviceList.getNodeByName(name).setSelected(true);
        }
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void selectEventsOfTheListView() {
        DeviceList.deselectAllEvents();
        ObservableList<String> selectedItems = this.eventListView.getSelectionModel().getSelectedItems();
        for (String name : selectedItems) {
            DeviceList.getNodeByName(name).setSelected(true);
        }
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void getEventsSelection() {
        ObservableList<String> selectedItems = this.eventListView.getSelectionModel().getSelectedItems();
        int id = 0;
        for (String s : selectedItems) {
            id = Integer.parseInt(s.replaceAll("[^0-9]", ""));
            DeviceList.getNodeById(id).setSelected(true);
        }
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void getListOfRoutes() {
        this.gpsListView.getItems().removeAll((Collection<?>)this.gpsListView.getItems());
        File gpsFolder = new File(Project.getProjectGpsPath());
        File[] gpsFiles = gpsFolder.listFiles();
        if (gpsFolder.exists()) {
            for (int i = 0; i < gpsFiles.length; ++i) {
                if (gpsFiles[i].getName().startsWith(".")) continue;
                this.gpsListView.getItems().add(gpsFiles[i].getName());
            }
        }
    }

    @FXML
    public void loadRoute() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (!CupCarbonController.this.gpsListView.getSelectionModel().isEmpty()) {
                    CupCarbonController.this.saveButton.setDisable(false);
                    String gpsFileName = (String)CupCarbonController.this.gpsListView.getItems().get(CupCarbonController.this.gpsListView.getSelectionModel().getSelectedIndex());
                    MarkerList.open(Project.getProjectGpsPath() + File.separator + gpsFileName);
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(Project.getProjectGpsPath() + File.separator + gpsFileName));
                        CupCarbonController.this.txtFileName.setText(gpsFileName);
                        String line = br.readLine();
                        CupCarbonController.this.txtTitle.setText(line);
                        line = br.readLine();
                        CupCarbonController.this.txtFrom.setText(line);
                        line = br.readLine();
                        CupCarbonController.this.txtTo.setText(line);
                        line = br.readLine();
                        CupCarbonController.this.loopCheckBox.setSelected(Boolean.valueOf(line));
                        if (CupCarbonController.this.loopCheckBox.isSelected()) {
                            CupCarbonController.this.loopAfter.setDisable(false);
                            CupCarbonController.this.loopNumber.setDisable(false);
                        } else {
                            CupCarbonController.this.loopAfter.setDisable(true);
                            CupCarbonController.this.loopNumber.setDisable(true);
                        }
                        line = br.readLine();
                        CupCarbonController.this.loopNumber.setText(line);
                        br.close();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @FXML
    public void loadBuildings() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.saveButton.setDisable(false);
                BuildingList.loadFromOsm();
            }
        });
    }

    @FXML
    public void escape() {
        MapLayer.escape();
    }

    @FXML
    public void addSelectionMIAction() {
        this.addSelectionCheckBox.setSelected(this.addSelectionMenuItem.isSelected());
    }

    @FXML
    public void addSelectionCBAction() {
        this.addSelectionMenuItem.setSelected(this.addSelectionCheckBox.isSelected());
    }

    @FXML
    public void duplicate() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                MapLayer.duplicate();
                MapLayer.repaint();
            }
        });
    }

    @FXML
    public void generateRandomNetwork50() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                DeviceList.addRandomSensors(50, 0);
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void generateRandomNetwork100() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                DeviceList.addRandomSensors(100, 0);
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void generateRandomNetwork200() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                DeviceList.addRandomSensors(200, 0);
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void generateRandomNetwork500() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.displayNodes();
                NetworkParameters.drawRadioLinks = false;
                DeviceList.addRandomSensors(500, 1);
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void generateRandomNetwork1000() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                boolean b = DeviceList.propagationsCalculated;
                DeviceList.propagationsCalculated = false;
                CupCarbonController.this.displayNodes();
                NetworkParameters.drawRadioLinks = false;
                DeviceList.addRandomSensors(1000, 1);
                DeviceList.propagationsCalculated = b;
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void generateRandomNetwork10() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.displayNodes();
                NetworkParameters.drawRadioLinks = false;
                DeviceList.addRandomSensors(10, 0);
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void drawGraph() throws IOException {
        if (!Project.projectName.equals("")) {
            new EnergyDrawWindow();
        }
    }

    @FXML
    public void showFileNames() {
        NetworkParameters.drawScriptFileName = !NetworkParameters.drawScriptFileName;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showDetails() {
        NetworkParameters.displayDetails = !NetworkParameters.displayDetails;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showBatteryBufferLevels() {
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            sensor.invertDrawBatteryLevel();
        }
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showRadioMessages() {
        NetworkParameters.displayRadioMessages = !NetworkParameters.displayRadioMessages;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showRadioDistances() {
        NetworkParameters.displayRLDistance = !NetworkParameters.displayRLDistance;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showMarkerDistances() {
        NetworkParameters.displayMarkerDistance = !NetworkParameters.displayMarkerDistance;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showLinks() {
        NetworkParameters.drawRadioLinks = !NetworkParameters.drawRadioLinks;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showSensorArrows() {
        NetworkParameters.drawSensorArrows = !NetworkParameters.drawSensorArrows;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showMarkerArrows() {
        NetworkParameters.drawMarkerArrows = !NetworkParameters.drawMarkerArrows;
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void showBuildings() {
        BuildingList.showHideBuildings();
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void nextLinkColor() {
        MapLayer.nextLinkColor('v');
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void prevLinkColor() {
        MapLayer.nextLinkColor('V');
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void selectNodesMarkers() {
        MapLayer.selectNodesMarkers();
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void applyParameters() {
        this.simulationParametersApply();
    }

    @FXML
    public void undo() {
        CupActionStack.antiExecute();
        if (CupCarbonApp.cupCarbonController != null) {
            CupCarbonApp.cupCarbonController.updateObjectListView();
            CupCarbonApp.cupCarbonController.getNodeInformations();
            CupCarbonApp.cupCarbonController.getRadioInformations();
            CupCarbonApp.cupCarbonController.updateSelectionInListView();
        }
        if (DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void redo() {
        CupActionStack.execute();
        if (CupCarbonApp.cupCarbonController != null) {
            CupCarbonApp.cupCarbonController.updateObjectListView();
            CupCarbonApp.cupCarbonController.getNodeInformations();
            CupCarbonApp.cupCarbonController.getRadioInformations();
            CupCarbonApp.cupCarbonController.updateSelectionInListView();
        }
        if (DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void openRecentProject1() {
        this.openIthRecentProject(1);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject2() {
        this.openIthRecentProject(2);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject3() {
        this.openIthRecentProject(3);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject4() {
        this.openIthRecentProject(4);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject5() {
        this.openIthRecentProject(5);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject6() {
        this.openIthRecentProject(6);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject7() {
        this.openIthRecentProject(7);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject8() {
        this.openIthRecentProject(8);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject9() {
        this.openIthRecentProject(9);
        this.initRecentProjectMenu();
    }

    @FXML
    public void openRecentProject10() {
        this.openIthRecentProject(10);
        this.initRecentProjectMenu();
    }

    public void initRecentProjectMenu() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(CupCarbonFileNames.recentFile));
                    for (int i = 0; i < 10; ++i) {
                        String s = br.readLine();
                        if (s == null) continue;
                        if (!s.trim().equals("")) {
                            String name = s.split("#")[1];
                            if (i == 0) {
                                CupCarbonController.this.openRecentProjectItem1.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem1.setText(name);
                            }
                            if (i == 1) {
                                CupCarbonController.this.openRecentProjectItem2.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem2.setText(name);
                            }
                            if (i == 2) {
                                CupCarbonController.this.openRecentProjectItem3.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem3.setText(name);
                            }
                            if (i == 3) {
                                CupCarbonController.this.openRecentProjectItem4.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem4.setText(name);
                            }
                            if (i == 4) {
                                CupCarbonController.this.openRecentProjectItem5.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem5.setText(name);
                            }
                            if (i == 5) {
                                CupCarbonController.this.openRecentProjectItem6.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem6.setText(name);
                            }
                            if (i == 6) {
                                CupCarbonController.this.openRecentProjectItem7.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem7.setText(name);
                            }
                            if (i == 7) {
                                CupCarbonController.this.openRecentProjectItem8.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem8.setText(name);
                            }
                            if (i == 8) {
                                CupCarbonController.this.openRecentProjectItem9.setVisible(true);
                                CupCarbonController.this.openRecentProjectItem9.setText(name);
                            }
                            if (i != 9) continue;
                            CupCarbonController.this.openRecentProjectItem10.setVisible(true);
                            CupCarbonController.this.openRecentProjectItem10.setText(name);
                            continue;
                        }
                        if (i == 0) {
                            CupCarbonController.this.openRecentProjectItem1.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem1.setText("");
                        }
                        if (i == 1) {
                            CupCarbonController.this.openRecentProjectItem2.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem2.setText("");
                        }
                        if (i == 2) {
                            CupCarbonController.this.openRecentProjectItem3.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem3.setText("");
                        }
                        if (i == 3) {
                            CupCarbonController.this.openRecentProjectItem4.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem4.setText("");
                        }
                        if (i == 4) {
                            CupCarbonController.this.openRecentProjectItem5.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem5.setText("");
                        }
                        if (i == 5) {
                            CupCarbonController.this.openRecentProjectItem6.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem6.setText("");
                        }
                        if (i == 6) {
                            CupCarbonController.this.openRecentProjectItem7.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem7.setText("");
                        }
                        if (i == 7) {
                            CupCarbonController.this.openRecentProjectItem8.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem8.setText("");
                        }
                        if (i == 8) {
                            CupCarbonController.this.openRecentProjectItem9.setVisible(false);
                            CupCarbonController.this.openRecentProjectItem9.setText("");
                        }
                        if (i != 9) continue;
                        CupCarbonController.this.openRecentProjectItem10.setVisible(false);
                        CupCarbonController.this.openRecentProjectItem10.setText("");
                    }
                    br.close();
                }
                catch (FileNotFoundException e) {
                    System.err.println("recent.rec doesn't exist");
                }
                catch (IOException e) {
                    System.err.println("error in recent.rec file");
                }
                CupCarbonController.this.openProjectLoadParameters();
            }
        });
    }

    @FXML
    public void openLastProject() {
        this.openIthRecentProject(1);
        this.initRecentProjectMenu();
    }

    @FXML
    public void saveProject() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (Project.projectPath.equals("") || Project.projectName.equals("")) {
                    CupCarbonController.this.displayLongErrMessageTh("Project must be created first!");
                } else {
                    Project.saveProject();
                    CupCarbonController.this.saveButton.setDisable(true);
                }
            }
        });
    }

    public void openIthRecentProject(int index) {
        Platform.runLater(() -> {
            try {
                BufferedReader br = new BufferedReader(new FileReader(CupCarbonFileNames.recentFile));
                String s = "";
                for (int i = 0; i < index; ++i) {
                    s = br.readLine();
                }
                String path = s.split("#")[0];
                String name = s.split("#")[1];
                this.displayShortMessage(name);
                br.close();
                this.qRunIoTSimulationButton.setDisable(false);
                Project.openProject(path, name);
                CupCarbonApp.stage.setTitle("CupCarbon Klines 7.2 [" + path + "]");
            }
            catch (FileNotFoundException e) {
                System.err.println("recent.rec doesn't exist");
            }
            catch (IOException e) {
                System.err.println("Error in recent.rec file");
            }
            catch (NullPointerException e) {
                System.err.println("No recent files");
                this.displayShortErrMessageTh("No recent files");
            }
            this.openProjectLoadParameters();
        });
    }

    @FXML
    public void insertMarkers() {
        MarkerList.insertMarkers();
    }

    @FXML
    public void drawAllRoutes() {
        MarkerList.reset();
        Routes.loadRoutes();
    }

    @FXML
    public void drawSelectedRoutes() {
        NetworkParameters.displayAllRoutes = true;
        MarkerList.reset();
        Routes.loadListOfRoutes(this.gpsListView.getSelectionModel().getSelectedItems());
    }

    @FXML
    public void hideAllRoutes() {
        NetworkParameters.displayAllRoutes = false;
        Routes.hideAll();
    }

    @FXML
    public void startServer() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                new CupCarbonServer().start();
                CupCarbonController.this.mapFocus();
            }
        });
    }

    @FXML
    public void initIDs() {
        DeviceList.initIDs();
        MapLayer.repaint();
        this.mapFocus();
    }

    @FXML
    public void sliderValueChanged() {
        MapLayer.bg_transparency = (int)(this.bg_slider.getValue() * 2.5);
        MapLayer.repaint();
        this.mapFocus();
    }

    public void updateLabeLInfos() {
        Platform.runLater(() -> {
            int n_s = 0;
            int n_ms = 0;
            int n_bs = 0;
            int n_m = 0;
            int n_g = 0;
            int n_r = 0;
            int n_b = 0;
            int n_mark = 0;
            int n_unmark = 0;
            int n_s_o = 0;
            int n_s_s = 0;
            int n_s_ms = 0;
            int n_s_bs = 0;
            int n_s_m = 0;
            int n_s_g = 0;
            int n_i_s = 0;
            int n_wi_s = 0;
            int n_wo_s = 0;
            n_b = BuildingList.size();
            for (Device device : DeviceList.devices) {
                if (device.getType() == 6) {
                    ++n_m;
                    if (device.isSelected()) {
                        ++n_s_m;
                    }
                }
                if (device.getType() == 2) {
                    ++n_g;
                    if (device.isSelected()) {
                        ++n_s_g;
                    }
                }
                if (!device.isSelected()) continue;
                ++n_s_o;
            }
            for (int i = 0; i < DeviceList.sensors.size(); ++i) {
                SensorNode sensor = DeviceList.sensors.get(i);
                if (sensor.getNeighbors().size() == 0) {
                    ++n_i_s;
                }
                if (sensor.getScriptFileName().equals("")) {
                    ++n_wo_s;
                } else {
                    ++n_wi_s;
                }
                if (sensor.getType() == 1) {
                    ++n_s;
                    if (sensor.isSelected()) {
                        ++n_s_s;
                    }
                }
                if (sensor.getType() == 5) {
                    ++n_ms;
                    if (sensor.isSelected()) {
                        ++n_s_ms;
                    }
                }
                if (sensor.getType() == 4) {
                    ++n_bs;
                    if (sensor.isSelected()) {
                        ++n_s_bs;
                    }
                }
                if (sensor.isMarked()) {
                    ++n_mark;
                } else {
                    ++n_unmark;
                }
                if (!sensor.isSelected()) continue;
                ++n_s_o;
            }
            File f = new File(Project.getProjectGpsPath());
            if (f.list() != null) {
                n_r = new File(Project.getProjectGpsPath()).list().length;
            }
            this.labelInfo1.setText("Number of Sensors: " + n_s);
            this.labelInfo2.setText("Number of Directional Sensors: " + n_ms);
            this.labelInfo3.setText("Number of Base Stations: " + n_bs);
            this.labelInfo4.setText("Number of Mobiles: " + n_m);
            this.labelInfo5.setText("Number of Gas: " + n_g);
            this.labelInfo6.setText("Number of Routes: " + n_r);
            this.labelInfo7.setText("Number of Buildings: " + n_b);
            this.labelInfo8.setText("Number of Marked Sensors: " + n_mark);
            this.labelInfo9.setText("Number of Unmarked Sensors: " + n_unmark);
            this.labelInfo10.setText("Number of Selected Objects:  " + n_s_o);
            this.labelInfo11.setText("Number of Selected Sensors: " + n_s_s);
            this.labelInfo12.setText("Number of Selected Directional Sensors:  " + n_s_ms);
            this.labelInfo13.setText("Number of Selected Base Stations: " + n_s_bs);
            this.labelInfo14.setText("Number of Selected Mobiles: " + n_s_m);
            this.labelInfo15.setText("Number of Selected Gas: " + n_s_g);
            this.labelInfo16.setText("Number of Isolated Sensors:  " + n_i_s);
            this.labelInfo17.setText("Number of Sensors with script: " + n_wi_s);
            this.labelInfo18.setText("Number of Sensors without script: " + n_wo_s);
        });
    }

    public void displayLongMessage(String s) {
        this.textReady.setFill(new Color(0.4, 0.52, 0.75, 0.5));
        this.textReady.setText(s);
        this.textReady.setVisible(true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.textReady.setVisible(false);
    }

    public void displayPermanentMessage_th(final String s) {
        Thread th = new Thread(new Runnable(){
            final /* synthetic */ CupCarbonController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.textReady.setFill(new Color(0.4, 0.52, 0.75, 0.5));
                this.this$0.textReady.setText(s);
                this.this$0.textReady.setVisible(true);
            }
        });
        th.start();
    }

    public void displayShortMessage(String s) {
        this.textReady.setFill(new Color(0.4, 0.52, 0.75, 0.5));
        this.textReady.setText(s);
        this.textReady.setVisible(true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.textReady.setVisible(false);
    }

    public void displayShortGoodMessage(String s) {
        if (MapLayer.dark) {
            this.textReady.setFill(this.goodMessColor1);
        } else {
            this.textReady.setFill(this.goodMessColor2);
        }
        this.textReady.setText(s);
        this.textReady.setVisible(true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.textReady.setVisible(false);
    }

    public void displayPermanentErrMessage_th(final String s) {
        Thread th = new Thread(new Runnable(){
            final /* synthetic */ CupCarbonController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.textReady.setFill(new Color(1.0, 0.5, 0.0, 0.5));
                this.this$0.textReady.setText(s);
                this.this$0.textReady.setVisible(true);
                this.this$0.swingNode.requestFocus();
            }
        });
        th.start();
    }

    public void hidePermanentErrMessage_th(String s) {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                CupCarbonController.this.textReady.setVisible(false);
            }
        });
        th.start();
    }

    public void displayShortGoodMessage_th(final String s) {
        Thread th = new Thread(new Runnable(){
            final /* synthetic */ CupCarbonController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (MapLayer.dark) {
                    this.this$0.textReady.setFill(this.this$0.goodMessColor1);
                } else {
                    this.this$0.textReady.setFill(this.this$0.goodMessColor2);
                }
                this.this$0.textReady.setText(s);
                this.this$0.textReady.setVisible(true);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.this$0.textReady.setVisible(false);
            }
        });
        th.start();
    }

    public void displayShortErrMessage(String s) {
        if (MapLayer.dark) {
            this.textReady.setFill(new Color(1.0, 0.0, 0.0, 0.9));
        } else {
            this.textReady.setFill(new Color(1.0, 0.0, 0.0, 0.5));
        }
        this.textReady.setText(s);
        this.textReady.setVisible(true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.textReady.setVisible(false);
    }

    public void displayVeryShortErrMessage(String s) {
        if (MapLayer.dark) {
            this.textReady.setFill(new Color(1.0, 0.0, 0.0, 0.9));
        } else {
            this.textReady.setFill(new Color(1.0, 0.0, 0.0, 0.5));
        }
        this.textReady.setText(s);
        this.textReady.setVisible(true);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.textReady.setVisible(false);
    }

    public void displayShortErrMessageTh(String s) {
        new Thread(() -> {
            if (MapLayer.dark) {
                this.textReady.setFill(new Color(1.0, 0.0, 0.0, 0.9));
            } else {
                this.textReady.setFill(new Color(1.0, 0.0, 0.0, 0.5));
            }
            this.textReady.setText(s);
            this.textReady.setVisible(true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.textReady.setVisible(false);
        }).start();
    }

    public void displayLongErrMessageTh(String s) {
        new Thread(() -> {
            if (MapLayer.dark) {
                this.textReady.setFill(new Color(1.0, 0.0, 0.0, 0.9));
            } else {
                this.textReady.setFill(new Color(1.0, 0.0, 0.0, 0.5));
            }
            this.textReady.setText(s);
            this.textReady.setVisible(true);
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.textReady.setVisible(false);
        }).start();
    }
}

