/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import java.io.File;
import project.Project;

public class CupCommand_PROJECT
extends CupCommand {
    protected String path = "";
    protected String name = "";
    protected String option = "";

    public CupCommand_PROJECT(CupScript script, String option, String name, String path) {
        this.script = script;
        this.path = path;
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        this.path = (String)path + name;
        this.name = name;
        this.option = option;
    }

    public CupCommand_PROJECT(CupScript script, String option) {
        this.script = script;
        this.option = option;
    }

    @Override
    public String execute() {
        currentExecution = false;
        Object rep = "";
        String sPath = this.script.getVariableValue(this.path);
        Object sName = this.script.getVariableValue(this.name);
        String sOption = this.script.getVariableValue(this.option);
        switch (this.option) {
            case "new": {
                Project.newProject(sPath, (String)sName, true);
                rep = "000 New project is created";
                currentExecution = true;
                break;
            }
            case "open": {
                if (!((String)sName).endsWith(".cup")) {
                    sName = (String)sName + ".cup";
                }
                Project.openProject(sPath, (String)sName);
                rep = "000 Project opened";
                currentExecution = true;
                break;
            }
            case "list": {
                Project.listParameters();
                rep = "000 Project Paramaters Have been Printed Out";
                currentExecution = true;
                break;
            }
            default: {
                rep = "001 [ERROR] Project option error: " + sOption;
                currentExecution = false;
            }
        }
        System.out.println((String)rep);
        CupScript.slog.println((String)rep);
        isExecuted = currentExecution;
        return rep;
    }

    @Override
    public String toString() {
        return "PROJECT";
    }
}

