/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import device.DeviceList;
import java.util.ArrayList;
import java.util.List;
import map.WorldMap;
import markers.MarkerList;

public class CupCommand_SELECT
extends CupCommand {
    protected List<String> objects;
    protected String option = "";

    public CupCommand_SELECT(CupScript script, String option, List<String> objects) {
        this.script = script;
        this.objects = objects;
        this.option = option;
    }

    public CupCommand_SELECT(CupScript script, String option) {
        this.script = script;
        this.option = option;
    }

    @Override
    public String execute() {
        Object rep;
        block36: {
            block35: {
                currentExecution = false;
                rep = "";
                String sOption = this.script.getVariableValue(this.option);
                ArrayList<String> sObjects = new ArrayList<String>();
                if (this.objects != null) {
                    for (int i = 0; i < this.objects.size(); ++i) {
                        sObjects.add(this.script.getVariableValue(this.objects.get(i)));
                    }
                }
                if (!isExecuted) break block35;
                switch (sOption) {
                    case "all": {
                        if (sObjects.size() == 0) {
                            WorldMap.setSelectionOfAllNodes(true, -1, true);
                            WorldMap.setSelectionOfAllMarkers(true, true);
                            WorldMap.setSelectionOfAllBuildings(true, true);
                            rep = "000 All Objects are Selected";
                            currentExecution = true;
                            break;
                        }
                        block29: for (int i = 0; i < sObjects.size(); ++i) {
                            switch ((String)sObjects.get(i)) {
                                case "sensors": {
                                    DeviceList.deselectAllObjects();
                                    WorldMap.setSelectionOfAllNodes(true, 1, true);
                                    WorldMap.setSelectionOfAllNodes(true, 5, true);
                                    WorldMap.setSelectionOfAllNodes(true, 4, true);
                                    rep = (String)rep + " 000 All Sensors are Selected";
                                    currentExecution = true;
                                    continue block29;
                                }
                                case "mobiles": {
                                    DeviceList.deselectAllObjects();
                                    WorldMap.setSelectionOfAllNodes(true, 6, true);
                                    rep = (String)rep + " 000 All Mobiles are Selected";
                                    currentExecution = true;
                                    continue block29;
                                }
                                case "events": {
                                    DeviceList.deselectAllObjects();
                                    WorldMap.setSelectionOfAllNodes(true, 2, true);
                                    rep = (String)rep + " 000 All Natural Events are Selected";
                                    currentExecution = true;
                                    continue block29;
                                }
                                case "markers": {
                                    DeviceList.deselectAllObjects();
                                    for (int j = 0; j < MarkerList.size(); ++j) {
                                        WorldMap.setSelectionOfAllMarkers(true, true);
                                    }
                                    rep = (String)rep + " 000 All markers are Selected";
                                    currentExecution = true;
                                    continue block29;
                                }
                                case "sensorswithoutgps": {
                                    DeviceList.deselectAllObjects();
                                    DeviceList.selectWitoutGps();
                                    rep = (String)rep + " 000 All Sensors Without GPS are Selected";
                                    currentExecution = true;
                                    continue block29;
                                }
                                case "sensorswithoutscript": {
                                    DeviceList.deselectAllObjects();
                                    DeviceList.selectWitoutScript();
                                    rep = (String)rep + " 000 All Sensors Without Script are Selected";
                                    currentExecution = true;
                                    continue block29;
                                }
                                default: {
                                    rep = (String)rep + " 001 [ERROR] error in Selection";
                                    currentExecution = false;
                                }
                            }
                        }
                        break block36;
                    }
                    case "inv": {
                        WorldMap.invertSelection();
                        rep = "000 The Selection is Inverted";
                        currentExecution = true;
                        break;
                    }
                    case "devices": {
                        DeviceList.deselectAllObjects();
                        for (int i = 0; i < sObjects.size(); ++i) {
                            DeviceList.getNodeByName((String)sObjects.get(i)).setSelected(true);
                            rep = (String)rep + " 000 The Device: " + (String)sObjects.get(i) + " is selected";
                        }
                        currentExecution = true;
                        break;
                    }
                    case "markers": {
                        DeviceList.deselectAllObjects();
                        for (int i = 0; i < sObjects.size(); ++i) {
                            MarkerList.get(Integer.parseInt((String)sObjects.get(i))).setSelected(true);
                            rep = (String)rep + " 000 The marker: " + (String)sObjects.get(i) + " is selected";
                        }
                        currentExecution = true;
                        break;
                    }
                    default: {
                        rep = "001 [ERROR] error in Selection";
                        currentExecution = false;
                    }
                }
                break block36;
            }
            rep = "ERROR IN EXECUTING THE PREVIOUS STEP, THE SCRIPT WILL NOT CONTINUE TO EXECUTE";
            this.script.setBreaked(true);
        }
        System.out.println((String)rep);
        CupScript.slog.println((String)rep);
        isExecuted = currentExecution;
        return rep;
    }

    @Override
    public String toString() {
        return "SELECT";
    }
}

