/*
 * Decompiled with CFR 0.152.
 */
package geo_objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import map.MapLayer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import utilities.MapCalc;
import utilities.UColor;

public class GeoZone {
    protected int type = 11;
    private double[] coordX;
    private double[] coordY;
    private int[] iCoordX;
    private int[] iCoordY;
    private int size = 0;
    private boolean selected = false;
    private int mapZoom = MapLayer.mapViewer.getZoom();
    private double longitude = 0.0;
    private double latitude = 0.0;
    private int cx = 0;
    private int cy = 0;

    public GeoZone(int size) {
        this.size = size;
        this.coordX = new double[size];
        this.coordY = new double[size];
        this.iCoordX = new int[size];
        this.iCoordY = new int[size];
    }

    public void set(double x, double y, double z, int i) {
        this.coordX[i] = x;
        this.coordY[i] = y;
        this.computeIntCoord(i);
    }

    public void set(String x, String y, String z, int i) {
        this.coordX[i] = Double.valueOf(x);
        this.coordY[i] = Double.valueOf(y);
        this.computeIntCoord(i);
    }

    public double getXCoord(int i) {
        return this.coordX[i];
    }

    public double getYCoord(int i) {
        return this.coordY[i];
    }

    public double[] getXCoords() {
        return this.coordX;
    }

    public double[] getYCoords() {
        return this.coordY;
    }

    public int size() {
        return this.size;
    }

    public void computeIntCoord(int i) {
        int[] coord = MapCalc.geoToPixelMapA(this.coordX[i], this.coordY[i]);
        this.iCoordX[i] = coord[0];
        this.iCoordY[i] = coord[1];
        coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
        this.cx = coord[0];
        this.cy = coord[1];
    }

    public void computeIntCoords() {
        int[] coord = null;
        for (int i = 0; i < this.size; ++i) {
            coord = MapCalc.geoToPixelMapA(this.coordX[i], this.coordY[i]);
            this.iCoordX[i] = coord[0];
            this.iCoordY[i] = coord[1];
            coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            this.cx = coord[0];
            this.cy = coord[1];
        }
    }

    public void computeGeoCoords() {
        for (int i = 0; i < this.size; ++i) {
            GeoPosition gp = MapCalc.pixelMapToGeo(this.iCoordX[i], this.iCoordY[i]);
            this.coordX[i] = gp.getLatitude();
            this.coordY[i] = gp.getLongitude();
        }
    }

    public void draw(Graphics g) {
        int newZoom = MapLayer.mapViewer.getZoom();
        if (newZoom != this.mapZoom) {
            this.mapZoom = newZoom;
            this.computeIntCoords();
        }
        Graphics2D g2 = (Graphics2D)g;
        Point2D.Float center = new Point2D.Float(this.cx, this.cy);
        double paintRadius = 300.0 * (4.0 / Math.pow(2.0, MapLayer.mapViewer.getZoom()));
        float[] dist = new float[]{0.0f, 0.2f, 0.7f};
        Color[] colors = new Color[]{new Color(255, 0, 0, 80), new Color(250, 5, 0, 30), new Color(255, 255, 255, 0)};
        if (MapLayer.dark) {
            colors[0] = new Color(255, 0, 0, 80);
            colors[1] = new Color(221, 148, 32, 80);
            colors[2] = new Color(221, 0, 32, 0);
        }
        if (this.selected) {
            colors[0] = new Color(250, 5, 0, 90);
            colors[1] = new Color(250, 5, 0, 40);
            colors[2] = new Color(250, 5, 0, 0);
        }
        RadialGradientPaint p = new RadialGradientPaint(center, (float)paintRadius, dist, colors);
        g2.setPaint(p);
        g2.fillPolygon(this.iCoordX, this.iCoordY, this.size);
        g2.setColor(UColor.RED_TRANSPARENT);
        if (this.selected) {
            g2.setColor(UColor.RED);
            if (MapLayer.dark) {
                g2.setColor(UColor.ORANGE);
            }
        }
        g2.drawPolygon(this.iCoordX, this.iCoordY, this.size);
    }

    public boolean inside(int xs, int ys) {
        Point p = new Point(xs, ys);
        GeoPosition gp = MapLayer.mapViewer.convertPointToGeoPosition(p);
        Point2D p1 = MapLayer.mapViewer.getTileFactory().geoToPixel(gp, MapLayer.mapViewer.getZoom());
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.size);
        return poly.contains(p1);
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean intersect(Polygon p) {
        for (int i = 0; i < this.size; ++i) {
            if (!p.contains(this.iCoordX[i], this.iCoordY[i])) continue;
            return true;
        }
        return false;
    }

    public void translate(double xref, double yref, double zm) {
        for (int i = 0; i < this.size; ++i) {
            this.coordX[i] = this.coordX[i] / zm + xref;
            this.coordY[i] = this.coordY[i] / zm + yref;
            this.computeIntCoord(i);
        }
    }

    public boolean contains(Point2D p) {
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.size);
        return poly.contains(p);
    }

    public boolean contains(double px, double py) {
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.size);
        return poly.contains(px, py);
    }

    public Polygon toPolygon() {
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.size);
        return poly;
    }

    public void display() {
        for (int i = 0; i < this.size; ++i) {
            System.out.print("(" + this.iCoordX[i] + ", " + this.iCoordY[i] + ") ");
        }
        System.out.println();
    }

    public int getICoordX(int i) {
        return this.iCoordX[i];
    }

    public int getICoordY(int i) {
        return this.iCoordY[i];
    }

    public void setICoordX(int i, int v) {
        this.iCoordX[i] = v;
    }

    public void setICoordY(int i, int v) {
        this.iCoordY[i] = v;
    }

    public void setInt(int x, int y, int i) {
        this.iCoordX[i] = x;
        this.iCoordY[i] = y;
    }

    public void setCxCy(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        int[] coord = MapCalc.geoToPixelMapA(latitude, longitude);
        this.cx = coord[0];
        this.cy = coord[1];
    }

    public int getCx() {
        return this.cx;
    }

    public int getCy() {
        return this.cy;
    }
}

