/*
 * Decompiled with CFR 0.152.
 */
package geometry;

import device.DeviceList;
import device.SensorNode;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import utilities.MapCalc;
import utilities.UColor;

public class SNEdge {
    private SensorNode sn1 = null;
    private SensorNode sn2 = null;

    public SNEdge() {
    }

    public SNEdge(SensorNode sn1, SensorNode sn2) {
        this.sn1 = sn1;
        this.sn2 = sn2;
    }

    public SNEdge(int id1, int id2) {
        this.sn1 = DeviceList.getSensorNodeById(id1);
        this.sn2 = DeviceList.getSensorNodeById(id2);
    }

    public SensorNode getSN1() {
        return this.sn1;
    }

    public SensorNode getSN2() {
        return this.sn2;
    }

    public void setSN1(SensorNode sn1) {
        this.sn1 = sn1;
    }

    public void setSN2(SensorNode sn2) {
        this.sn2 = sn2;
    }

    public void draw(Graphics2D g) {
        g.setStroke(new BasicStroke(3.4f));
        int[] coord = MapCalc.geoToPixelMapA(this.sn1.getLatitude(), this.sn1.getLongitude());
        int lx1 = coord[0];
        int ly1 = coord[1];
        coord = MapCalc.geoToPixelMapA(this.sn2.getLatitude(), this.sn2.getLongitude());
        int lx2 = coord[0];
        int ly2 = coord[1];
        g.setColor(UColor.BLUEM);
        g.drawLine(lx1, ly1, lx2, ly2);
    }

    public String toString() {
        return "Point [p1=" + String.valueOf(this.sn1) + ", p2=" + String.valueOf(this.sn2) + "]";
    }
}

