/*
 * Decompiled with CFR 0.152.
 */
package interference;

import interference.AlphaStableRandom;
import math.Complex;
import math.UFunctions;

public class ZigBeeTransceiver {
    public static double getNumberOfReceivedErrorBits(String inputMsg, int noNeghboringNodes, int radioRange, double perActiveNodes) {
        double errBits = 0.0;
        int signalConstellation = 16;
        int symbolSize = signalConstellation / 4;
        int maxBitsAllowedToSend = 512;
        byte[] binaryData = ZigBeeTransceiver.getStringToBinary(inputMsg);
        byte[] binarySource = new byte[maxBitsAllowedToSend];
        if (binaryData.length >= maxBitsAllowedToSend) {
            System.out.print("Too Long Message");
        } else {
            int i;
            for (int i2 = 0; i2 < maxBitsAllowedToSend; ++i2) {
                binarySource[i2] = i2 < binaryData.length ? binaryData[i2] : (byte)0;
            }
            int lenDecNo = binarySource.length / symbolSize;
            int[] DecNumbers = new int[lenDecNo];
            int jj = 0;
            for (int i3 = 0; i3 < binarySource.length; i3 += 4) {
                String s = "" + binarySource[i3] + binarySource[i3 + 1] + binarySource[i3 + 2] + binarySource[i3 + 3];
                DecNumbers[jj] = Integer.parseInt(s, 2);
                ++jj;
            }
            Object s = "";
            Object S_I = "";
            Object S_Q = "";
            for (i = 0; i < lenDecNo; ++i) {
                s = (String)s + ZigBeeTransceiver.getPN(DecNumbers[i]);
            }
            for (i = 0; i <= ((String)s).length() / 2 - 1; ++i) {
                S_I = (String)S_I + ((String)s).charAt(i * 2) + ((String)s).charAt(i * 2);
                S_Q = (String)S_Q + ((String)s).charAt(i * 2 + 1) + ((String)s).charAt(i * 2 + 1);
            }
            Complex[] oqpskSource = new Complex[((String)S_I).length() + 1];
            for (int i4 = 0; i4 < ((String)S_I).length() - 1; ++i4) {
                int map_dec = (((String)S_I).charAt(i4 + 1) - 48) * 2 + (((String)S_Q).charAt(i4) - 48);
                oqpskSource[i4 + 1] = UFunctions.getComplexModulation(map_dec);
            }
            oqpskSource[0] = ((String)S_I).charAt(0) == '0' ? new Complex(0.7071, 0.0) : new Complex(-0.7071, 0.0);
            oqpskSource[((String)S_I).length()] = ((String)S_Q).charAt(0) == '0' ? new Complex(0.0, 0.7071) : new Complex(0.0, -0.7071);
            int sizeout = oqpskSource.length;
            double[] alpharnd1 = AlphaStableRandom.generateNext(noNeghboringNodes, radioRange, perActiveNodes, sizeout);
            double[] alpharnd2 = AlphaStableRandom.generateNext(noNeghboringNodes, radioRange, perActiveNodes, sizeout);
            Complex[] alpharnd = new Complex[sizeout];
            for (int i5 = 0; i5 < sizeout; ++i5) {
                alpharnd[i5] = new Complex(alpharnd1[i5], alpharnd2[i5]);
            }
            Complex[] rx = new Complex[sizeout];
            double[] noise_real = new double[sizeout];
            double[] noise_imag = new double[sizeout];
            for (int i6 = 0; i6 < sizeout; ++i6) {
                noise_real[i6] = oqpskSource[i6].re() + alpharnd[i6].re();
                noise_imag[i6] = oqpskSource[i6].im() + alpharnd[i6].im();
                rx[i6] = new Complex(noise_real[i6], noise_imag[i6]);
            }
            int[] OQPSKdemod = new int[rx.length];
            if (rx[0].equals(new Complex(0.7071, 0.0))) {
                OQPSKdemod[0] = 0;
            }
            if (rx[0].equals(new Complex(-0.7071, 0.0))) {
                OQPSKdemod[0] = 2;
            }
            if (rx[rx.length - 1].equals(new Complex(0.0, 0.7071))) {
                OQPSKdemod[rx.length - 1] = 0;
            }
            if (rx[rx.length - 1].equals(new Complex(0.0, -0.7071))) {
                OQPSKdemod[rx.length - 1] = 1;
            }
            for (int i7 = 0; i7 < oqpskSource.length - 1; ++i7) {
                OQPSKdemod[i7 + 1] = ZigBeeTransceiver.getComplexDemodulation(oqpskSource[i7 + 1]);
            }
            String[] rx_rbin = new String[OQPSKdemod.length];
            for (int i8 = 0; i8 < OQPSKdemod.length; ++i8) {
                rx_rbin[i8] = ZigBeeTransceiver.twoBitbinConversion(OQPSKdemod[i8]);
            }
            byte[] rx_p2s = new byte[rx_rbin.length * 2];
            for (int i9 = 0; i9 < rx_rbin.length * 2; i9 += 2) {
                rx_p2s[i9] = (byte)(rx_rbin[i9 / 2].charAt(0) - 48);
                rx_p2s[i9 + 1] = (byte)(rx_rbin[i9 / 2].charAt(1) - 48);
            }
            byte[] rxOdd = new byte[rx_p2s.length / 4];
            byte[] rxEven = new byte[rx_p2s.length / 4];
            for (int i10 = 0; i10 < rxOdd.length; ++i10) {
                rxOdd[i10] = rx_p2s[i10 * 4];
                rxEven[i10] = rx_p2s[(i10 + 1) * 4 - 1];
            }
            String[] rx_rpn = new String[rx_p2s.length / 64];
            for (int i11 = 0; i11 < rx_p2s.length / 64; ++i11) {
                rx_rpn[i11] = "";
                for (int k = 0; k < 16; ++k) {
                    int n = i11;
                    rx_rpn[n] = rx_rpn[n] + rxOdd[i11 * 16 + k];
                    int n2 = i11;
                    rx_rpn[n2] = rx_rpn[n2] + rxEven[i11 * 16 + k];
                }
            }
            byte[] rx_hamd = new byte[rx_rpn.length];
            for (int i12 = 0; i12 < rx_rpn.length; ++i12) {
                int min = 32;
                int imin = 16;
                for (int j = 0; j < 16; ++j) {
                    int h = ZigBeeTransceiver.getHammingDistance(rx_rpn[i12], ZigBeeTransceiver.getPN(j));
                    if (h >= min) continue;
                    min = h;
                    imin = j;
                }
                rx_hamd[i12] = (byte)imin;
            }
            byte[] rx_d2b = ZigBeeTransceiver.getDecimalToBinary(rx_hamd);
            byte[] cb = new byte[rx_d2b.length];
            for (int i13 = 0; i13 < rx_d2b.length; ++i13) {
                cb[i13] = binarySource[i13];
                errBits += cb[i13] == rx_d2b[i13] ? 0.0 : 1.0;
            }
        }
        return errBits;
    }

    public static String getPN(int i) {
        String[] PNTable = new String[]{"11011001110000110101001000101110", "11101101100111000011010100100010", "00101110110110011100001101010010", "00100010111011011001110000110101", "01010010001011101101100111000011", "00110101001000101110110110011100", "11000011010100100010111011011001", "10011100001101010010001011101101", "10001100100101100000011101111011", "10111000110010010110000001110111", "01111011100011001001011000000111", "01110111101110001100100101100000", "00000111011110111000110010010110", "01100000011101111011100011001001", "10010110000001110111101110001100", "11001001011000000111011110111000"};
        return PNTable[i];
    }

    public static Complex getComplexModulation(int v) {
        if (v == 0) {
            return new Complex(0.7071, 0.7071);
        }
        if (v == 1) {
            return new Complex(0.7071, -0.7071);
        }
        if (v == 2) {
            return new Complex(-0.7071, 0.7071);
        }
        if (v == 3) {
            return new Complex(-0.7071, -0.7071);
        }
        return null;
    }

    public static int getComplexDemodulation(Complex u) {
        if (u.equals(new Complex(0.7071, 0.7071))) {
            return 0;
        }
        if (u.equals(new Complex(0.7071, -0.7071))) {
            return 1;
        }
        if (u.equals(new Complex(-0.7071, 0.7071))) {
            return 2;
        }
        if (u.equals(new Complex(-0.7071, -0.7071))) {
            return 3;
        }
        return 0;
    }

    public static String twoBitbinConversion(int w) {
        if (w == 0) {
            return "00";
        }
        if (w == 1) {
            return "01";
        }
        if (w == 2) {
            return "10";
        }
        if (w == 3) {
            return "11";
        }
        return "00";
    }

    public static int getHammingDistance(String compOne, String compTwo) {
        if (compOne.length() != compTwo.length()) {
            return -1;
        }
        int counter = 0;
        for (int i = 0; i < compOne.length(); ++i) {
            if (compOne.charAt(i) == compTwo.charAt(i)) continue;
            ++counter;
        }
        return counter;
    }

    public static byte[] getStringToBinary(String inputMsg) {
        Object s2 = "";
        for (int i = 0; i < inputMsg.length(); ++i) {
            char c = inputMsg.charAt(i);
            s2 = (String)s2 + String.format("%8s", Integer.toBinaryString(c)).replaceAll(" ", "0");
        }
        s2 = ((String)s2).replaceAll("0", "\u0000");
        s2 = ((String)s2).replaceAll("1", "\u0001");
        byte[] binarySource = ((String)s2).getBytes();
        return binarySource;
    }

    public static byte[] getDecimalToBinary(byte[] decimalVector) {
        byte[] binaryVector = new byte[decimalVector.length * 4];
        int k = 0;
        for (int i = 0; i < decimalVector.length; ++i) {
            int j;
            String s = Integer.toBinaryString(decimalVector[i]);
            for (j = 0; j < 4 - s.length(); ++j) {
                binaryVector[k++] = 0;
            }
            for (j = 0; j < s.length(); ++j) {
                binaryVector[k++] = (byte)(s.charAt(j) - 48);
            }
        }
        return binaryVector;
    }
}

