/*
 * Decompiled with CFR 0.152.
 */
package map;

import cupcarbon.CupCarbonApp;
import cupcarbon.CupCarbonIcons;
import java.awt.Image;
import java.io.File;
import javax.swing.ImageIcon;
import map.MapLayer;
import map.NetworkParameters;
import map.Tiles;
import org.jdesktop.swingx.JXMapKit;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class WorldMap
extends JXMapKit {
    private static final long serialVersionUID = 1L;
    private static MapLayer layer;
    private final int max = 19;
    public static String tileType;
    public static String tileUrl;
    public static boolean local;
    public static boolean gmap;
    public static String tileName;
    public static int mapIdx;

    public WorldMap() {
        this.WorldMapExecute();
        layer = new MapLayer(this.getMainMap());
    }

    public void WorldMapExecute() {
        TileFactoryInfo info = new TileFactoryInfo(0, 19, 19, 256, true, true, "http://tile.openseamap.org", "x", "y", "z"){

            @Override
            public String getTileUrl(int x, int y, int zoom) {
                zoom = 19 - zoom;
                if (local) {
                    File file = new File("utils/tiles/" + File.separator + tileName);
                    tileUrl = file.getAbsolutePath();
                    tileUrl = tileUrl.replaceAll(" ", "%20");
                    tileUrl = tileUrl.replaceAll("\\\\", "/");
                    return "file:///" + tileUrl;
                }
                if (gmap) {
                    return tileUrl + "&x=" + x + "&y=" + y + "&z=" + zoom + "&s=Ga";
                }
                return tileUrl + zoom + "/" + x + "/" + y + tileType + "?apiKey=" + Tiles.apiKey;
            }
        };
        info.setDefaultZoomLevel(3);
        DefaultTileFactory tf = new DefaultTileFactory(info);
        this.setTileFactory(tf);
        this.setDataProviderCreditShown(true);
        this.setName("CupCarbon Map");
        this.setCenterPosition(new GeoPosition(25.301684895670554, 55.48621416091919));
        this.setZoom(2);
    }

    public void download(int zoom, int x, int y) {
        String s = zoom + "_" + x + "_" + y;
        String s2 = zoom + "/" + x + "/" + y;
        String nom = "marktiles/" + s + ".png";
        File file = new File(nom);
        new Thread(() -> {
            if (MapLayer.listOfMarkTiles.get(s) == null && file.exists()) {
                Image image = new ImageIcon(nom).getImage();
                MapLayer.listOfMarkTiles.put(s, image);
            }
        }).start();
    }

    public static void simulate() {
        layer.simulate();
    }

    public static void simulateAll() {
        layer.simulateAll();
    }

    public static void simulateSensors() {
        layer.simulateSensors();
    }

    public static void simulateMobiles() {
        layer.simulateMobiles();
    }

    public static void addNodeInMap(char c) {
        layer.addNodeInMap(c);
    }

    public static void loadCityNodes() {
        layer.loadCityNodes();
    }

    public static void setSelectionOfAllNodes(boolean selection, int type, boolean addSelection) {
        layer.setSelectionOfAllNodes(selection, type, addSelection);
    }

    public static void setSelectionOfAllMobileNodes(boolean selection, int type, boolean addSelection) {
        layer.setSelectionOfAllMobileNodes(selection, type, addSelection);
    }

    public static void invertSelection() {
        layer.invertSelection();
    }

    public static void setSelectionOfAllMarkers(boolean selection, boolean addSelection) {
        layer.setSelectionOfAllMarkers(selection, addSelection);
    }

    public static void setSelectionOfAllBuildings(boolean selection, boolean addSelection) {
        layer.setSelectionOfAllBuildings(selection, addSelection);
    }

    public void setLoc(GeoPosition gp) {
        this.setCenterPosition(new GeoPosition(48.39188295873048, -4.44371223449707));
    }

    public static void changeMap(int index) {
        MapLayer.mapViewer.setLoadingImage(new ImageIcon(CupCarbonIcons.class.getResource("mer.png")).getImage());
        mapIdx = index;
        switch (index) {
            case 0: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(0);
                WorldMap.changeTiles("https://a.basemaps.cartocdn.com/light_all/", false);
                WorldMap.darkMap(false);
                break;
            }
            case 1: {
                MapLayer.mapViewer.setLoadingImage(new ImageIcon(CupCarbonIcons.class.getResource("cuptile_black.png")).getImage());
                CupCarbonApp.cupCarbonController.checkMapMenuItem(1);
                WorldMap.changeTiles("https://a.basemaps.cartocdn.com/dark_all/", false);
                WorldMap.darkMap(true);
                break;
            }
            case 2: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(2);
                WorldMap.changeLocalTiles("cuptile_land.png");
                WorldMap.darkMap(false);
                break;
            }
            case 3: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(3);
                WorldMap.changeLocalTiles("cuptile_small_grid.png");
                WorldMap.darkMap(false);
                break;
            }
            case 4: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(4);
                WorldMap.changeLocalTiles("cuptile_small_grid_dark.png");
                WorldMap.darkMap(true);
                break;
            }
            case 5: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(5);
                WorldMap.changeLocalTiles("cuptile_black.png");
                WorldMap.darkMap(true);
                break;
            }
            case 6: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(6);
                WorldMap.changeLocalTiles("cuptile_white.png");
                WorldMap.darkMap(false);
                break;
            }
            case 7: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(7);
                WorldMap.changeLocalTiles("cuptile_grid.png");
                WorldMap.darkMap(false);
                break;
            }
            case 8: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(8);
                WorldMap.changeLocalTiles("cuptile_book.png");
                WorldMap.darkMap(false);
                break;
            }
            case 9: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(9);
                WorldMap.changeLocalTiles("cuptile_grid2.png");
                WorldMap.darkMap(false);
                break;
            }
            case 10: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(10);
                WorldMap.changeTiles("http://mt0.google.com/vt/lyrs=m&hl=en", true);
                WorldMap.darkMap(false);
                break;
            }
            case 11: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(11);
                WorldMap.changeTiles("http://mt0.google.com/vt/lyrs=s&hl=en", true);
                WorldMap.darkMap(true);
                break;
            }
            case 12: {
                CupCarbonApp.cupCarbonController.checkMapMenuItem(12);
                WorldMap.changeTiles("https://tiles.wmflabs.org/bw-mapnik/", false);
                WorldMap.darkMap(false);
            }
        }
    }

    public static void darkMap(boolean b) {
        MapLayer.dark = b;
        if (b && NetworkParameters.radioLinksColor == 0) {
            NetworkParameters.radioLinksColor = 2;
        }
    }

    public static void changeTiles(String s, boolean gmap) {
        WorldMap.gmap = gmap;
        local = false;
        tileUrl = s;
        MapLayer.repaint();
    }

    public static void changeLocalTiles(String s) {
        gmap = false;
        local = true;
        tileName = s;
        Thread th = new Thread(() -> MapLayer.repaint());
        th.start();
    }

    static {
        tileType = ".png";
        tileUrl = "https://a.basemaps.cartocdn.com/light_all/";
        local = true;
        gmap = false;
        tileName = "cuptile_land.png";
        mapIdx = 2;
    }
}

