/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class IntegerArrayConverter
extends AbstractArrayConverter {
    private static int[] model = new int[0];

    public IntegerArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public IntegerArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value.getClass()) {
            return value;
        }
        if (AbstractArrayConverter.strings.getClass() == value.getClass()) {
            try {
                String[] values2 = (String[])value;
                int[] results = new int[values2.length];
                int i = 0;
                while (i < values2.length) {
                    results[i] = Integer.parseInt(values2[i]);
                    ++i;
                }
                return results;
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value.toString(), e);
            }
        }
        try {
            List list = this.parseElements(value.toString());
            int[] results = new int[list.size()];
            int i = 0;
            while (i < results.length) {
                results[i] = Integer.parseInt((String)list.get(i));
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value.toString(), e);
        }
    }
}

