/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.apache.html.dom.HTMLDocumentImpl;
import org.jdesktop.dom.HTMLBuilder;
import org.jdesktop.dom.SimpleHtmlDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleHtmlDocumentBuilder
extends DocumentBuilder {
    private static SimpleHtmlDocumentBuilder INSTANCE;
    private SAXParserFactory factory;

    public SimpleHtmlDocumentBuilder() {
        try {
            this.factory = SAXParserFactory.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create SAXParserFactory", ex);
        }
    }

    public SimpleHtmlDocument parseString(String html) throws SAXException, IOException {
        if (html == null) {
            throw new IllegalArgumentException("html cannot be null");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(html.getBytes());
        return this.parse(in);
    }

    public SimpleHtmlDocument parse(InputSource is) throws SAXException, IOException {
        try {
            HTMLBuilder builder = new HTMLBuilder();
            SAXParser parser = this.factory.newSAXParser();
            parser.parse(is, (DefaultHandler)builder);
            return new SimpleHtmlDocument(builder.getHTMLDocument());
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
    }

    public SimpleHtmlDocument parse(InputStream is) throws SAXException, IOException {
        return (SimpleHtmlDocument)super.parse(is);
    }

    public SimpleHtmlDocument parse(InputStream is, String systemId) throws SAXException, IOException {
        return (SimpleHtmlDocument)super.parse(is, systemId);
    }

    public SimpleHtmlDocument parse(String uri) throws SAXException, IOException {
        return (SimpleHtmlDocument)super.parse(uri);
    }

    public SimpleHtmlDocument parse(File f) throws SAXException, IOException {
        return (SimpleHtmlDocument)super.parse(f);
    }

    public boolean isNamespaceAware() {
        return this.factory.isNamespaceAware();
    }

    public boolean isValidating() {
        return this.factory.isValidating();
    }

    public void setEntityResolver(EntityResolver er) {
    }

    public void setErrorHandler(ErrorHandler eh) {
    }

    public SimpleHtmlDocument newDocument() {
        return new SimpleHtmlDocument(new HTMLDocumentImpl());
    }

    HTMLDocument newPlainDocument() {
        return new HTMLDocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return null;
    }

    public void reset() {
    }

    public Schema getSchema() {
        return this.factory.getSchema();
    }

    public boolean isXIncludeAware() {
        return this.factory.isXIncludeAware();
    }

    private static synchronized SimpleHtmlDocumentBuilder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SimpleHtmlDocumentBuilder();
        }
        return INSTANCE;
    }

    public static SimpleHtmlDocument simpleParse(InputSource is) throws SAXException, IOException {
        return SimpleHtmlDocumentBuilder.getInstance().parse(is);
    }

    public static SimpleHtmlDocument simpleParse(InputStream in) throws SAXException, IOException {
        return SimpleHtmlDocumentBuilder.getInstance().parse(in);
    }

    public static SimpleHtmlDocument simpleParse(URL url) throws SAXException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        InputStream in = url.openStream();
        return SimpleHtmlDocumentBuilder.simpleParse(in);
    }

    public static SimpleHtmlDocument simpleParse(String xml) throws SAXException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        return SimpleHtmlDocumentBuilder.simpleParse(in);
    }
}

