/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.ws;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.jdesktop.http.Request;
import org.jdesktop.http.Response;
import org.jdesktop.http.Session;
import org.jdesktop.ws.AbstractHttpService;

public class HttpService
extends AbstractHttpService {
    private Request request = new Request();
    private Response response;
    private Session.SecurityLevel securityLevel;

    public final Request getRequest() {
        return this.request;
    }

    public void setRequest(Request r) {
        Request old = this.request;
        this.request = r == null ? new Request() : r;
        this.firePropertyChange("request", old, this.request);
    }

    public final Response getResponse() {
        return this.response;
    }

    private void setResponse(Response r) {
        Response old = this.response;
        this.response = r;
        this.firePropertyChange("response", old, this.response);
    }

    public final Session.SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(Session.SecurityLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Security level cannot be null");
        }
        Session.SecurityLevel old = this.securityLevel;
        this.securityLevel = level;
        this.firePropertyChange("securityLevel", (Object)old, (Object)this.securityLevel);
    }

    protected void doSend() {
        super.doSend();
        this.setResponse(null);
    }

    protected SwingWorker createWorker() {
        return new HttpWorker(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HttpWorker
    extends SwingWorker<Response, Response> {
        private HttpService svc;

        HttpWorker(HttpService svc) {
            this.svc = svc;
        }

        @Override
        protected Response doInBackground() throws Exception {
            return this.svc.getSession().execute(this.svc.request);
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    Response r = (Response)this.get();
                    this.svc.setResponse(r);
                    this.svc.done();
                }
                catch (CancellationException cancelled) {
                }
                catch (ExecutionException e) {
                    this.svc.fail(e.getCause());
                }
                catch (Exception e) {
                    this.svc.fail(e);
                }
            }
        }
    }
}

