/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import arduino.BeginInstructions;
import device.SensorNode;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_DREADSENSOR
extends Command {
    protected String arg = "";

    public Command_DREADSENSOR(SensorNode sensor, String arg) {
        this.sensor = sensor;
        this.arg = arg;
    }

    @Override
    public double execute() {
        this.sensor.getBattery().consume(1.0E-4);
        String value = this.sensor.isSensorDetecting() ? "1" : "0";
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " READ SENSOR: " + value);
        this.sensor.getScript().addVariable(this.arg, value);
        return 0.0;
    }

    @Override
    public String getArduinoForm() {
        BeginInstructions.add("pinMode(2, INPUT);");
        String s = "\tString " + this.arg + ";\n";
        s = s + "\t" + this.arg + " = digitalRead(2); \n";
        return s;
    }

    @Override
    public String toString() {
        return "DREADSENSOR";
    }
}

