/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import map.MapLayer;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_MOVE
extends Command {
    protected String arg1 = "";
    protected String arg2 = "";
    protected String arg3 = "";
    protected String arg4 = "";

    public Command_MOVE(SensorNode sensor, String arg1, String arg2, String arg3, String arg4) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
        this.arg4 = arg4;
    }

    @Override
    public double execute() {
        String vArg1 = this.sensor.getScript().getVariableValue(this.arg1);
        String vArg2 = this.sensor.getScript().getVariableValue(this.arg2);
        String vArg3 = this.sensor.getScript().getVariableValue(this.arg3);
        String vArg4 = this.sensor.getScript().getVariableValue(this.arg4);
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " MOVE " + vArg1 + " " + vArg2 + " " + vArg3 + " " + vArg4);
        double currentLongitude = this.sensor.getLongitude();
        double currentLatitude = this.sensor.getLatitude();
        double currentElevation = this.sensor.getElevation();
        double newLongitude = Double.valueOf(vArg1);
        double newLatitude = Double.valueOf(vArg2);
        double newElevation = Double.valueOf(vArg3);
        double speed = Double.valueOf(vArg4);
        double v = MapLayer.distance(currentLongitude, currentLatitude, newLongitude, newLatitude) / speed;
        int n = (int)v;
        double d = v - (double)n;
        double stepX = (newLongitude - currentLongitude) / (double)n;
        double stepY = (newLatitude - currentLatitude) / (double)n;
        double stepZ = (newElevation - currentElevation) / (double)n;
        double x = currentLongitude;
        double y = currentLatitude;
        double z = currentElevation;
        this.sensor.initLocEvents();
        for (int i = 1; i < n; ++i) {
            this.sensor.addLocEvent(1.0, x += stepX, y += stepY, z += stepZ);
        }
        if (d > 0.0) {
            this.sensor.addLocEvent(d, newLongitude, newLatitude, newElevation);
        }
        return 0.0;
    }

    @Override
    public String toString() {
        return "MOVE";
    }
}

