/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import arduino.Bracket;
import cupcarbon.CupCarbonApp;
import device.SensorNode;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_WAIT
extends Command {
    protected String arg = "";

    public Command_WAIT(SensorNode sensor) {
        this.sensor = sensor;
    }

    public Command_WAIT(SensorNode sensor, String arg) {
        this.sensor = sensor;
        this.arg = arg;
    }

    @Override
    public double execute() {
        double event = 0.0;
        if (this.sensor.dataAvailable()) {
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " Buffer available, exit waiting.");
            this.sensor.getScript().setWaiting(false);
            return 0.0;
        }
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " is waiting for data ...");
        this.sensor.getScript().setWaiting(true);
        if (this.arg.equals("")) {
            event = Double.MAX_VALUE;
        } else {
            if (this.sensor.getScript().getVariableValue(this.arg) == null) {
                System.err.println("[CupCarbon ERROR] (File: " + this.sensor.getScriptFileName() + ") (S" + this.sensor.getId() + "): WAIT function (" + this.arg + " is null)");
                CupCarbonApp.cupCarbonController.displayShortErrMessageTh("ERROR");
            }
            event = Double.parseDouble(this.sensor.getScript().getVariableValue(this.arg)) / 1000.0;
        }
        return event;
    }

    @Override
    public boolean isWait() {
        return true;
    }

    @Override
    public String getArduinoForm() {
        ++Bracket.n;
        ++Bracket.n;
        Object s = "";
        s = (String)s + "\txbee.readPacket(" + this.arg + ");\n";
        s = (String)s + "\tif (xbee.getResponse().isAvailable()) {\n";
        s = (String)s + "\tif (xbee.getResponse().getApiId() == RX_64_RESPONSE) {\n";
        return s;
    }

    @Override
    public String toString() {
        return "WAIT";
    }

    @Override
    public String finishMessage() {
        return "S" + this.sensor.getId() + " has finished waiting.";
    }
}

