/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import java.util.ArrayList;
import java.util.Stack;
import senscript.Command;
import senscript.Command_AND;
import senscript.Command_ANGLE;
import senscript.Command_ANGLE2;
import senscript.Command_AREADSENSOR;
import senscript.Command_ATCH;
import senscript.Command_ATGET;
import senscript.Command_ATID;
import senscript.Command_ATMY;
import senscript.Command_ATND;
import senscript.Command_ATPL;
import senscript.Command_BAND;
import senscript.Command_BATTERY;
import senscript.Command_BNOT;
import senscript.Command_BOR;
import senscript.Command_BUFFER;
import senscript.Command_BXOR;
import senscript.Command_CBUFFER;
import senscript.Command_CDISTANCE;
import senscript.Command_CHARAT;
import senscript.Command_CONC;
import senscript.Command_CPRINT;
import senscript.Command_DATA;
import senscript.Command_DECONC;
import senscript.Command_DELAY;
import senscript.Command_DISTANCE;
import senscript.Command_DIV;
import senscript.Command_DREADSENSOR;
import senscript.Command_DRSSI;
import senscript.Command_EDGE;
import senscript.Command_ELSE;
import senscript.Command_ENDFOR;
import senscript.Command_ENDIF;
import senscript.Command_ENDWHILE;
import senscript.Command_FIRST;
import senscript.Command_FOR;
import senscript.Command_FUNCTION;
import senscript.Command_GETINFO;
import senscript.Command_GETPOS;
import senscript.Command_GETPOS2;
import senscript.Command_GETX;
import senscript.Command_GETY;
import senscript.Command_GOTO;
import senscript.Command_HASH;
import senscript.Command_IF;
import senscript.Command_INT;
import senscript.Command_KILL;
import senscript.Command_LAST;
import senscript.Command_LED;
import senscript.Command_LENGTH;
import senscript.Command_LOOP;
import senscript.Command_MARK;
import senscript.Command_MATH;
import senscript.Command_MAX;
import senscript.Command_MIN;
import senscript.Command_MINUS;
import senscript.Command_MMIN;
import senscript.Command_MOD;
import senscript.Command_MOVE;
import senscript.Command_MULT;
import senscript.Command_NOT;
import senscript.Command_NTH;
import senscript.Command_OR;
import senscript.Command_PLUS;
import senscript.Command_PRINT;
import senscript.Command_PRINTFILE;
import senscript.Command_RADIO;
import senscript.Command_RAND;
import senscript.Command_RANDB;
import senscript.Command_RDATA;
import senscript.Command_READ;
import senscript.Command_RECEIVE;
import senscript.Command_RGAUSS;
import senscript.Command_RMOVE;
import senscript.Command_ROTATE;
import senscript.Command_ROUTE;
import senscript.Command_RSCRIPT;
import senscript.Command_SADD;
import senscript.Command_SCOLOR;
import senscript.Command_SCRIPT;
import senscript.Command_SEND;
import senscript.Command_SET;
import senscript.Command_SIMULATION;
import senscript.Command_SMAX;
import senscript.Command_SMIN;
import senscript.Command_SPOP;
import senscript.Command_STOP;
import senscript.Command_TAB;
import senscript.Command_TGET;
import senscript.Command_TIME;
import senscript.Command_TSET;
import senscript.Command_VDATA;
import senscript.Command_VEC;
import senscript.Command_VGET;
import senscript.Command_VSET;
import senscript.Command_WAIT;
import senscript.Command_WFIRST;
import senscript.Command_WHILE;
import senscript.Command_WLAST;
import senscript.Command_XOR;
import senscript.SenScript;

public final class SenScriptAddCommand {
    public static Stack<String> endof = new Stack();

    public static String detectKeyWord(String s) {
        if (!s.startsWith("set ")) {
            return s.replaceFirst("\\(", " (");
        }
        return s;
    }

    public static String[] argSplit(String v) {
        ArrayList<String> t = new ArrayList<String>();
        while (!v.isEmpty()) {
            String s = "";
            if ((v = v.trim()).charAt(0) == '\"') {
                s = v.substring(0, v.substring(1).indexOf(34) + 2);
                v = v.substring(s.length());
            } else {
                s = v.split(" ")[0];
                v = v.split(" ").length > 1 ? v.substring(s.length() + 1) : "";
            }
            t.add(s);
        }
        String[] r = new String[t.size()];
        int i = 0;
        for (String e : t) {
            r[i++] = e;
        }
        return r;
    }

    public static void addCommand(String instStr, SensorNode sensorNode, SenScript script) {
        if (instStr.trim().equals("")) {
            return;
        }
        String[] inst = SenScriptAddCommand.argSplit(instStr = SenScriptAddCommand.detectKeyWord(instStr));
        if (inst[0].split(":").length > 1) {
            sensorNode.getScript().addLabel(inst[0].split(":")[0], sensorNode.getScript().size() + 1);
            inst[0] = inst[0].split(":")[1];
        }
        Command command = null;
        if (inst[0].equalsIgnoreCase("end")) {
            instStr = endof.pop();
            SenScriptAddCommand.addCommand(instStr, sensorNode, script);
        }
        if (inst[0].equalsIgnoreCase("simulation")) {
            command = new Command_SIMULATION(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("script")) {
            command = new Command_SCRIPT(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("rscript")) {
            command = new Command_RSCRIPT(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("kill")) {
            command = new Command_KILL(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("delay")) {
            command = new Command_DELAY(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("set")) {
            command = new Command_SET(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("read")) {
            command = new Command_READ(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("cbuffer")) {
            command = new Command_CBUFFER(sensorNode);
        }
        if (inst[0].equalsIgnoreCase("scolor")) {
            command = new Command_SCOLOR(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("send")) {
            if (inst.length == 2) {
                command = new Command_SEND(sensorNode, inst[1], "*");
            }
            if (inst.length == 3) {
                command = new Command_SEND(sensorNode, inst[1], inst[2]);
            }
            if (inst.length == 4) {
                command = new Command_SEND(sensorNode, inst[1], inst[2], inst[3]);
            }
            if (inst.length == 5) {
                command = new Command_SEND(sensorNode, inst[1], inst[2], inst[3], inst[4]);
            }
        }
        if (inst[0].equalsIgnoreCase("loop")) {
            command = new Command_LOOP(sensorNode);
        }
        if (inst[0].equalsIgnoreCase("wait")) {
            if (inst.length == 1) {
                command = new Command_WAIT(sensorNode);
            }
            if (inst.length == 2) {
                command = new Command_WAIT(sensorNode, inst[1]);
            }
        }
        if (inst[0].equalsIgnoreCase("receive")) {
            if (inst.length == 2) {
                command = new Command_RECEIVE(sensorNode, inst[1]);
            }
            if (inst.length == 3) {
                command = new Command_RECEIVE(sensorNode, inst[1], inst[2]);
            }
        }
        if (inst[0].equalsIgnoreCase("stop")) {
            command = new Command_STOP(sensorNode);
        }
        if (inst[0].equalsIgnoreCase("xor")) {
            command = new Command_XOR(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("and")) {
            command = new Command_AND(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("or")) {
            command = new Command_OR(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("not")) {
            command = new Command_NOT(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("bxor")) {
            command = new Command_BXOR(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("band")) {
            command = new Command_BAND(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("bor")) {
            command = new Command_BOR(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("bnot")) {
            command = new Command_BNOT(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("hash")) {
            command = new Command_HASH(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("plus")) {
            command = new Command_PLUS(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("minus")) {
            command = new Command_MINUS(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("mult")) {
            command = new Command_MULT(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("div")) {
            command = new Command_DIV(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("mod")) {
            command = new Command_MOD(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("tab")) {
            command = new Command_TAB(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("vec")) {
            command = new Command_VEC(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("atnd")) {
            if (inst.length == 2) {
                command = new Command_ATND(sensorNode, inst[1]);
            }
            if (inst.length == 3) {
                command = new Command_ATND(sensorNode, inst[1], inst[2]);
            }
        }
        if (inst[0].equalsIgnoreCase("route")) {
            command = new Command_ROUTE(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("println")) {
            command = new Command_PRINT(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("print")) {
            command = new Command_PRINT(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("printfile")) {
            command = new Command_PRINTFILE(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("data")) {
            command = new Command_DATA(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("rdata")) {
            command = new Command_RDATA(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("last")) {
            command = new Command_LAST(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("wlast")) {
            command = new Command_WLAST(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("first")) {
            command = new Command_FIRST(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("wfirst")) {
            command = new Command_WFIRST(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("nth")) {
            command = new Command_NTH(sensorNode, inst);
        }
        if (inst[0].equalsIgnoreCase("sadd")) {
            command = new Command_SADD(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("spop")) {
            command = new Command_SPOP(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("vdata")) {
            command = new Command_VDATA(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("charat")) {
            command = new Command_CHARAT(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("length")) {
            command = new Command_LENGTH(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("angle")) {
            command = new Command_ANGLE(sensorNode, inst[1], inst[2], inst[3], inst[4]);
        }
        if (inst[0].equalsIgnoreCase("angle2")) {
            command = new Command_ANGLE2(sensorNode, inst[1], inst[2], inst[3], inst[4], inst[5], inst[6], inst[7]);
        }
        if (inst[0].equalsIgnoreCase("edge")) {
            command = new Command_EDGE(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("mark")) {
            command = new Command_MARK(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("mmin")) {
            command = new Command_MMIN(sensorNode, inst[1], inst[2], inst[3], inst[4]);
        }
        if (inst[0].equalsIgnoreCase("smin")) {
            command = new Command_SMIN(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("smax")) {
            command = new Command_SMAX(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("min")) {
            command = new Command_MIN(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("max")) {
            command = new Command_MAX(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("getpos2")) {
            command = new Command_GETPOS2(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("getx")) {
            command = new Command_GETX(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("gety")) {
            command = new Command_GETY(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("buffer")) {
            command = new Command_BUFFER(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("battery")) {
            if (inst.length == 2) {
                command = new Command_BATTERY(sensorNode, inst[1]);
            }
            if (inst.length == 3) {
                command = new Command_BATTERY(sensorNode, inst[1], inst[2]);
            }
        }
        if (inst[0].equalsIgnoreCase("getpos")) {
            command = new Command_GETPOS(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("atget")) {
            command = new Command_ATGET(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("radio")) {
            command = new Command_RADIO(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("rand")) {
            command = new Command_RAND(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("rgauss")) {
            command = new Command_RGAUSS(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("led")) {
            command = new Command_LED(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("randb")) {
            command = new Command_RANDB(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("math")) {
            if (inst.length == 4) {
                command = new Command_MATH(sensorNode, inst[1], inst[2], inst[3]);
            }
            if (inst.length == 5) {
                command = new Command_MATH(sensorNode, inst[1], inst[2], inst[3], inst[4]);
            }
        }
        if (inst[0].equalsIgnoreCase("tset")) {
            command = new Command_TSET(sensorNode, inst[1], inst[2], inst[3], inst[4]);
        }
        if (inst[0].equalsIgnoreCase("vset")) {
            command = new Command_VSET(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("tget")) {
            command = new Command_TGET(sensorNode, inst[1], inst[2], inst[3], inst[4]);
        }
        if (inst[0].equalsIgnoreCase("vget")) {
            command = new Command_VGET(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("dreadsensor")) {
            command = new Command_DREADSENSOR(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("areadsensor")) {
            command = new Command_AREADSENSOR(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("function")) {
            command = new Command_FUNCTION(sensorNode, inst[1], inst[2], inst[3]);
        }
        if (inst[0].equalsIgnoreCase("atni")) {
            command = new Command_ATID(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("atid")) {
            command = new Command_ATID(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("atch")) {
            command = new Command_ATCH(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("atmy")) {
            command = new Command_ATMY(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("atpl")) {
            command = new Command_ATPL(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("getid")) {
            command = new Command_ATGET(sensorNode, "id", inst[1]);
        }
        if (inst[0].equalsIgnoreCase("getmy")) {
            command = new Command_ATGET(sensorNode, "my", inst[1]);
        }
        if (inst[0].equalsIgnoreCase("getch")) {
            command = new Command_ATGET(sensorNode, "ch", inst[1]);
        }
        if (inst[0].equalsIgnoreCase("while")) {
            endof.push("endwhile");
            Command_WHILE commandWhile = new Command_WHILE(sensorNode, instStr);
            if (script.getCurrentWhile() != null) {
                commandWhile.setParent(script.getCurrentWhile());
            }
            script.add(commandWhile);
            script.setCurrentWhile(commandWhile);
            boolean bl = false;
        }
        if (inst[0].equalsIgnoreCase("endwhile")) {
            Command_ENDWHILE commandWEndhile = new Command_ENDWHILE(sensorNode);
            commandWEndhile.setCurrentWhile(script.getCurrentWhile());
            script.getCurrentWhile().setEndWhileIndex(script.size());
            script.removeCurrentWhile();
            script.add(commandWEndhile);
        }
        if (inst[0].equalsIgnoreCase("for")) {
            endof.push("endfor");
            Command_FOR cmdFor = null;
            if (inst.length == 4) {
                cmdFor = new Command_FOR(sensorNode, inst[1], inst[2], inst[3], "1");
            }
            if (inst.length == 5) {
                cmdFor = new Command_FOR(sensorNode, inst[1], inst[2], inst[3], inst[4]);
            }
            if (script.getCurrentFor() != null) {
                cmdFor.setParent(script.getCurrentFor());
            }
            script.add(cmdFor);
            script.setCurrentFor(cmdFor);
        }
        if (inst[0].equalsIgnoreCase("endfor")) {
            Command_ENDFOR cmdEndFor = new Command_ENDFOR(sensorNode);
            cmdEndFor.setCurrentFor(script.getCurrentFor());
            script.getCurrentFor().setEndForIndex(script.size());
            script.removeCurrentFor();
            script.add(cmdEndFor);
        }
        if (inst[0].equalsIgnoreCase("if")) {
            endof.push("endif");
            Command_IF commandIf = new Command_IF(sensorNode, instStr);
            if (script.getCurrentIf() != null) {
                commandIf.setParent(script.getCurrentIf());
            }
            script.setCurrentIf(commandIf);
        }
        if (inst[0].equalsIgnoreCase("else")) {
            command = new Command_ELSE(sensorNode);
            script.getCurrentIf().setElseIndex(script.size());
        }
        if (inst[0].equalsIgnoreCase("endif")) {
            command = new Command_ENDIF(sensorNode);
            script.getCurrentIf().setEndIfIndex(script.size());
            script.removeCurrentIf();
        }
        if (inst[0].equalsIgnoreCase("goto")) {
            command = new Command_GOTO(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("rotate")) {
            command = new Command_ROTATE(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("move")) {
            command = new Command_MOVE(sensorNode, inst[1], inst[2], inst[3], inst[4]);
        }
        if (inst[0].equalsIgnoreCase("rmove")) {
            command = new Command_RMOVE(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("cdistance")) {
            command = new Command_CDISTANCE(sensorNode, inst[1], inst[2], inst[3], inst[4], inst[5]);
        }
        if (inst[0].equalsIgnoreCase("distance")) {
            command = new Command_DISTANCE(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("drssi")) {
            command = new Command_DRSSI(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("inc")) {
            command = new Command_PLUS(sensorNode, inst[1], "$" + inst[1], "1");
        }
        if (inst[0].equalsIgnoreCase("dec")) {
            command = new Command_MINUS(sensorNode, inst[1], "$" + inst[1], "1");
        }
        if (inst[0].equalsIgnoreCase("int")) {
            command = new Command_INT(sensorNode, inst[1], inst[2]);
        }
        if (inst[0].equalsIgnoreCase("conc")) {
            command = new Command_CONC(sensorNode, inst[1], inst[2], inst[3], inst[4]);
        }
        if (inst[0].equalsIgnoreCase("deconc")) {
            command = new Command_DECONC(sensorNode, inst[1], inst[2], inst[3], inst[4]);
        }
        if (inst[0].equalsIgnoreCase("getinfo")) {
            command = new Command_GETINFO(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("time")) {
            command = new Command_TIME(sensorNode, inst[1]);
        }
        if (inst[0].equalsIgnoreCase("cprint")) {
            command = new Command_CPRINT(sensorNode, inst);
        }
        if (command != null) {
            script.add(command);
            command.setCurrentIf(script.getCurrentIf());
            command.setCurrentWhile(script.getCurrentWhile());
            command.setCurrentFor(script.getCurrentFor());
        }
    }
}

