/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import cupcarbon.CupCarbonApp;
import device.SensorNode;
import java.util.ArrayList;
import java.util.StringTokenizer;
import senscript.SenScriptToken;
import senscript.SenScriptTokenStack;

public class SenScriptExpressionCalculate {
    private SenScriptTokenStack operatorStack = new SenScriptTokenStack();
    private SenScriptTokenStack argumentStack = new SenScriptTokenStack();
    private boolean error = false;

    private void processOperator(SensorNode sensor, SenScriptToken token) {
        SenScriptToken arg1 = null;
        SenScriptToken arg2 = null;
        if (this.argumentStack.isEmpty()) {
            System.out.println("Expression error 1");
            this.error = true;
            return;
        }
        arg2 = this.argumentStack.top();
        this.argumentStack.pop();
        if (this.argumentStack.isEmpty()) {
            System.out.println("Expression error 2");
            this.error = true;
            return;
        }
        arg1 = this.argumentStack.top();
        this.argumentStack.pop();
        SenScriptToken result = token.operation(sensor, arg1.getValue(), arg2.getValue());
        this.argumentStack.push(result);
    }

    public String processInput(String expression, SensorNode sensor) {
        expression.replaceAll("\\s+", "");
        ArrayList<SenScriptToken> tokens = new ArrayList<SenScriptToken>();
        StringTokenizer st = new StringTokenizer(expression, "()+-*/%^", true);
        Object script = "";
        String currentToken = "";
        boolean operand = false;
        Object operandToken = "";
        while (st.hasMoreTokens()) {
            currentToken = st.nextToken();
            if (currentToken.startsWith("$") || currentToken.matches("[a-zA-Z0-9]*")) {
                if (!((String)operandToken).isEmpty() && !((String)operandToken).matches(".*\\d.*")) {
                    operandToken = (String)operandToken + "1";
                    tokens.add(new SenScriptToken((String)operandToken));
                    tokens.add(new SenScriptToken("*"));
                    operandToken = "";
                }
                if (sensor.getScript().getVariableValue(currentToken) == null) {
                    System.err.println("[CupCarbon ERROR] (S" + sensor.getId() + "): SET function (" + currentToken + " does not exist)");
                    CupCarbonApp.cupCarbonController.displayShortErrMessageTh("ERROR");
                }
                operandToken = (String)operandToken + sensor.getScript().getVariableValue(currentToken).trim();
                operand = true;
                continue;
            }
            if (currentToken.equals("(")) {
                if (!((String)operandToken).isEmpty() && !((String)operandToken).matches(".*\\d.*")) {
                    operandToken = (String)operandToken + "1";
                    tokens.add(new SenScriptToken((String)operandToken));
                    tokens.add(new SenScriptToken("*"));
                }
                tokens.add(new SenScriptToken(currentToken));
                operandToken = "";
                continue;
            }
            if (operand) {
                if (Character.isDigit(currentToken.charAt(0))) {
                    operandToken = (String)operandToken + currentToken;
                    continue;
                }
                if (currentToken.equals(")")) {
                    if (!((String)operandToken).isEmpty()) {
                        tokens.add(new SenScriptToken((String)operandToken));
                    }
                    tokens.add(new SenScriptToken(currentToken));
                    operandToken = "";
                    continue;
                }
                if (!((String)operandToken).isEmpty()) {
                    tokens.add(new SenScriptToken((String)operandToken));
                }
                tokens.add(new SenScriptToken(currentToken));
                operandToken = "";
                operand = false;
                continue;
            }
            if (Character.isDigit(currentToken.charAt(0))) {
                operand = true;
            }
            operandToken = (String)operandToken + currentToken;
        }
        if (!((String)operandToken).isEmpty()) {
            tokens.add(new SenScriptToken((String)operandToken));
        }
        for (int n = 0; n < tokens.size(); ++n) {
            SenScriptToken toProcess;
            SenScriptToken nextToken = (SenScriptToken)tokens.get(n);
            if (nextToken.getType() == 0) {
                this.argumentStack.push(nextToken);
                continue;
            }
            if (nextToken.getType() == 1) {
                if (this.operatorStack.isEmpty() || nextToken.getPrecedence() > this.operatorStack.top().getPrecedence()) {
                    this.operatorStack.push(nextToken);
                    continue;
                }
                while (!this.operatorStack.isEmpty() && nextToken.getPrecedence() <= this.operatorStack.top().getPrecedence()) {
                    toProcess = this.operatorStack.top();
                    this.operatorStack.pop();
                    this.processOperator(sensor, toProcess);
                }
                this.operatorStack.push(nextToken);
                continue;
            }
            if (nextToken.getType() == 2) {
                this.operatorStack.push(nextToken);
                continue;
            }
            if (nextToken.getType() != 3) continue;
            while (!this.operatorStack.isEmpty() && this.operatorStack.top().getType() == 1) {
                toProcess = this.operatorStack.top();
                this.operatorStack.pop();
                this.processOperator(sensor, toProcess);
            }
            if (!this.operatorStack.isEmpty() && this.operatorStack.top().getType() == 2) {
                this.operatorStack.pop();
                continue;
            }
            System.out.println("Error: unbalanced parenthesis.");
            this.error = true;
        }
        while (!this.operatorStack.isEmpty() && this.operatorStack.top().getType() == 1) {
            SenScriptToken toProcess = this.operatorStack.top();
            this.operatorStack.pop();
            this.processOperator(sensor, toProcess);
        }
        if (!this.error) {
            SenScriptToken result = this.argumentStack.top();
            this.argumentStack.pop();
            if (!this.operatorStack.isEmpty() || !this.argumentStack.isEmpty()) {
                return "Expression error 3";
            }
            script = " " + result.getValue();
            return script;
        }
        return "Expression error 4";
    }
}

