/*
 * Decompiled with CFR 0.152.
 */
package sensorunit;

import device.Device;
import java.awt.Graphics;
import java.awt.Polygon;

public abstract class SensorUnit {
    protected double radius = 10.0;
    protected double longitude;
    protected double latitude;
    protected double elevation;
    protected Device node;
    protected boolean displayRadius = false;
    protected double eSensing = 1.0;
    protected double coverage = 0.0;
    protected double direction = 0.0;
    protected int n = 30;
    protected double deg = 0.209333;
    protected int[] polyX = new int[this.n];
    protected int[] polyY = new int[this.n];

    public SensorUnit(double longitude, double latitude, double elevation, Device node) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.elevation = elevation;
        this.node = node;
    }

    public abstract void calculateSensingArea();

    public void setPosition(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public abstract boolean detect(Device var1);

    public abstract void draw(Graphics var1, int var2, boolean var3, boolean var4);

    public void setNode(Device node) {
        this.node = node;
    }

    public SensorUnit clone() throws CloneNotSupportedException {
        SensorUnit newCU = (SensorUnit)super.clone();
        return newCU;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double getESensing() {
        return this.eSensing;
    }

    public void setESensing(double eSensing) {
        this.eSensing = eSensing;
    }

    public Polygon getPoly() {
        return new Polygon(this.polyX, this.polyY, this.n);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public double getDirection() {
        return this.direction;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public void setDirection(double direction) {
        this.direction = direction;
    }

    public abstract void incRadius(int var1);
}

