/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import map.MapLayer;
import map.NetworkParameters;
import simulation.IoTMessage;
import utilities.MapCalc;

public class IoTChannel {
    public static HashMap<String, IoTMessage> messages = new HashMap();

    public static void add(IoTMessage message) {
        String ids = "" + message.getSSensor().getId();
        String idr = "" + message.getRSensor().getId();
        String key = ids + "_" + idr;
        messages.put(key, message);
    }

    public static void remove(IoTMessage message) {
        String ids = "" + message.getSSensor().getId();
        String idr = "" + message.getRSensor().getId();
        String key = ids + "_" + idr;
        messages.remove(key);
    }

    public static void draw(Graphics g) {
        try {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(2.0f));
            for (String key : messages.keySet()) {
                IoTMessage message = messages.get(key);
                g2.setColor(Color.RED);
                if (MapLayer.mapViewer.getZoom() < 2) {
                    g2.setStroke(new BasicStroke(3.0f));
                }
                int[] coord = MapCalc.geoToPixelMapA(message.getSSensor().getLatitude(), message.getSSensor().getLongitude());
                int lx1 = coord[0];
                int ly1 = coord[1];
                coord = MapCalc.geoToPixelMapA(message.getRSensor().getLatitude(), message.getRSensor().getLongitude());
                int lx2 = coord[0];
                int ly2 = coord[1];
                double dx = lx2 - lx1;
                double dy = ly2 - ly1;
                g.drawLine(lx1, ly1, lx2, ly2);
                double alpha = Math.atan(dy / dx);
                alpha = 180.0 * alpha / Math.PI;
                int as = 16;
                if (dx >= 0.0) {
                    g.fillArc(lx2 - as, ly2 - as, as * 2, as * 2, 180 - (int)alpha - as, as * 2);
                } else {
                    g.fillArc(lx2 - as, ly2 - as, as * 2, as * 2, -((int)alpha) - as, as * 2);
                }
                if (!NetworkParameters.displayRadioMessages) continue;
                MapLayer.drawMessage(lx1, lx2, ly1, ly2, message.getMessage(), g2);
                MapLayer.drawMessageAttempts(lx1, lx2, ly1, ly2, "" + (message.getSSensor().getAttempts() + 1), g2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

