/*
 * Decompiled with CFR 0.152.
 */
package solver;

import device.Device;
import device.DeviceList;
import device.SensorNode;
import java.util.Vector;
import map.MapLayer;

public class EnvelopeJarvis
extends Thread {
    protected int delayTime = 100;

    @Override
    public void run() {
        Vector<SensorNode> nodes = DeviceList.sensors;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double xc = 0.0;
        double yc = 0.0;
        double angle = 0.0;
        int current = 0;
        int first = 0;
        int previous = 0;
        double min = 0.0;
        int imin = 0;
        boolean stop = false;
        DeviceList.initAll();
        DeviceList.addHull();
        min = 1.0E7;
        imin = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            ((SensorNode)nodes.get(i)).setMarked(false);
            if (!(((SensorNode)nodes.get(i)).getLatitude() < min)) continue;
            min = ((SensorNode)nodes.get(i)).getLatitude();
            imin = i;
        }
        first = imin;
        previous = imin;
        current = imin;
        ((SensorNode)nodes.get(imin)).setMarked(true);
        MapLayer.repaint();
        DeviceList.addToLastHull(imin);
        this.delay();
        Device n1 = (Device)nodes.get(current);
        xc = n1.getLatitude();
        yc = n1.getLongitude();
        x1 = xc - 0.1;
        y1 = yc;
        stop = false;
        while (!stop) {
            min = 1000.0;
            imin = -1;
            for (int j = 0; j < nodes.size(); ++j) {
                Device n2 = (Device)nodes.get(j);
                if (((SensorNode)nodes.get(j)).isDead() || current == j || j == previous || !((angle = this.getAngle(x1 - xc, y1 - yc, (x2 = n2.getLatitude()) - xc, (y2 = n2.getLongitude()) - yc)) < min)) continue;
                imin = j;
                min = angle;
            }
            if (imin == first) {
                stop = true;
            }
            if (imin == -1) {
                imin = current;
            }
            ((SensorNode)nodes.get(imin)).setMarked(true);
            MapLayer.repaint();
            DeviceList.addToLastHull(imin);
            previous = current;
            n1 = (Device)nodes.get(imin);
            current = imin;
            x1 = xc;
            y1 = yc;
            xc = ((SensorNode)nodes.get(imin)).getLatitude();
            yc = ((SensorNode)nodes.get(imin)).getLongitude();
            this.delay();
        }
        System.out.println("FINISH !");
    }

    public double getAngle(double x1, double y1, double x2, double y2) {
        double b;
        double a = Math.atan2(x1, y1);
        if (a < 0.0) {
            a = Math.PI * 2 + a;
        }
        if ((b = Math.atan2(x2, y2)) < 0.0) {
            b = Math.PI * 2 + b;
        }
        if ((b -= a) < 0.0) {
            b = Math.PI * 2 + b;
        }
        return b;
    }

    public static boolean intersect(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        if (x0 == x2 && y0 == y2) {
            return false;
        }
        if (x0 == x3 && y0 == y3) {
            return false;
        }
        if (x1 == x2 && y1 == y2) {
            return false;
        }
        if (x1 == x3 && y1 == y3) {
            return false;
        }
        double dx1 = x1 - x0;
        double dy1 = y1 - y0;
        double dx2 = x3 - x2;
        double dy2 = y3 - y2;
        double s = (-dy1 * (x0 - x2) + dx1 * (y0 - y2)) / (-dx2 * dy1 + dx1 * dy2);
        double t = (dx2 * (y0 - y2) - dy2 * (x0 - x2)) / (-dx2 * dy1 + dx1 * dy2);
        return s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0;
    }

    public void delay() {
        try {
            EnvelopeJarvis.sleep(this.delayTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

