/*
 * Decompiled with CFR 0.152.
 */
package solver;

import device.DeviceList;
import device.SensorNode;
import java.util.Vector;
import map.MapLayer;

public class NetworkEnvelopeNAN
extends Thread {
    public void runs() {
        DeviceList.sensors.get(25).setMarked(true);
    }

    @Override
    public void run() {
        Vector<SensorNode> nodes = DeviceList.sensors;
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double xc = 0.0;
        double yc = 0.0;
        double angle = 0.0;
        int current = 0;
        int first = 0;
        int previous = 0;
        double min = 0.0;
        int imin = 0;
        boolean stop = false;
        DeviceList.initAll();
        DeviceList.addHull();
        DeviceList.initLastHull();
        min = 1.0E7;
        imin = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            ((SensorNode)nodes.get(i)).setMarked(false);
            if (!((SensorNode)nodes.get(i)).isSelected()) continue;
            imin = i;
        }
        first = imin;
        previous = imin;
        current = imin;
        ((SensorNode)nodes.get(imin)).setMarked(true);
        MapLayer.repaint();
        DeviceList.addToLastHull(imin);
        this.delay();
        SensorNode n1 = (SensorNode)nodes.get(current);
        xc = n1.getLatitude();
        yc = n1.getLongitude();
        x0 = xc - 0.2;
        y0 = yc - 0.2;
        SensorNode n3 = null;
        x1 = xc - 0.1;
        y1 = yc;
        SensorNode n4 = null;
        stop = false;
        boolean b1 = false;
        boolean b2 = false;
        while (!stop) {
            min = 1000.0;
            imin = -1;
            for (int j = 0; j < nodes.size(); ++j) {
                SensorNode n2 = (SensorNode)nodes.get(j);
                if (((SensorNode)nodes.get(j)).isDead() || current == j || !n1.radioDetect(n2) || j == previous) continue;
                x2 = n2.getLatitude();
                y2 = n2.getLongitude();
                angle = this.getAngle(x1 - xc, y1 - yc, x2 - xc, y2 - yc);
                b1 = NetworkEnvelopeNAN.intersect(x0, y0, x1, y1, xc, yc, x2, y2);
                boolean bl = b2 = n3 == null || n4 == null ? false : n3.radioDetect(n4);
                if (!(angle < min) || b1 && b2) continue;
                imin = j;
                min = angle;
            }
            if (imin == first) {
                stop = true;
            }
            if (imin == -1) {
                imin = current;
            }
            ((SensorNode)nodes.get(imin)).setMarked(true);
            MapLayer.repaint();
            DeviceList.addToLastHull(imin);
            previous = current;
            n3 = n4;
            n4 = n1;
            n1 = (SensorNode)nodes.get(imin);
            current = imin;
            x0 = x1;
            y0 = y1;
            x1 = xc;
            y1 = yc;
            xc = ((SensorNode)nodes.get(imin)).getLatitude();
            yc = ((SensorNode)nodes.get(imin)).getLongitude();
            this.delay();
        }
        System.out.println("FINISH !");
    }

    public double getAngle(double x1, double y1, double x2, double y2) {
        double b;
        double a = Math.atan2(x1, y1);
        if (a < 0.0) {
            a = Math.PI * 2 + a;
        }
        if ((b = Math.atan2(x2, y2)) < 0.0) {
            b = Math.PI * 2 + b;
        }
        if ((b -= a) < 0.0) {
            b = Math.PI * 2 + b;
        }
        return b;
    }

    public static boolean intersect(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double dx1 = x1 - x0;
        double dy1 = y1 - y0;
        double dx2 = x3 - x2;
        double dy2 = y3 - y2;
        double s = (-dy1 * (x0 - x2) + dx1 * (y0 - y2)) / (-dx2 * dy1 + dx1 * dy2);
        double t = (dx2 * (y0 - y2) - dy2 * (x0 - x2)) / (-dx2 * dy1 + dx1 * dy2);
        return s > 0.0 && s < 1.0 && t > 0.0 && t < 1.0;
    }

    public void delay() {
        try {
            NetworkEnvelopeNAN.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

