/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext;

import java.util.Objects;
import jfx.incubator.scene.control.richtext.TextPos;

public final class SelectionSegment {
    private final TextPos min;
    private final TextPos max;
    private final boolean caretAtMin;

    public SelectionSegment(TextPos textPos, TextPos textPos2) {
        Objects.requireNonNull(textPos, "anchor cannot be null");
        Objects.requireNonNull(textPos2, "caret cannot be null");
        if (textPos.compareTo(textPos2) <= 0) {
            this.min = textPos;
            this.max = textPos2;
            this.caretAtMin = false;
        } else {
            this.min = textPos2;
            this.max = textPos;
            this.caretAtMin = true;
        }
    }

    public final TextPos getAnchor() {
        return this.caretAtMin ? this.max : this.min;
    }

    public final TextPos getCaret() {
        return this.caretAtMin ? this.min : this.max;
    }

    public final TextPos getMin() {
        return this.min;
    }

    public TextPos getMax() {
        return this.max;
    }

    public boolean isCollapsed() {
        return this.min.equals(this.max);
    }

    public String toString() {
        return "SelectionSegment{" + String.valueOf(this.min) + ", " + String.valueOf(this.max) + ", caretAtMin=" + this.caretAtMin + "}";
    }

    private static <T extends Comparable<T>> void isLessThanOrEqual(T t, T t2, String string, String string2) {
        if (t.compareTo(t2) > 0) {
            throw new IllegalArgumentException(string + " must be less or equal to " + string2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SelectionSegment) {
            SelectionSegment selectionSegment = (SelectionSegment)object;
            return this.caretAtMin == selectionSegment.caretAtMin && this.min.equals(selectionSegment.min) && this.max.equals(selectionSegment.max);
        }
        return false;
    }

    public int hashCode() {
        int n = SelectionSegment.class.hashCode();
        n = 31 * n + Boolean.hashCode(this.caretAtMin);
        n = 31 * n + this.min.hashCode();
        n = 31 * n + this.max.hashCode();
        return n;
    }
}

