/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext;

import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import jfx.incubator.scene.control.richtext.Marker;
import jfx.incubator.scene.control.richtext.SelectionModel;
import jfx.incubator.scene.control.richtext.SelectionSegment;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;

public final class SingleSelectionModel
implements SelectionModel {
    private final ReadOnlyObjectWrapper<SelectionSegment> segment = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<TextPos> anchorPosition = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<TextPos> caretPosition = new ReadOnlyObjectWrapper();
    private final ChangeListener<TextPos> anchorListener = (observableValue, textPos, textPos2) -> {
        this.anchorPosition.set(textPos2);
        this.segment.set((Object)new SelectionSegment((TextPos)textPos2, (TextPos)this.caretPosition.get()));
    };
    private final ChangeListener<TextPos> caretListener = (observableValue, textPos, textPos2) -> {
        this.caretPosition.set(textPos2);
        this.segment.set((Object)new SelectionSegment((TextPos)this.anchorPosition.get(), (TextPos)textPos2));
    };
    private Marker anchorMarker;
    private Marker caretMarker;
    private StyledTextModel model;

    @Override
    public void clear() {
        this.setSelectionSegment(null, null);
    }

    @Override
    public void setSelection(StyledTextModel styledTextModel, TextPos textPos, TextPos textPos2) {
        textPos = styledTextModel.clamp(textPos);
        textPos2 = styledTextModel.clamp(textPos2);
        SelectionSegment selectionSegment = new SelectionSegment(textPos, textPos2);
        this.setSelectionSegment(styledTextModel, selectionSegment);
    }

    @Override
    public void extendSelection(StyledTextModel styledTextModel, TextPos textPos) {
        TextPos textPos2;
        if (this.isFlippingModel(styledTextModel)) {
            this.setSelection(styledTextModel, textPos, textPos);
            return;
        }
        textPos = styledTextModel.clamp(textPos);
        SelectionSegment selectionSegment = this.getSelection();
        TextPos textPos3 = textPos2 = selectionSegment == null ? null : selectionSegment.getAnchor();
        textPos2 = textPos2 == null ? textPos : (textPos.compareTo(selectionSegment.getMin()) < 0 ? selectionSegment.getMax() : (textPos.compareTo(selectionSegment.getMax()) > 0 ? selectionSegment.getMin() : selectionSegment.getAnchor()));
        this.setSelection(styledTextModel, textPos2, textPos);
    }

    private boolean isFlippingModel(StyledTextModel styledTextModel) {
        if (this.model == null) {
            return false;
        }
        if (styledTextModel == null) {
            return false;
        }
        return styledTextModel != this.model;
    }

    @Override
    public ReadOnlyProperty<TextPos> anchorPositionProperty() {
        return this.anchorPosition.getReadOnlyProperty();
    }

    @Override
    public ReadOnlyProperty<TextPos> caretPositionProperty() {
        return this.caretPosition;
    }

    private void setSelectionSegment(StyledTextModel styledTextModel, SelectionSegment selectionSegment) {
        this.model = styledTextModel;
        if (this.anchorMarker != null) {
            this.anchorMarker.textPosProperty().removeListener(this.anchorListener);
            this.anchorMarker = null;
        }
        if (this.caretMarker != null) {
            this.caretMarker.textPosProperty().removeListener(this.caretListener);
            this.caretMarker = null;
        }
        if (selectionSegment == null) {
            this.anchorPosition.set(null);
            this.caretPosition.set(null);
        } else {
            TextPos textPos = selectionSegment.getAnchor();
            this.anchorMarker = styledTextModel.getMarker(textPos);
            this.anchorPosition.set((Object)textPos);
            this.anchorMarker.textPosProperty().addListener(this.anchorListener);
            textPos = selectionSegment.getCaret();
            this.caretMarker = styledTextModel.getMarker(textPos);
            this.caretPosition.set((Object)textPos);
            this.caretMarker.textPosProperty().addListener(this.caretListener);
        }
        this.segment.set((Object)selectionSegment);
    }

    @Override
    public ReadOnlyProperty<SelectionSegment> selectionProperty() {
        return this.segment.getReadOnlyProperty();
    }

    @Override
    public SelectionSegment getSelection() {
        return (SelectionSegment)this.segment.get();
    }
}

