/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;

class InputMethodSupport {
    InputMethodSupport() {
    }

    public static ObservableList<InputMethodTextRun> inputMethodEventComposed(String text, int commitCount) {
        ArrayList<InputMethodTextRun> composed = new ArrayList<InputMethodTextRun>();
        if (commitCount < text.length()) {
            composed.add(new InputMethodTextRun(text.substring(commitCount), InputMethodHighlight.UNSELECTED_RAW));
        }
        return new ObservableListWrapper<InputMethodTextRun>(composed);
    }

    public static String getTextForEvent(InputMethodEvent e) {
        AttributedCharacterIterator text = e.getText();
        if (e.getText() != null) {
            char c = text.first();
            StringBuilder result = new StringBuilder();
            while (c != '\uffff') {
                result.append(c);
                c = text.next();
            }
            return result.toString();
        }
        return "";
    }

    public static class InputMethodRequestsAdapter
    implements java.awt.im.InputMethodRequests {
        private final InputMethodRequests fxRequests;

        public InputMethodRequestsAdapter(InputMethodRequests fxRequests) {
            this.fxRequests = fxRequests;
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo offset) {
            AtomicReference<Point2D> location = new AtomicReference<Point2D>(new Point2D(0.0, 0.0));
            if (this.fxRequests != null) {
                PlatformImpl.runAndWait(() -> location.set(this.fxRequests.getTextLocation(offset.getInsertionIndex())));
            }
            return new Rectangle((int)location.get().getX(), (int)location.get().getY(), 0, 0);
        }

        @Override
        public TextHitInfo getLocationOffset(int x, int y) {
            AtomicInteger offset = new AtomicInteger(0);
            if (this.fxRequests != null) {
                PlatformImpl.runAndWait(() -> offset.set(this.fxRequests.getLocationOffset(x, y)));
            }
            return TextHitInfo.afterOffset(offset.get());
        }

        @Override
        public int getInsertPositionOffset() {
            AtomicInteger offset = new AtomicInteger(0);
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                PlatformImpl.runAndWait(() -> offset.set(((ExtendedInputMethodRequests)this.fxRequests).getInsertPositionOffset()));
            }
            return offset.get();
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            String text;
            AtomicReference<Object> committed = new AtomicReference<Object>(null);
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                PlatformImpl.runAndWait(() -> committed.set(((ExtendedInputMethodRequests)this.fxRequests).getCommittedText(beginIndex, endIndex)));
            }
            if ((text = (String)committed.get()) == null) {
                text = "";
            }
            return new AttributedString(text).getIterator();
        }

        @Override
        public int getCommittedTextLength() {
            AtomicInteger length = new AtomicInteger(0);
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                PlatformImpl.runAndWait(() -> length.set(((ExtendedInputMethodRequests)this.fxRequests).getCommittedTextLength()));
            }
            return length.get();
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            String text;
            AtomicReference<Object> selected = new AtomicReference<Object>(null);
            if (this.fxRequests != null) {
                PlatformImpl.runAndWait(() -> selected.set(this.fxRequests.getSelectedText()));
            }
            if ((text = (String)selected.get()) == null) {
                text = "";
            }
            return new AttributedString(text).getIterator();
        }
    }
}

