/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import device.Device;
import device.DeviceList;
import markers.Marker;
import markers.MarkerList;

public class CupCommand_MOVE
extends CupCommand {
    protected String type;
    protected String name;
    protected String longitudeShift;
    protected String latitudeShift;
    protected String elevationShift;
    protected String sType;
    protected String sName;
    protected String sLongitudeShift;
    protected String sLatitudeShift;
    protected String sElevationShift;

    public CupCommand_MOVE(CupScript script, String type, String name, String longitudeShift, String latitudeShift, String elevationShift) {
        this.script = script;
        this.type = type;
        this.name = name;
        this.longitudeShift = longitudeShift;
        this.latitudeShift = latitudeShift;
        this.elevationShift = elevationShift;
    }

    @Override
    public String execute() {
        currentExecution = false;
        Object rep = "";
        this.sType = this.script.getVariableValue(this.type);
        this.sName = this.script.getVariableValue(this.name);
        this.sLongitudeShift = this.script.getVariableValue(this.longitudeShift);
        this.sLatitudeShift = this.script.getVariableValue(this.latitudeShift);
        this.sElevationShift = this.script.getVariableValue(this.elevationShift);
        if (isExecuted) {
            switch (this.sType) {
                case "node": {
                    Device node = DeviceList.getNodeByName(this.sName);
                    if (node != null) {
                        node.setLongitude(node.getLongitude() + Double.parseDouble(this.sLongitudeShift));
                        node.setLatitude(node.getLatitude() + Double.parseDouble(this.sLatitudeShift));
                        node.setElevation(node.getElevation() + Double.parseDouble(this.sElevationShift));
                        rep = "000 Moving Object: " + this.sName + " to the New Coordinates: " + node.getLongitude() + ", " + node.getLatitude() + ", " + node.getElevation();
                        currentExecution = true;
                        break;
                    }
                    rep = "There is no node with the name " + this.sName + ", try again!";
                    currentExecution = true;
                    break;
                }
                case "marker": {
                    for (Marker marker : MarkerList.markers) {
                        if (Integer.parseInt(this.sName) > MarkerList.markers.size() - 1) {
                            rep = "There is no marker with the index " + this.sName + ", try again!";
                            currentExecution = true;
                            break;
                        }
                        if (MarkerList.getIndex(marker) != Integer.parseInt(this.sName)) continue;
                        marker.setLongitude(marker.getLongitude() + Double.parseDouble(this.sLatitudeShift));
                        marker.setLatitude(marker.getLatitude() + Double.parseDouble(this.sLatitudeShift));
                        marker.setElevation(marker.getElevation() + Double.parseDouble(this.sLatitudeShift));
                        rep = "000 Moving Marker: " + this.sName + " to the New Coordinates: " + marker.getLongitude() + ", " + marker.getLatitude() + ", " + marker.getElevation();
                    }
                    currentExecution = true;
                    break;
                }
                default: {
                    rep = "[ERROR] Unknown type " + this.sType;
                    currentExecution = false;
                    break;
                }
            }
        } else {
            rep = "ERROR IN EXECUTING THE PREVIOUS STEP, THE SCRIPT WILL NOT CONTINUE TO EXECUTE";
            this.script.setBreaked(true);
        }
        System.out.println((String)rep);
        CupScript.slog.println((String)rep);
        isExecuted = currentExecution;
        return rep;
    }

    @Override
    public String toString() {
        return "move " + this.sType + " " + this.sLongitudeShift + " " + this.sLatitudeShift + " " + this.sElevationShift;
    }
}

