/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupCommand;
import cupcarbon_script.CupCommand_FOR;
import cupcarbon_script.CupCommand_IF;
import cupcarbon_script.CupCommand_WHILE;
import cupcarbon_script.CupVariableList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class CupScript {
    protected LinkedList<CupCommand> commands = new LinkedList();
    protected LinkedList<String> scommands = new LinkedList();
    public static FileOutputStream fis;
    public static PrintStream slog;
    protected int index = 0;
    protected int loopIndex = 0;
    protected boolean stopped = false;
    protected int level;
    protected CupScript parent;
    protected CupCommand_IF currentIf = null;
    protected CupCommand_WHILE currentWhile = null;
    protected CupCommand_FOR currentFor = null;
    protected CupVariableList variables = new CupVariableList();
    protected Hashtable<String, Integer> labels = new Hashtable();

    public CupScript() {
        try {
            fis = new FileOutputStream("log");
            slog = new PrintStream(fis);
            slog.println("Script");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void add(CupCommand command) {
        this.commands.add(command);
    }

    public void sAdd(String scommand) {
        this.scommands.add(scommand);
    }

    public void next() {
        if (!this.stopped) {
            ++this.index;
            if (this.index >= this.commands.size()) {
                this.index = this.loopIndex;
            }
        }
    }

    public String nextAndExecute() {
        if (!this.stopped) {
            ++this.index;
            if (this.index >= this.commands.size()) {
                this.index = this.loopIndex;
            }
            return this.executeCommand();
        }
        return "111";
    }

    public void previous() {
        if (!this.stopped) {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
        }
    }

    public void init() {
        this.variables = new CupVariableList();
        this.index = 0;
        this.loopIndex = 0;
        this.stopped = false;
        this.level = 0;
    }

    public int size() {
        return this.commands.size();
    }

    public CupCommand getCurrent() {
        return this.commands.get(this.index);
    }

    public String toString() {
        Object s = "";
        Iterator it = this.commands.iterator();
        while (it.hasNext()) {
            s = (String)s + String.valueOf(it.next()) + "\n";
        }
        return s;
    }

    public String executeCommand() {
        return this.getCurrent().execute();
    }

    public void addVariable(String s1, String s2) {
        this.variables.put(s1, s2);
    }

    public void putVariable(String var, String s) {
        this.variables.put(var, s);
    }

    public String getVariableValue(String arg) {
        if (arg.equals("\\")) {
            return "";
        }
        if (arg.equals("")) {
            return "";
        }
        if (arg.charAt(0) == '$') {
            return this.variables.getValue(arg.substring(1));
        }
        return arg;
    }

    public void variablesToValues(String[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].charAt(0) != '$') continue;
            args2[i] = this.variables.getValue(args2[i].substring(1));
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setIndexToLoopIndex() {
        this.loopIndex = this.index;
    }

    public void setBreaked(boolean b) {
        this.stopped = b;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLevel() {
        return this.level;
    }

    public CupScript getParent() {
        return this.parent;
    }

    public void setCurrentIf(CupCommand_IF command) {
        this.currentIf = command;
        this.add(command);
    }

    public CupCommand_IF getCurrentIf() {
        return this.currentIf;
    }

    public CupCommand_IF removeCurrentIf() {
        this.currentIf = this.currentIf.getParent();
        return this.currentIf;
    }

    public CupCommand_WHILE getCurrentWhile() {
        return this.currentWhile;
    }

    public void setCurrentWhile(CupCommand_WHILE currentWhile) {
        this.currentWhile = currentWhile;
    }

    public CupCommand_WHILE removeCurrentWhile() {
        this.currentWhile = this.currentWhile.getParent();
        return this.currentWhile;
    }

    public CupCommand_FOR getCurrentFor() {
        return this.currentFor;
    }

    public void setCurrentFor(CupCommand_FOR currentFor) {
        this.currentFor = currentFor;
    }

    public CupCommand_FOR removeCurrentFor() {
        this.currentFor = this.currentFor.getParent();
        return this.currentFor;
    }

    public LinkedList<CupCommand> getCommands() {
        return this.commands;
    }

    public boolean variableExist(String var) {
        return this.variables.exist(var);
    }

    public void removeVar(String var) {
        this.variables.remove(var);
    }

    public void displayVars() {
        System.out.println(this.variables);
    }

    public void addLabel(String label, int lineNumber) {
        this.labels.put(label, lineNumber);
    }

    public int getLineOfLabel(String label) {
        return this.labels.get(label);
    }

    public void display() {
        for (CupCommand command : this.commands) {
            System.out.println(command);
        }
    }

    public void sDisplay() {
        for (String scommand : this.scommands) {
            System.out.println(scommand);
        }
    }

    public static void close() {
        slog.close();
        try {
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

