/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupScript;
import cupcarbon_script.CupScriptAddCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javafx.application.Application;
import javafx.stage.Stage;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import map.MapLayer;
import map.WorldMap;

public abstract class SCupCarbonConsole
extends Application {
    public static Stage stage;

    public static void main(String[] args2) throws IOException {
        CupScript script = new CupScript();
        CupScript.slog.println("Script");
        new WorldMap();
        CupScript.slog.println("Init Worls Map");
        MapLayer.initLists();
        CupScript.slog.println("Init Object lists");
        JFileChooser fileChooser = new JFileChooser("Open CupCarbon Script file");
        FileFilter ScriptFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return pathname.getName().endsWith(".scc");
            }

            @Override
            public String getDescription() {
                return "CupCarbon Script files";
            }
        };
        fileChooser.setFileFilter(ScriptFilter);
        int val = fileChooser.showDialog(fileChooser, "Load CupCarbon Script Source");
        if (val == 0) {
            SCupCarbonConsole.loadAndExecute(script, fileChooser.getSelectedFile().getParentFile().toString(), fileChooser.getSelectedFile().getName().toString());
        }
        System.out.println("BYE");
        CupScript.close();
    }

    public static void loadAndExecute(CupScript script, String path, String fileName) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(path + File.separator + fileName));
            String s = "";
            while ((s = br.readLine()) != null) {
                CupScriptAddCommand.addCommand(script, s.trim());
                script.nextAndExecute();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

