/*
 * Decompiled with CFR 0.152.
 */
package device;

import action.CupActionAddSensor;
import action.CupActionBlock;
import action.CupActionDeleteDevice;
import action.CupActionDeleteSensor;
import action.CupActionStack;
import buildings.Building;
import buildings.BuildingList;
import cupcarbon.CupCarbonApp;
import device.BaseStation;
import device.Device;
import device.DirectionalSensorNode;
import device.IoTNode;
import device.IoTNodeCom;
import device.MapObject;
import device.Mobile;
import device.MultiChannels;
import device.SensorNode;
import device.StdSensorNode;
import geometry.SNEdge;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javafx.application.Platform;
import map.MapLayer;
import map.NetworkParameters;
import markers.Marker;
import markers.MarkerList;
import natural_events.Gas;
import natural_events.Weather;
import project.Project;
import simulation.WisenSimulation;
import solver.SensorGraph;
import utilities.MapCalc;

public class DeviceList {
    public static Weather weather = null;
    public static Vector<SensorNode> sensors = new Vector();
    public static Vector<Device> devices = new Vector();
    public static Vector<SNEdge> markedEdges = new Vector();
    public static boolean drawLinks = true;
    public static LinkedList<LinkedList<Integer>> hulls = new LinkedList();
    public static int number = 1;
    public static boolean propagationsCalculated = false;

    public DeviceList() {
        DeviceList.reset();
    }

    public static void reset() {
        weather = null;
        sensors = new Vector();
        devices = new Vector();
        drawLinks = true;
        hulls = new LinkedList();
        markedEdges.removeAll(markedEdges);
        markedEdges = new Vector();
        propagationsCalculated = false;
    }

    public static Device getNodeById(int id) {
        for (SensorNode sensor : sensors) {
            if (sensor.getId() != id) continue;
            return sensor;
        }
        for (Device device : devices) {
            if (device.getId() != id) continue;
            return device;
        }
        return null;
    }

    public static Device getNodeByName(String name) {
        for (SensorNode sensor : sensors) {
            if (!sensor.getName().equals(name)) continue;
            return sensor;
        }
        for (Device device : devices) {
            if (!device.getName().equals(name)) continue;
            return device;
        }
        return null;
    }

    public static SensorNode getSensorNodeById(int id) {
        for (SensorNode sensor : sensors) {
            if (sensor.getId() != id) continue;
            return sensor;
        }
        return null;
    }

    public static SensorNode getSensorNodeById(String sid) {
        for (SensorNode sensor : sensors) {
            if (sensor.getId() != Integer.parseInt(sid)) continue;
            return sensor;
        }
        return null;
    }

    public static IoTNode getIoTNodeById(int id) {
        for (SensorNode iotNode : sensors) {
            if (iotNode.getType() != 13 || iotNode.getId() != id) continue;
            return (IoTNode)iotNode;
        }
        return null;
    }

    public static SensorNode getSensorNodeByMy(int my) {
        for (SensorNode device : sensors) {
            if (device.getCurrentRadioModule().getMy() != my) continue;
            return device;
        }
        return null;
    }

    public static List<Device> getMobileNodes() {
        ArrayList<Device> snodes = new ArrayList<Device>();
        for (Device node : devices) {
            if (node.getType() != 6) continue;
            snodes.add(node);
        }
        return snodes;
    }

    public static List<SensorNode> getMobileSensorNodes() {
        ArrayList<SensorNode> snodes = new ArrayList<SensorNode>();
        for (SensorNode sensor : sensors) {
            if (sensor.getGPSFileName().equals("")) continue;
            snodes.add(sensor);
        }
        return snodes;
    }

    public static List<IoTNode> getIoTNodes() {
        ArrayList<IoTNode> nodes = new ArrayList<IoTNode>();
        for (SensorNode sensor : sensors) {
            if (sensor.getType() != 13) continue;
            nodes.add((IoTNode)sensor);
        }
        return nodes;
    }

    public static void setCanMoveForAllIoTNodes(boolean canMove) {
        for (SensorNode sensor : sensors) {
            if (sensor.getType() != 13) continue;
            ((IoTNode)sensor).setCanMove(canMove);
        }
    }

    public static void saveDevicesAndSensors(String fileName) {
        for (Device device : devices) {
            device.save(fileName);
        }
        for (SensorNode sensor : sensors) {
            sensor.save("" + sensor.getId());
        }
    }

    public static void open() {
        try {
            File nodeFolder = new File(Project.getProjectNodePath());
            File[] nodeFiles = nodeFolder.listFiles();
            int deviceType = -1;
            int idMax = 0;
            for (int i = 0; i < nodeFiles.length; ++i) {
                if (nodeFiles[i].getName().split("_")[0].startsWith(".")) continue;
                BufferedReader br = new BufferedReader(new FileReader(nodeFiles[i]));
                String line = br.readLine();
                line = br.readLine();
                line = br.readLine();
                deviceType = Integer.parseInt(line.split(":")[1]);
                switch (deviceType) {
                    case 1: {
                        SensorNode sensor = DeviceList.loadSensor(nodeFiles[i].getAbsolutePath());
                        DeviceList.add(sensor);
                        break;
                    }
                    case 2: {
                        DeviceList.add(DeviceList.loadGas(nodeFiles[i].getAbsolutePath()));
                        break;
                    }
                    case 4: {
                        SensorNode sensor = DeviceList.loadBaseStation(nodeFiles[i].getAbsolutePath());
                        DeviceList.add(sensor);
                        break;
                    }
                    case 5: {
                        SensorNode sensor = DeviceList.loadDirectionalSensor(nodeFiles[i].getAbsolutePath());
                        DeviceList.add(sensor);
                        break;
                    }
                    case 6: {
                        DeviceList.add(DeviceList.loadMobile(nodeFiles[i].getAbsolutePath()));
                        break;
                    }
                    case 7: {
                        DeviceList.add(DeviceList.loadWeather(nodeFiles[i].getAbsolutePath()));
                        break;
                    }
                    case 13: {
                        DeviceList.add(DeviceList.loadIoTNode(nodeFiles[i].getAbsolutePath()));
                    }
                }
                int v = Integer.valueOf(nodeFiles[i].getName().split("_")[1]);
                if (v > idMax) {
                    idMax = v;
                }
                MapLayer.repaint();
                br.close();
            }
            if (nodeFiles.length != 0) {
                number = idMax + 1;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SensorNode loadSensor(String fileName) {
        MapObject sensor = null;
        try {
            String[] str = null;
            String[] parameters = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "0"};
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_longitude": {
                        parameters[0] = str[1];
                        break;
                    }
                    case "device_latitude": {
                        parameters[1] = str[1];
                        break;
                    }
                    case "device_elevation": {
                        parameters[2] = str[1];
                        break;
                    }
                    case "device_radius": {
                        parameters[3] = str[1];
                        break;
                    }
                    case "device_sensor_unit_radius": {
                        parameters[4] = str[1];
                        break;
                    }
                    case "device_gps_file_name": {
                        parameters[5] = str[1];
                        break;
                    }
                    case "device_script_file_name": {
                        parameters[6] = str[1];
                        break;
                    }
                    case "device_type": {
                        parameters[7] = str[1];
                        break;
                    }
                    case "device_id": {
                        parameters[8] = str[1];
                        break;
                    }
                    case "device_hide": {
                        parameters[9] = str[1];
                        break;
                    }
                    case "device_draw_battery": {
                        parameters[10] = str[1];
                        break;
                    }
                    case "device_pic": {
                        parameters[11] = str[1];
                    }
                }
            }
            sensor = new StdSensorNode(parameters[8], parameters[0], parameters[1], parameters[2], parameters[3], "0", parameters[4], parameters[5], parameters[6], parameters[11]);
            ((Device)sensor).setHide(Integer.parseInt(parameters[9]));
            ((Device)sensor).setDrawBatteryLevel(Boolean.parseBoolean(parameters[10]));
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DeviceList.openRadioModule(Project.getProjectRadioPath() + File.separator + "sensor_" + sensor.getId(), (SensorNode)sensor);
        return sensor;
    }

    public static SensorNode loadDirectionalSensor(String fileName) {
        MapObject sensor = null;
        try {
            String[] str = null;
            String[] parameters = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
            String[] mparameters = new String[]{"", "", "", "", "", "", "", "", "", ""};
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_longitude": {
                        parameters[0] = str[1];
                        break;
                    }
                    case "device_latitude": {
                        parameters[1] = str[1];
                        break;
                    }
                    case "device_elevation": {
                        parameters[2] = str[1];
                        break;
                    }
                    case "device_radius": {
                        parameters[3] = str[1];
                        break;
                    }
                    case "device_sensor_unit_radius": {
                        parameters[4] = str[1];
                        break;
                    }
                    case "device_gps_file_name": {
                        parameters[5] = str[1];
                        break;
                    }
                    case "device_script_file_name": {
                        parameters[6] = str[1];
                        break;
                    }
                    case "device_type": {
                        parameters[7] = str[1];
                        break;
                    }
                    case "device_id": {
                        parameters[8] = str[1];
                        break;
                    }
                    case "device_hide": {
                        parameters[9] = str[1];
                        break;
                    }
                    case "device_draw_battery": {
                        parameters[10] = str[1];
                        break;
                    }
                    case "directional_parameters": {
                        String[] directional = str[1].split(" ");
                        for (int j = 0; j < directional.length; ++j) {
                            mparameters[j] = directional[j];
                        }
                        break;
                    }
                }
            }
            sensor = new DirectionalSensorNode(parameters[8], parameters[0], parameters[1], parameters[2], parameters[3], "0", parameters[4], parameters[5], parameters[6], mparameters[0], mparameters[1], mparameters[2]);
            ((Device)sensor).setHide(Integer.parseInt(parameters[9]));
            ((Device)sensor).setDrawBatteryLevel(Boolean.parseBoolean(parameters[10]));
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DeviceList.openRadioModule(Project.getProjectRadioPath() + File.separator + "directionalsensor_" + sensor.getId(), (SensorNode)sensor);
        return sensor;
    }

    public static IoTNode loadIoTNode(String fileName) {
        MapObject iotNode = null;
        String name = "";
        String mmsi = "";
        String imo = "";
        String shipType = "";
        String timeStamp = "";
        String destination = "";
        String speed = "";
        String course = "";
        try {
            String line;
            String[] str = null;
            String[] parameters = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            br.readLine();
            br.readLine();
            br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_longitude": {
                        parameters[0] = str[1];
                        break;
                    }
                    case "device_latitude": {
                        parameters[1] = str[1];
                        break;
                    }
                    case "device_elevation": {
                        parameters[2] = str[1];
                        break;
                    }
                    case "device_radius": {
                        parameters[3] = str[1];
                        break;
                    }
                    case "device_sensor_unit_radius": {
                        parameters[4] = str[1];
                        break;
                    }
                    case "device_gps_file_name": {
                        parameters[5] = str[1];
                        break;
                    }
                    case "device_script_file_name": {
                        parameters[6] = str[1];
                        break;
                    }
                    case "device_type": {
                        parameters[7] = str[1];
                        break;
                    }
                    case "device_id": {
                        parameters[8] = str[1];
                        break;
                    }
                    case "device_hide": {
                        parameters[9] = str[1];
                        break;
                    }
                    case "device_draw_battery": {
                        parameters[10] = str[1];
                        break;
                    }
                    case "device_pic": {
                        parameters[11] = str[1];
                        break;
                    }
                    case "name": {
                        name = str[1];
                        break;
                    }
                    case "mmsi": {
                        mmsi = str[1];
                        break;
                    }
                    case "imo": {
                        imo = str[1];
                        break;
                    }
                    case "shiptype": {
                        shipType = str[1];
                        break;
                    }
                    case "timestamp": {
                        timeStamp = str[1];
                        break;
                    }
                    case "destination": {
                        destination = str[1];
                        break;
                    }
                    case "speed": {
                        speed = str[1];
                        break;
                    }
                    case "course": {
                        course = str[1];
                    }
                }
            }
            iotNode = new IoTNode(parameters[8], parameters[0], parameters[1], parameters[2], parameters[3], "0", parameters[4], parameters[5], parameters[6]);
            ((Device)iotNode).setHide(Integer.parseInt(parameters[9]));
            ((Device)iotNode).setDrawBatteryLevel(Boolean.parseBoolean(parameters[10]));
            ((Device)iotNode).setPic(Integer.parseInt(parameters[11]));
            ((IoTNodeCom)iotNode).setName(name);
            ((IoTNodeCom)iotNode).setMmsi(mmsi);
            ((IoTNodeCom)iotNode).setImo(imo);
            ((IoTNodeCom)iotNode).setShipType(shipType);
            ((IoTNodeCom)iotNode).setTimeStamp(timeStamp);
            ((IoTNodeCom)iotNode).setDestination(destination);
            ((IoTNodeCom)iotNode).setSpeed(speed);
            ((IoTNodeCom)iotNode).setCourse(course);
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DeviceList.openRadioModule(Project.getProjectRadioPath() + File.separator + "iot_" + iotNode.getId(), (SensorNode)iotNode);
        return iotNode;
    }

    public static SensorNode loadBaseStation(String fileName) {
        MapObject sensor = null;
        try {
            String[] str = null;
            String[] parameters = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_longitude": {
                        parameters[0] = str[1];
                        break;
                    }
                    case "device_latitude": {
                        parameters[1] = str[1];
                        break;
                    }
                    case "device_elevation": {
                        parameters[2] = str[1];
                        break;
                    }
                    case "device_radius": {
                        parameters[3] = str[1];
                        break;
                    }
                    case "device_sensor_unit_radius": {
                        parameters[4] = str[1];
                        break;
                    }
                    case "device_gps_file_name": {
                        parameters[5] = str[1];
                        break;
                    }
                    case "device_script_file_name": {
                        parameters[6] = str[1];
                        break;
                    }
                    case "device_type": {
                        parameters[7] = str[1];
                        break;
                    }
                    case "device_id": {
                        parameters[8] = str[1];
                        break;
                    }
                    case "device_hide": {
                        parameters[9] = str[1];
                    }
                }
            }
            sensor = new BaseStation(parameters[8], parameters[0], parameters[1], parameters[2], parameters[3], "0", parameters[4], parameters[5], parameters[6]);
            ((Device)sensor).setHide(Integer.parseInt(parameters[9]));
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DeviceList.openRadioModule(Project.getProjectRadioPath() + File.separator + "basestation_" + sensor.getId(), (SensorNode)sensor);
        return sensor;
    }

    public static Device loadMobile(String fileName) {
        Mobile device = null;
        try {
            String[] str = null;
            String[] parameters = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_longitude": {
                        parameters[0] = str[1];
                        break;
                    }
                    case "device_latitude": {
                        parameters[1] = str[1];
                        break;
                    }
                    case "device_elevation": {
                        parameters[2] = str[1];
                        break;
                    }
                    case "device_radius": {
                        parameters[3] = str[1];
                        break;
                    }
                    case "device_gps_file_name": {
                        parameters[4] = str[1];
                        break;
                    }
                    case "device_type": {
                        parameters[5] = str[1];
                        break;
                    }
                    case "device_id": {
                        parameters[6] = str[1];
                        break;
                    }
                    case "device_hide": {
                        parameters[7] = str[1];
                    }
                }
            }
            device = new Mobile(parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], Integer.parseInt(parameters[6]));
            device.setHide(Integer.parseInt(parameters[7]));
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return device;
    }

    public static Device loadGas(String fileName) {
        Gas device = null;
        try {
            String[] str = null;
            String[] parameters = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_longitude": {
                        parameters[0] = str[1];
                        break;
                    }
                    case "device_latitude": {
                        parameters[1] = str[1];
                        break;
                    }
                    case "device_elevation": {
                        parameters[2] = str[1];
                        break;
                    }
                    case "device_radius": {
                        parameters[3] = str[1];
                        break;
                    }
                    case "device_id": {
                        parameters[4] = str[1];
                        break;
                    }
                    case "device_gps_file_name": {
                        parameters[5] = str[1];
                        break;
                    }
                    case "device_hide": {
                        parameters[6] = str[1];
                        break;
                    }
                    case "natural_event_file_name": {
                        parameters[7] = str[1];
                    }
                }
            }
            device = new Gas(parameters[0], parameters[1], parameters[2], parameters[3], parameters[5], Integer.parseInt(parameters[4]));
            device.setHide(Integer.parseInt(parameters[6]));
            device.setNatEventFileName(parameters[7]);
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return device;
    }

    public static Device loadWeather(String fileName) {
        Weather device = null;
        try {
            String[] str = null;
            String[] parameters = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_longitude": {
                        parameters[0] = str[1];
                        break;
                    }
                    case "device_latitude": {
                        parameters[1] = str[1];
                        break;
                    }
                    case "device_elevation": {
                        parameters[2] = str[1];
                        break;
                    }
                    case "device_radius": {
                        parameters[3] = str[1];
                        break;
                    }
                    case "device_id": {
                        parameters[4] = str[1];
                        break;
                    }
                    case "device_gps_file_name": {
                        parameters[5] = str[1];
                        break;
                    }
                    case "device_hide": {
                        parameters[6] = str[1];
                        break;
                    }
                    case "natural_event_file_name": {
                        parameters[7] = str[1];
                    }
                }
            }
            device = new Weather(parameters[0], parameters[1], parameters[2], parameters[3], parameters[5], Integer.parseInt(parameters[4]));
            device.setHide(Integer.parseInt(parameters[6]));
            device.setNatEventFileName(parameters[7]);
            weather = device;
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return device;
    }

    public static void open1(String fileName) {
        fileName = Project.projectPath + File.separator + "config/nodes.cfg";
        DeviceList.reset();
        try {
            BufferedReader br = new BufferedReader(new FileReader((String)fileName));
            String[] str = null;
            int idMax = 0;
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                int v;
                str = line.split(" ");
                switch (str.length) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        DeviceList.addNodeByType(str[0], str[1], str[2], str[3], str[4], str[5]);
                        break;
                    }
                    case 7: {
                        DeviceList.addNodeByType(str[0], str[1], str[2], str[3], str[4], str[5], str[6]);
                        break;
                    }
                    case 8: {
                        DeviceList.addNodeByType(str[0], str[1], str[2], str[3], str[4], str[5], str[6], str[7]);
                        break;
                    }
                    case 9: {
                        DeviceList.addNodeByType(str[0], str[1], str[2], str[3], str[4], str[5], str[6], str[7], str[8]);
                        break;
                    }
                    case 10: {
                        DeviceList.addNodeByType(str[0], str[1], str[2], str[3], str[4], str[5], str[6], str[7], str[8], str[8]);
                        break;
                    }
                    case 11: {
                        DeviceList.addNodeByType(str[0], str[1], str[2], str[3], str[4], str[5], str[6], str[7], str[8], str[9], str[10]);
                        break;
                    }
                    case 14: {
                        DeviceList.addNodeByType(str[0], str[1], str[2], str[3], str[4], str[5], str[6], str[7], str[8], str[9], str[10], str[11], str[12], str[13]);
                    }
                }
                if ((v = Integer.valueOf(str[1]).intValue()) <= idMax) continue;
                idMax = v;
            }
            if (str != null) {
                number = idMax + 1;
            }
            br.close();
            MapLayer.repaint();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int sensorListSize() {
        return sensors.size();
    }

    public static int getNumberOfSelectedSensors() {
        int n = 0;
        for (SensorNode sensor : sensors) {
            if (!sensor.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberOfDirectionalSensors() {
        int n = 0;
        for (SensorNode sensor : sensors) {
            if (sensor.getType() != 5) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberOfBaseStations() {
        int n = 0;
        for (SensorNode sensor : sensors) {
            if (sensor.getType() != 4) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberOfMobiles() {
        int n = 0;
        for (Device node : devices) {
            if (node.getType() != 6) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberOfGas() {
        int n = 0;
        for (Device node : devices) {
            if (node.getType() != 2) continue;
            ++n;
        }
        return n;
    }

    public static int deviceListSize() {
        return devices.size();
    }

    public static int getSize() {
        return sensors.size() + devices.size();
    }

    public static int getIoTNodeSize() {
        int n = 0;
        for (SensorNode sensor : sensors) {
            if (sensor.getType() != 13) continue;
            ++n;
        }
        return n;
    }

    public static void addNodeByType(String ... type) {
        int id = Integer.valueOf(type[1]);
        switch (Integer.valueOf(type[0])) {
            case 1: {
                if (type.length == 10) {
                    DeviceList.add(new StdSensorNode(type[1], type[2], type[4], type[3], "0.0", type[5], type[6], type[7], type[8]));
                    break;
                }
                DeviceList.add(new StdSensorNode(type[1], type[2], type[3], type[4], type[5], type[6], type[7], type[8], type[9]));
                break;
            }
            case 2: {
                DeviceList.add(new Gas(type[3], type[4], type[5], type[6], type[7], id));
                break;
            }
            case 4: {
                DeviceList.add(new BaseStation(type[1], type[3], type[4], type[5], type[6], type[7], type[8], type[9], type[10]));
                break;
            }
            case 5: {
                DeviceList.add(new DirectionalSensorNode(type[1], type[2], type[3], type[4], type[5], type[6], type[7], type[8], type[9], type[10], type[11], type[12]));
                break;
            }
            case 6: {
                DeviceList.add(new Mobile(type[3], type[4], type[5], type[6], type[7], id));
            }
        }
    }

    public static void add(SensorNode sensor) {
        sensors.add(sensor);
        if (propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
    }

    public static void add(Device device) {
        devices.add(device);
    }

    public void draw(Graphics g, int type, int aType) {
        int i;
        int i2;
        SensorNode sensor = null;
        for (i2 = 0; i2 < sensors.size(); ++i2) {
            sensor = sensors.get(i2);
            if (sensor.isInside() && sensor.isSelected()) {
                ++MapLayer.numberOfInsideAndSelected;
            }
            if (sensor.isSelected() || sensor.isInside()) {
                MapLayer.mapViewer.setPanEnabled(false);
            }
            sensors.get(i2).drawRadioRange(g);
        }
        for (i2 = 0; i2 < sensors.size(); ++i2) {
            sensors.get(i2).drawSensorUnit(g);
        }
        for (i2 = 0; i2 < sensors.size(); ++i2) {
            sensor = sensors.get(i2);
            sensor.drawMarked(g);
            sensor.draw(g);
        }
        Device device = null;
        for (i = 0; i < devices.size(); ++i) {
            device = devices.get(i);
            if (device.isInside() && device.isSelected()) {
                ++MapLayer.numberOfInsideAndSelected;
            }
            if (device.isSelected() || device.isInside()) {
                MapLayer.mapViewer.setPanEnabled(false);
            }
            device.drawMarked(g);
            device.draw(g);
        }
        for (i = 0; i < sensors.size(); ++i) {
            sensor = sensors.get(i);
            if (!sensor.displayInfos()) continue;
            sensor.drawInfos(g);
        }
        for (i = 0; i < devices.size(); ++i) {
            device = devices.get(i);
            if (!device.displayInfos()) continue;
            device.drawInfos(g);
        }
        for (i = 0; i < sensors.size(); ++i) {
            if (propagationsCalculated) {
                sensors.get(i).drawRadioPropagations(g);
                continue;
            }
            sensors.get(i).drawRadioLinks(g, type);
        }
        for (i = 0; i < sensors.size(); ++i) {
            sensors.get(i).drawRadioLinkArrows(g, aType);
        }
        MultiChannels.drawChannelLinks(g);
    }

    public Device getDevice(int idx) {
        return devices.get(idx);
    }

    public Device getSensor(int idx) {
        return sensors.get(idx);
    }

    public void setDrawLinks(boolean b) {
        drawLinks = b;
    }

    public boolean getDrawLinks() {
        return drawLinks;
    }

    public static void deleteAll() {
        sensors.removeAll(sensors);
        devices.removeAll(devices);
    }

    public static void deleteNodeByName(String name) {
        Iterator<Device> iterator2 = devices.iterator();
        while (iterator2.hasNext()) {
            Device node = iterator2.next();
            System.out.println(node.getName());
            if (!node.getName().equals(name)) continue;
            iterator2.remove();
            node = null;
        }
        Iterator<SensorNode> iterator3 = sensors.iterator();
        while (iterator3.hasNext()) {
            SensorNode sensor = iterator3.next();
            if (!sensor.getName().equals(name)) continue;
            iterator3.remove();
            sensor = null;
        }
    }

    public static void deleteAllDevices() {
        Iterator<Device> iterator2 = devices.iterator();
        while (iterator2.hasNext()) {
            Device node = iterator2.next();
            if (node.getHide() != 0) continue;
            iterator2.remove();
            node = null;
        }
    }

    public static void deleteAllSensors() {
        Iterator<SensorNode> iterator2 = sensors.iterator();
        while (iterator2.hasNext()) {
            SensorNode sensor = iterator2.next();
            if (sensor.getHide() != 0) continue;
            iterator2.remove();
            sensor = null;
        }
    }

    public static void deleteAllNaturalEvents() {
        Iterator<Device> iterator2 = devices.iterator();
        while (iterator2.hasNext()) {
            Device node = iterator2.next();
            if (node.getHide() != 0 || node.getType() != 2) continue;
            iterator2.remove();
            node = null;
        }
    }

    public static void deleteAllBuildings() {
        Iterator iterator2 = BuildingList.buildings.iterator();
        while (iterator2.hasNext()) {
            Building node = (Building)iterator2.next();
            MapLayer.mapViewer.removeMouseListener(node);
            MapLayer.mapViewer.removeKeyListener(node);
            iterator2.remove();
            node = null;
        }
    }

    public static void deleteAllMobiles() {
        Iterator<Device> iterator2 = devices.iterator();
        while (iterator2.hasNext()) {
            Device node = iterator2.next();
            if (node.getType() != 6) continue;
            iterator2.remove();
            node = null;
        }
    }

    public static void deleteSensor(int idx) {
        sensors.remove(idx);
        if (propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
    }

    public static void deleteDevice(int idx) {
        devices.remove(idx);
    }

    public void simulateMobiles() {
        for (Device node : devices) {
            if (node.getType() != 6) continue;
            node.setSelected(true);
            node.start();
        }
    }

    public static StringBuilder displaySensorGraph() {
        return SensorGraph.toSensorGraph(sensors, sensors.size()).displayNames();
    }

    public static StringBuilder displaySensorTargetGraph() {
        return SensorGraph.toSensorTargetGraph(sensors, sensors.size()).displayNames();
    }

    public void selectInsideRectangle(int cadreX1, int cadreY1, int cadreX2, int cadreY2) {
        boolean selection = false;
        for (SensorNode sensorNode : sensors) {
            sensorNode.setSelected(false);
            if (!MapLayer.insideSelection(sensorNode.getLongitude(), sensorNode.getLatitude(), cadreX1, cadreY1, cadreX2, cadreY2)) continue;
            sensorNode.setSelected(true);
            selection = true;
        }
        for (Device device : devices) {
            device.setSelected(false);
            if (!MapLayer.insideSelection(device.getLongitude(), device.getLatitude(), cadreX1, cadreY1, cadreX2, cadreY2)) continue;
            device.setSelected(true);
            selection = true;
        }
        if (selection && CupCarbonApp.cupCarbonController != null) {
            CupCarbonApp.cupCarbonController.updateObjectListView();
            CupCarbonApp.cupCarbonController.getNodeInformations();
            CupCarbonApp.cupCarbonController.getRadioInformations();
            CupCarbonApp.cupCarbonController.updateSelectionInListView();
        }
    }

    public void deleteIfSelected() {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : sensors) {
            if (!sensor.isSelected()) continue;
            CupActionDeleteSensor action = new CupActionDeleteSensor(sensor);
            block.addAction(action);
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            CupActionDeleteDevice action = new CupActionDeleteDevice(device);
            block.addAction(action);
        }
        if (block.size() > 0) {
            CupActionStack.add(block);
            CupActionStack.execute();
        }
        if (propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
    }

    public static void setGpsFileName(String gpsFileName) {
        for (Device device : sensors) {
            if (!device.isSelected()) continue;
            device.setGPSFileName(gpsFileName);
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            device.setGPSFileName(gpsFileName);
        }
        MapLayer.repaint();
    }

    public static void setScriptFileName(String scriptFileName) {
        for (Device device : sensors) {
            if (!device.isSelected()) continue;
            device.setScriptFileName(scriptFileName);
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            device.setScriptFileName(scriptFileName);
        }
        MapLayer.repaint();
    }

    public static void initMarkedEdges() {
        markedEdges = new Vector();
    }

    public static void initAll() {
        propagationsCalculated = false;
        hulls = new LinkedList();
        markedEdges = new Vector();
        WisenSimulation.sTime = 0.0;
        for (SensorNode sensor : sensors) {
            sensor.init();
            sensor.initGeoZoneList();
        }
        for (Device device : devices) {
            device.init();
        }
    }

    public static void initForSimulation() {
        for (SensorNode sensor : sensors) {
            sensor.initForSimulation();
        }
    }

    public static void initAllGeoZones() {
        for (SensorNode device : sensors) {
            device.initGeoZoneList();
        }
        MapLayer.repaint();
    }

    public static void initAlgoSelectedNodes() {
        for (SensorNode sensorNode : sensors) {
            if (!sensorNode.isSelected()) continue;
            sensorNode.setMarked(false);
            sensorNode.setVisited(false);
            sensorNode.setLedColor(0);
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            device.setMarked(false);
            device.setVisited(false);
            device.setLedColor(0);
        }
        MapLayer.repaint();
    }

    public void setSelectionOfAllNodes(boolean selection, int type, boolean addSelect) {
        for (SensorNode sensorNode : sensors) {
            if (!addSelect) {
                sensorNode.setSelected(false);
            }
            if (sensorNode.getType() != type && type != -1) continue;
            sensorNode.setSelected(selection);
        }
        for (Device device : devices) {
            if (!addSelect) {
                device.setSelected(false);
            }
            if (device.getType() != type && type != -1) continue;
            device.setSelected(selection);
        }
        MapLayer.repaint();
    }

    public void setSelectionOfAllMobileNodes(boolean selection, int type, boolean addSelect) {
        for (SensorNode sensorNode : sensors) {
            if (!addSelect) {
                sensorNode.setSelected(false);
            }
            if (sensorNode.getGPSFileName().equals("")) continue;
            sensorNode.setSelected(selection);
        }
        for (Device device : devices) {
            if (!addSelect) {
                device.setSelected(false);
            }
            if (device.getGPSFileName().equals("")) continue;
            device.setSelected(selection);
        }
        MapLayer.repaint();
    }

    public void invertSelection() {
        for (SensorNode sensor : sensors) {
            sensor.invSelection();
        }
        for (Device device : devices) {
            device.invSelection();
        }
        MapLayer.repaint();
    }

    public Point[] getCouple(Device n1, Device n2) {
        int[] coord = MapCalc.geoToPixelMapA(n1.getLongitude(), n1.getLatitude());
        int lx1 = coord[0];
        int ly1 = coord[1];
        coord = MapCalc.geoToPixelMapA(n2.getLongitude(), n2.getLatitude());
        int lx2 = coord[0];
        int ly2 = coord[1];
        Point[] p = new Point[]{new Point(lx1, ly1), new Point(lx2, ly2)};
        return p;
    }

    public static void initIDs() {
        Device.initNumber();
        for (SensorNode sensorNode : sensors) {
            sensorNode.setId(number);
            Device.incNumber();
        }
        for (Device device : devices) {
            device.setId(number);
            Device.incNumber();
        }
        MapLayer.repaint();
    }

    public void loadRoutesFromFiles() {
        for (SensorNode sensorNode : sensors) {
            sensorNode.loadRouteFromFile();
        }
        for (Device device : devices) {
            device.loadRouteFromFile();
        }
    }

    public void simulate() {
        for (Device device : sensors) {
            if (!device.isSelected()) continue;
            device.start();
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            device.start();
        }
    }

    public void simulateAll() {
        for (SensorNode sensorNode : sensors) {
            sensorNode.setSelected(true);
            sensorNode.start();
        }
        for (Device device : devices) {
            device.setSelected(true);
            device.start();
        }
    }

    public void simulateSensors() {
        for (SensorNode node : sensors) {
            node.setSelected(true);
            node.start();
        }
    }

    public static void stopAgentSimulation() {
        for (SensorNode sensorNode : sensors) {
            sensorNode.setSelected(false);
            sensorNode.stopAgentSimulation();
        }
        for (Device device : devices) {
            device.setSelected(false);
            device.stopAgentSimulation();
        }
    }

    public static void addEdge(SensorNode sn1, SensorNode sn2) {
        markedEdges.add(new SNEdge(sn1, sn2));
    }

    public static void edge(SensorNode sn1, SensorNode sn2) {
        DeviceList.addEdge(sn1, sn2);
        MapLayer.repaint();
    }

    public static void removeEdge(SensorNode sn1, SensorNode sn2) {
        for (SNEdge edge : markedEdges) {
            if ((sn1 != edge.getSN1() || sn2 != edge.getSN2()) && (sn1 != edge.getSN2() || sn2 != edge.getSN1())) continue;
            markedEdges.remove(edge);
            return;
        }
    }

    public static void markEdge(SensorNode sn1, SensorNode sn2) {
        markedEdges.add(new SNEdge(sn1, sn2));
        MapLayer.repaint();
    }

    public static void unmarkEdge(SensorNode sn1, SensorNode sn2) {
        for (SNEdge edge : markedEdges) {
            if ((sn1 != edge.getSN1() || sn2 != edge.getSN2()) && (sn1 != edge.getSN2() || sn2 != edge.getSN1())) continue;
            markedEdges.remove(edge);
            MapLayer.repaint();
            return;
        }
    }

    public static void noEdge(SensorNode sn1, SensorNode sn2) {
        DeviceList.removeEdge(sn1, sn2);
        MapLayer.repaint();
    }

    public void drawMarkedEdges(Graphics2D g) {
        if (markedEdges.size() > 0) {
            for (int i = 0; i < markedEdges.size(); ++i) {
                markedEdges.get(i).draw(g);
            }
        }
    }

    public static int getLastHullSize() {
        return hulls.getLast().size();
    }

    public static void initLastHull() {
        hulls.getLast().clear();
    }

    public static void addHull() {
        hulls.add(new LinkedList());
    }

    public static void addToLastHull(Integer d) {
        hulls.getLast().add(d);
    }

    public static LinkedList<Integer> getLastHull() {
        return hulls.getLast();
    }

    public void drawHull(LinkedList<Integer> hull, Graphics2D g) {
        g.setStroke(new BasicStroke(2.0f));
        if (hull.size() > 0) {
            double x = sensors.get(hull.get(0)).getLatitude();
            double y = sensors.get(hull.get(0)).getLongitude();
            int lx1 = 0;
            int ly1 = 0;
            int lx2 = 0;
            int ly2 = 0;
            for (int i = 1; i < hull.size(); ++i) {
                int[] coord = MapCalc.geoToPixelMapA(x, y);
                lx1 = coord[0];
                ly1 = coord[1];
                coord = MapCalc.geoToPixelMapA(sensors.get(hull.get(i)).getLatitude(), sensors.get(hull.get(i)).getLongitude());
                lx2 = coord[0];
                ly2 = coord[1];
                g.setColor(Color.BLUE);
                g.drawLine(lx1, ly1, lx2, ly2);
                x = sensors.get(hull.get(i)).getLatitude();
                y = sensors.get(hull.get(i)).getLongitude();
            }
        }
    }

    public void drawHulls(Graphics2D g) {
        for (LinkedList linkedList : hulls) {
            this.drawHull(linkedList, g);
        }
    }

    public static int getNumberOfSensorsWithoutScript() {
        int n = 0;
        for (SensorNode d : sensors) {
            if (!d.getScriptFileName().equals("")) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberOfSensorsWithScript() {
        int n = 0;
        for (SensorNode d : sensors) {
            if (d.getScriptFileName().equals("")) continue;
            ++n;
        }
        return n;
    }

    public static void selectWitoutScript() {
        for (SensorNode d : sensors) {
            if (!d.getScriptFileName().equals("")) continue;
            d.setSelected(true);
        }
        MapLayer.repaint();
    }

    public static void selectWitoutGps() {
        for (SensorNode d : sensors) {
            if (!d.getGPSFileName().equals("")) continue;
            d.setSelected(true);
        }
        MapLayer.repaint();
    }

    public static void selectMarkedSensors() {
        for (SensorNode d : sensors) {
            if (!d.isMarked()) continue;
            d.setSelected(true);
        }
        MapLayer.repaint();
    }

    public static void selectDeadSensors() {
        for (SensorNode d : sensors) {
            if (!d.isDead()) continue;
            d.setSelected(true);
        }
        MapLayer.repaint();
    }

    public static int getNumberOfMarkedSensors() {
        int n = 0;
        for (SensorNode d : sensors) {
            if (!d.isMarked()) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberOfUnmarkedSensors() {
        int n = 0;
        for (SensorNode d : sensors) {
            if (d.isMarked()) continue;
            ++n;
        }
        return n;
    }

    public static void setId(String id) {
        for (SensorNode sensorNode : sensors) {
            if (!sensorNode.isSelected()) continue;
            sensorNode.setId(Integer.valueOf(id));
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            device.setId(Integer.valueOf(id));
        }
        MapLayer.repaint();
    }

    public static void setLongitude(String value) {
        for (SensorNode d : sensors) {
            if (!d.isSelected()) continue;
            d.setLongitude(Double.valueOf(value));
        }
        MapLayer.repaint();
    }

    public static void setLatitude(String value) {
        for (SensorNode d : sensors) {
            if (!d.isSelected()) continue;
            d.setLatitude(Double.valueOf(value));
        }
        MapLayer.repaint();
    }

    public static void setElevation(String value) {
        for (SensorNode d : sensors) {
            if (!d.isSelected()) continue;
            d.setElevation(Double.valueOf(value));
        }
        MapLayer.repaint();
    }

    public static void setRadius(String value) {
        for (SensorNode sensorNode : sensors) {
            if (!sensorNode.isSelected()) continue;
            sensorNode.setRadius(Double.valueOf(value));
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            device.setRadius(Double.valueOf(value));
        }
        MapLayer.repaint();
    }

    public static void setSensorUnitRadius(String value) {
        for (SensorNode d : sensors) {
            if (!d.isSelected()) continue;
            d.setSensorUnitRadius(Double.valueOf(value));
        }
        MapLayer.repaint();
    }

    public static void setEMax(String value) {
        for (SensorNode d : sensors) {
            if (!d.isSelected()) continue;
            d.getBattery().setEMax(Double.valueOf(value));
        }
        MapLayer.repaint();
    }

    public static void selectById(String id) {
        String[] ids = id.split(" ");
        int k = 0;
        for (SensorNode sensorNode : sensors) {
            sensorNode.setSelected(false);
            if (k >= ids.length || sensorNode.getId() != Integer.valueOf(ids[k]).intValue()) continue;
            sensorNode.setSelected(true);
            ++k;
        }
        k = 0;
        for (Device device : devices) {
            device.setSelected(false);
            if (k >= ids.length || device.getId() != Integer.valueOf(ids[k]).intValue()) continue;
            device.setSelected(true);
            ++k;
        }
        MapLayer.repaint();
    }

    public static void selectByMy(String my) {
        String[] mys = my.split(" ");
        for (SensorNode d : sensors) {
            d.setSelected(false);
            for (int k = 0; k < mys.length; ++k) {
                if (d.getCurrentRadioModule().getMy() != Integer.valueOf(mys[k]).intValue()) continue;
                d.setSelected(true);
            }
        }
        MapLayer.repaint();
    }

    public static void selectByLed(String led) {
        String[] leds = led.split(" ");
        for (SensorNode d : sensors) {
            d.setSelected(false);
            for (int k = 0; k < leds.length; ++k) {
                if (d.getLedColor() != Integer.valueOf(leds[k]).intValue()) continue;
                d.setSelected(true);
            }
        }
        MapLayer.repaint();
    }

    public static void selectOneFromSelected() {
        for (SensorNode sensorNode : sensors) {
            if (!sensorNode.isSelected()) continue;
            DeviceList.deselectAll();
            sensorNode.setSelected(true);
            return;
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            DeviceList.deselectAll();
            device.setSelected(true);
            return;
        }
    }

    public static void deselectAll() {
        for (SensorNode sensorNode : sensors) {
            sensorNode.setSelected(false);
        }
        for (Device device : devices) {
            device.setSelected(false);
        }
    }

    public static void deselectAllObjects() {
        for (SensorNode sensorNode : sensors) {
            sensorNode.setSelected(false);
        }
        for (Device device : devices) {
            if (device.getType() == 2) continue;
            device.setSelected(false);
        }
    }

    public static void deselectAllEvents() {
        for (Device d : devices) {
            if (d.getType() != 2) continue;
            d.setSelected(false);
        }
    }

    public static void calculatePropagations() {
        propagationsCalculated = true;
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (SensorNode device : sensors) {
                        device.calculatePropagations();
                        MapLayer.repaint();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void calculatePropagations_vt() {
        propagationsCalculated = true;
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (SensorNode device : sensors) {
                        device.calculatePropagations();
                        MapLayer.repaint();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void resetPropagations() {
        propagationsCalculated = false;
        for (SensorNode device : sensors) {
            device.resetPropagations();
        }
    }

    public static void setUartDataRate(String selectedItem) {
        for (SensorNode device : sensors) {
            if (!device.isSelected()) continue;
            if (selectedItem.equals("-")) {
                device.setUartDataRate(Long.MAX_VALUE);
                continue;
            }
            device.setUartDataRate(Long.parseLong(selectedItem));
        }
        MapLayer.repaint();
    }

    public static void setSigmaOfDriftTime(double drift) {
        for (SensorNode device : sensors) {
            if (!device.isSelected()) continue;
            device.setSigmaOfDriftTime(drift);
        }
    }

    public static void openRadioModule(String fileName, SensorNode sensor) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String name = "";
            String str = null;
            String line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                String std;
                str = line.split(":")[0];
                if (str.equals("current_radio_name")) {
                    name = line.split(":")[1];
                    line = br.readLine();
                    str = line.split(":")[0];
                    if (str.equals("radio_standard")) {
                        std = line.split(":")[1];
                        sensor.addRadioModule(name, std);
                        sensor.selectCurrentRadioModule(name);
                    }
                }
                if (str.equals("radio_name")) {
                    name = line.split(":")[1];
                    line = br.readLine();
                    str = line.split(":")[0];
                    if (!str.equals("radio_standard")) continue;
                    std = line.split(":")[1];
                    sensor.addRadioModule(name, std);
                    continue;
                }
                switch (str) {
                    case "radio_my": {
                        sensor.getRadioModuleByName(name).setMy(Integer.parseInt(line.split(":")[1]));
                        break;
                    }
                    case "radio_channel": {
                        sensor.getRadioModuleByName(name).setCh(Integer.parseInt(line.split(":")[1]));
                        break;
                    }
                    case "radio_network_id": {
                        sensor.getRadioModuleByName(name).setNId(Integer.parseInt(line.split(":")[1]));
                        break;
                    }
                    case "radio_radius": {
                        sensor.getRadioModuleByName(name).setRadioRangeRadius(Double.parseDouble(line.split(":")[1]));
                        break;
                    }
                    case "radio_etx": {
                        sensor.getRadioModuleByName(name).setETx(Double.parseDouble(line.split(":")[1]));
                        break;
                    }
                    case "radio_erx": {
                        sensor.getRadioModuleByName(name).setERx(Double.parseDouble(line.split(":")[1]));
                        break;
                    }
                    case "radio_esleep": {
                        sensor.getRadioModuleByName(name).setESleep(Double.parseDouble(line.split(":")[1]));
                        break;
                    }
                    case "radio_elisten": {
                        sensor.getRadioModuleByName(name).setEListen(Double.parseDouble(line.split(":")[1]));
                        break;
                    }
                    case "radio_data_rate": {
                        sensor.getRadioModuleByName(name).setRadioDataRate(Integer.parseInt(line.split(":")[1]));
                        break;
                    }
                    case "spreading_factor": {
                        sensor.getRadioModuleByName(name).setSpreadingFactor(Integer.parseInt(line.split(":")[1]));
                        break;
                    }
                    case "code_rate": {
                        sensor.getRadioModuleByName(name).setCodeRate(Integer.parseInt(line.split(":")[1]));
                        break;
                    }
                    case "conso_tx_model": {
                        sensor.getRadioModuleByName(name).setRadioConsoTxModel(line.split(":")[1]);
                        break;
                    }
                    case "conso_rx_model": {
                        sensor.getRadioModuleByName(name).setRadioConsoRxModel(line.split(":")[1]);
                    }
                }
            }
            br.close();
            MapLayer.repaint();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getNumberOfSelectedObjects() {
        int n = 0;
        for (SensorNode sensorNode : sensors) {
            if (!sensorNode.isSelected()) continue;
            ++n;
        }
        for (Device device : devices) {
            if (!device.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberOfInside() {
        int n = 0;
        for (SensorNode sensorNode : sensors) {
            if (!sensorNode.isInside()) continue;
            ++n;
        }
        for (Device device : devices) {
            if (!device.isInside()) continue;
            ++n;
        }
        return n;
    }

    public static void delete(SensorNode sensor) {
        sensors.remove(sensor);
        if (propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
    }

    public static void delete(Device device) {
        if (device.getClass().equals(Weather.class)) {
            weather = null;
        }
        devices.remove(device);
        if (propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
    }

    public static void addRandomSensors(int n, int hide) {
        CupActionBlock block = new CupActionBlock();
        if (MarkerList.markers.size() == 2) {
            Marker marker1 = MarkerList.markers.get(0);
            Marker marker2 = MarkerList.markers.get(1);
            double m1x = marker1.getLongitude();
            double m1y = marker1.getLatitude();
            double m2x = marker2.getLongitude();
            double m2y = marker2.getLatitude();
            int i = 0;
            while (i < n) {
                double r1 = Math.random();
                double r2 = Math.random();
                double x = (m2x - m1x) * r1 + m1x;
                double y = (m2y - m1y) * r2 + m1y;
                double magnetic_step = 2.27984E-4;
                double delta = 0.0;
                if (MapLayer.magnetic) {
                    x = x - x % magnetic_step - delta % magnetic_step;
                    y = y - y % magnetic_step - delta % magnetic_step;
                }
                boolean ex = false;
                for (Building b : BuildingList.buildings) {
                    if (!b.inside(y, x) || b.isHide()) continue;
                    ex = true;
                    break;
                }
                if (ex) continue;
                ++i;
                StdSensorNode sensor = new StdSensorNode(x, y, 0.0, 0.0, 100.0, 20.0, -1);
                sensor.setHide(hide);
                CupActionAddSensor action = new CupActionAddSensor(sensor);
                block.addAction(action);
            }
            if (block.size() > 0) {
                CupActionStack.add(block);
                CupActionStack.execute();
                if (propagationsCalculated && NetworkParameters.drawRadioLinks) {
                    DeviceList.calculatePropagations();
                }
            }
            MapLayer.repaint();
        }
    }

    public static void addRandomSensors2(int n, int hide) {
        CupActionBlock block = new CupActionBlock();
        if (MarkerList.markers.size() == 2) {
            Marker marker1 = MarkerList.markers.get(0);
            Marker marker2 = MarkerList.markers.get(1);
            double m1x = marker1.getLongitude();
            double m1y = marker1.getLatitude();
            double m2x = marker2.getLongitude();
            double m2y = marker2.getLatitude();
            for (int i = 0; i < n; ++i) {
                double r1 = Math.random();
                double r2 = Math.random();
                double x = (m2x - m1x) * r1 + m1x;
                double y = (m2y - m1y) * r2 + m1y;
                double magnetic_step = 2.27984E-4;
                double delta = 0.0;
                if (MapLayer.magnetic) {
                    x = x - x % magnetic_step - delta % magnetic_step;
                    y = y - y % magnetic_step - delta % magnetic_step;
                }
                StdSensorNode sensor = new StdSensorNode(x, y, 0.0, 0.0, 100.0, 20.0, -1);
                sensor.setHide(hide);
                CupActionAddSensor action = new CupActionAddSensor(sensor);
                block.addAction(action);
            }
            if (block.size() > 0) {
                CupActionStack.add(block);
                CupActionStack.execute();
                if (propagationsCalculated && NetworkParameters.drawRadioLinks) {
                    DeviceList.calculatePropagations();
                }
            }
            MapLayer.repaint();
        }
    }

    public static IoTNode getSelectedIoTNode() {
        for (SensorNode sensor : sensors) {
            if (sensor.getType() != 13 || !sensor.isSelected()) continue;
            return (IoTNode)sensor;
        }
        return null;
    }
}

