/*
 * Decompiled with CFR 0.152.
 */
package device;

import battery.Battery;
import buildings.BuildingList;
import device.DeviceList;
import device.SensorNode;
import java.awt.Graphics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import project.Project;
import sensorunit.DirectionalSensorUnit;
import sensorunit.SensorUnit;
import utilities.MapCalc;

public class DirectionalSensorNode
extends SensorNode {
    public DirectionalSensorNode() {
        this.sensorUnit = new DirectionalSensorUnit(this.longitude, this.latitude, this.elevation, this);
    }

    public DirectionalSensorNode(double x, double y, double z, double radius, double radioRadius, int id) {
        super(x, y, z, radius, radioRadius, id);
        this.sensorUnit = new DirectionalSensorUnit(this.longitude, this.latitude, this.elevation, this);
    }

    public DirectionalSensorNode(double x, double y, double z, double radius, double radioRadius, double suRadius, int id, double deg, double dec, int n) {
        super(x, y, z, radius, radioRadius, id);
        this.sensorUnit = new DirectionalSensorUnit(this.longitude, this.latitude, this.elevation, suRadius, deg, dec, n, this);
    }

    public DirectionalSensorNode(double x, double y, double z, double radius, double radioRadius, double suRadius, String[][] sb, int id, double deg, double dec, int n) {
        this(x, y, z, radius, radioRadius, suRadius, id, deg, dec, n);
        this.setInfos(sb);
        this.initBuffer();
    }

    public DirectionalSensorNode(String id, String x, String y, String z, String radius, String radioRadius, String suRadius, String gpsFileName, String scriptFileName, String degS, String decS, String nS) {
        this(x, y, z, radius, radioRadius, suRadius, (int)Integer.valueOf(id), (double)Double.valueOf(degS), (double)Double.valueOf(decS), (int)Integer.valueOf(nS));
        gpsFileName = gpsFileName.equals("#") ? "" : gpsFileName;
        scriptFileName = scriptFileName.equals("#") ? "" : scriptFileName;
        this.setGPSFileName(gpsFileName);
        this.setScriptFileName(scriptFileName);
        this.calculateRadioSpace();
        this.initBuffer();
    }

    public DirectionalSensorNode(String x, String y, String z, String radius, String radioRadius, String suRadius, int id, double deg, double dec, int n) {
        super(Double.valueOf(x), Double.valueOf(y), Double.valueOf(z), Double.valueOf(radius), Double.valueOf(radioRadius), id);
        this.sensorUnit = new DirectionalSensorUnit(this.longitude, this.latitude, this.elevation, Double.valueOf(suRadius), deg, dec, n, this);
    }

    @Override
    public void drawSensorUnit(Graphics g) {
        int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
        int x = coord[0];
        int y = coord[1];
        if (this.hide == 0 || this.hide == 4) {
            this.sensorUnit.setPosition(x, y);
            this.sensorUnit.draw(g, 0, this.isSensorDetecting(), this.detectBuildings());
        }
        if (this.hide == 3) {
            this.sensorUnit.setPosition(x, y);
            this.sensorUnit.draw(g, 1, this.isSensorDetecting(), this.detectBuildings());
        }
    }

    @Override
    public SensorNode clone() throws CloneNotSupportedException {
        SensorNode newSensor = (SensorNode)super.clone();
        SensorUnit newCaptureUnit = this.sensorUnit.clone();
        Battery newBattery = this.battery.clone();
        ((DirectionalSensorNode)newSensor).setSensorUnit(newCaptureUnit);
        newCaptureUnit.setNode(newSensor);
        newSensor.setBattery(newBattery);
        return newSensor;
    }

    public double getSensorUnitCoverage() {
        return ((DirectionalSensorUnit)this.sensorUnit).getCoverage();
    }

    public double getSensorUnitDirection() {
        return ((DirectionalSensorUnit)this.sensorUnit).getDirection();
    }

    public int getSensorUnitN() {
        return ((DirectionalSensorUnit)this.sensorUnit).getN();
    }

    public void setSensorUnitAngle(double angle) {
        ((DirectionalSensorUnit)this.sensorUnit).setCoverage(angle);
    }

    public void setSensorUnitDirection(double direction) {
        ((DirectionalSensorUnit)this.sensorUnit).setDirection(direction);
    }

    @Override
    public void setSensorUnitRadius(double radius) {
        ((DirectionalSensorUnit)this.sensorUnit).setRadius(radius);
    }

    @Override
    public String getIdFL() {
        return "MS";
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void initBattery() {
        this.getBattery().init();
    }

    @Override
    public String getParamsStr() {
        return this.getSensorUnitCoverage() + " " + this.getSensorUnitDirection() + " " + this.getSensorUnitN();
    }

    @Override
    public boolean detectBuildings() {
        return BuildingList.intersect(this.sensorUnit.getPoly());
    }

    @Override
    public double getSensorUnitRadius() {
        return this.sensorUnit.getRadius();
    }

    @Override
    public SensorNode createNewWithTheSameType() {
        DirectionalSensorNode n_msn = new DirectionalSensorNode(this.longitude, this.latitude, this.elevation, this.radius, 0.0, DeviceList.number++);
        DirectionalSensorUnit c_msu = (DirectionalSensorUnit)this.getSensorUnit();
        DirectionalSensorUnit n_msu = (DirectionalSensorUnit)n_msn.getSensorUnit();
        n_msu.setDirection(c_msu.getDirection());
        n_msu.setCoverage(c_msu.getCoverage());
        n_msu.setRadius(c_msu.getRadius());
        return n_msn;
    }

    @Override
    public void save(String ref) {
        String fileName = Project.getProjectNodePath();
        try {
            PrintStream fos = null;
            fos = new PrintStream(new FileOutputStream(fileName + File.separator + "directionalsensor_" + ref));
            fos.println("List of parameters");
            fos.println("------------------------------------------");
            fos.println("device_type:" + this.getType());
            fos.println("device_id:" + this.getId());
            fos.println("device_longitude:" + this.getLongitude());
            fos.println("device_latitude:" + this.getLatitude());
            fos.println("device_elevation:" + this.getElevation());
            fos.println("device_radius:" + this.getRadius());
            fos.println("device_hide:" + this.getHide());
            fos.println("device_draw_battery:" + this.getDrawBatteryLevel());
            fos.println("device_sensor_unit_radius:" + this.getSensorUnitRadius());
            if (!this.getGPSFileName().equals("")) {
                fos.println("device_gps_file_name:" + this.getGPSFileName());
            }
            if (!this.getScriptFileName().equals("")) {
                fos.println("device_script_file_name:" + this.getScriptFileName());
            }
            if (this.getType() == 5) {
                fos.println("directional_parameters:" + this.getParamsStr());
            }
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.saveRadioModule(Project.getProjectRadioPath() + File.separator + "directionalsensor_" + ref);
    }

    @Override
    public double getNextValueTime() {
        return Double.MAX_VALUE;
    }

    @Override
    public void generateNextValue() {
    }

    @Override
    public String startingName() {
        return null;
    }
}

