/*
 * Decompiled with CFR 0.152.
 */
package device;

import cupcarbon.CupCarbonApp;
import cupcarbon.CupCarbonIcons;
import device.DeviceList;
import device.IoTNodeCom;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import map.MapLayer;
import project.Project;
import simulation.Executor;
import simulation.IoTSimulation;
import simulation.ProgramToCupCarbonFunction;
import simulation.Simulation;
import simulation.SimulationInputs;
import utilities.MapCalc;
import utilities.UColor;

public class IoTNode
extends IoTNodeCom {
    protected boolean connected = false;
    private BufferedReader in = null;
    private PrintStream out = null;
    private PrintStream ps = null;
    private boolean canMove = true;
    private boolean wait = false;
    private Process process = null;
    private Thread processThread = null;

    public IoTNode(double x, double y, double z, double radius, double radioRadius, double suRadius, int id, int pic) {
        super(x, y, z, radius, radioRadius, suRadius, id);
        this.pic = pic;
        this.initNode();
    }

    public IoTNode(String id, String x, String y, String z, String radius, String radioRadius, String suRadius, String gpsFileName, String scriptFileName) {
        super(id, x, y, z, radius, radioRadius, suRadius, gpsFileName, scriptFileName);
        this.initNode();
    }

    public void initNode() {
        this.hide = 1;
    }

    public void initPipes() {
        try {
            PipedInputStream pr = new PipedInputStream();
            PipedOutputStream pos = new PipedOutputStream(pr);
            this.in = new BufferedReader(new InputStreamReader(pr));
            this.out = new PrintStream(pos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getType() {
        return 13;
    }

    public void location(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        MapLayer.repaint();
    }

    public void location(String location) {
        this.longitude = Double.parseDouble(location.split(";")[2]);
        this.latitude = Double.parseDouble(location.split(";")[1]);
        MapLayer.repaint();
    }

    public void location2(String location) {
        this.longitude = Double.parseDouble(location.split(",")[0]);
        this.latitude = Double.parseDouble(location.split(",")[1]);
        MapLayer.repaint();
    }

    public void cgps(String fileName) {
        try {
            if (!((String)fileName).endsWith(".gps")) {
                fileName = (String)fileName + ".gps";
            }
            this.ps = new PrintStream(new FileOutputStream(Project.getGpsFileFromName((String)fileName)));
            this.ps.println("Route of Node " + this.getId());
            this.ps.println("From place 1");
            this.ps.println("To place 2");
            this.ps.println(false);
            this.ps.println("0");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void location(String location, String fileName) {
        if (!((String)fileName).endsWith(".gps")) {
            fileName = (String)fileName + ".gps";
        }
        this.longitude = Double.parseDouble(location.split(",")[0]);
        this.latitude = Double.parseDouble(location.split(",")[1]);
        MapLayer.repaint();
        this.ps.println("1 " + this.longitude + " " + this.latitude + " 0 4.0");
        this.ps.flush();
    }

    public boolean isCanMove() {
        return this.canMove;
    }

    public void setCanMove(boolean canMove) {
        this.canMove = canMove;
    }

    public void routeWait(String stime) {
        final int time = Integer.parseInt(stime);
        new Thread(new Runnable(){
            final /* synthetic */ IoTNode this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.wait = true;
                try {
                    Thread.sleep(time * 1000);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.this$0.wait = false;
            }
        }).start();
    }

    public void routeStop() {
        this.wait = true;
    }

    public void routeStop(int id) {
        IoTNode iotNode = (IoTNode)DeviceList.getNodeById(id);
        iotNode.routeStop();
    }

    public void routeStop(String id) {
        IoTNode iotNode = (IoTNode)DeviceList.getNodeById(Integer.parseInt(id));
        iotNode.routeStop();
    }

    public void routeGo() {
        this.wait = false;
    }

    public void routeGo(int id) {
        IoTNode iotNode = (IoTNode)DeviceList.getNodeById(id);
        iotNode.routeGo();
    }

    public void runGPS() {
        if (!this.getRoute().isEmpty()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IoTNode.this.fixori();
                    while (Simulation.simulating) {
                        if (IoTNode.this.canMove && !IoTNode.this.wait) {
                            IoTNode.this.moveToNext(true, (int)((double)SimulationInputs.visualDelay * IoTNode.this.speedRatio));
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    IoTNode.this.toOri();
                    MapLayer.repaint();
                }
            }).start();
        }
    }

    public void runIoTScript2() {
        try {
            String line;
            String pythonExec = "/Library/Frameworks/Python.framework/Versions/3.12/bin/python3";
            String scriptPath = "/Users/bounceur/Desktop/python/teleg.py";
            ProcessBuilder builder = new ProcessBuilder(pythonExec, scriptPath);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println("Python output: " + line);
            }
            int exitCode = process.waitFor();
            System.out.println("Exited with code: " + exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void runIoTScript() {
        this.canMove = true;
        this.initPipes();
        this.message = "";
        Object command = "";
        try {
            String fileName = this.getScriptFileName();
            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
            String ext = "";
            if (fileName.lastIndexOf(46) >= 0) {
                ext = fileName.substring(fileName.lastIndexOf(46));
            }
            String file = Project.getProjectScriptPath() + File.separator + fileName;
            System.out.println("File: " + file);
            if (ext.equals(".class")) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
                file = "-cp " + Project.getProjectScriptPath() + " " + fileName;
            }
            if (ext.equals("")) {
                file = Project.getProjectScriptPath() + File.separator + fileName;
            }
            System.out.println("Executor -> Node: " + this.id + " (Started)");
            String executorCommand = Executor.executorList.get(fileType);
            if (executorCommand == null) {
                executorCommand = Executor.executorList.get("other");
            }
            command = ext.equals("") ? file : executorCommand + " " + file;
            System.out.println("Command: " + (String)command);
            String[] command2 = new String[]{executorCommand, file};
            this.process = Runtime.getRuntime().exec(command2);
            IoTSimulation.processes.add(this.process);
            PrintStream output = new PrintStream(this.process.getOutputStream());
            this.processThread = new Thread(() -> {
                String line;
                try {
                    BufferedReader input = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                    while ((line = input.readLine()) != null && Simulation.simulating) {
                        ProgramToCupCarbonFunction.exec(line, this, output);
                    }
                    input.close();
                }
                catch (Exception input) {
                    // empty catch block
                }
                try {
                    BufferedReader inputErr = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                    boolean error = false;
                    while ((line = inputErr.readLine()) != null && Simulation.simulating) {
                        error = true;
                        System.err.println(line);
                        System.err.flush();
                    }
                    inputErr.close();
                    if (error) {
                        CupCarbonApp.cupCarbonController.displayShortErrMessageTh("Program Error!");
                        CupCarbonApp.cupCarbonController.stopIoTSimulation();
                    }
                    int exitCode = this.process.waitFor();
                    System.out.println("exite code " + this.id + " " + exitCode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.processThread.start();
        }
        catch (Exception e) {
            if (((String)command).isEmpty()) {
                System.err.println("Execution command is empty or not correct");
            } else {
                System.err.println("Exec error: " + e.getMessage());
            }
            System.err.println("Node: " + this.id + " -> Undefined or non valid execution command!");
        }
    }

    public void stopIoTScript() {
        this.visible = true;
        this.wait = false;
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.flush();
        this.out.close();
        if (this.process != null) {
            System.out.println("Node " + this.id + " stopped!");
            this.process.destroy();
            this.process.destroyForcibly();
        }
    }

    @Override
    public String startingName() {
        return "iot";
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void drawOvalSelection(int x, int y, int rayon, Graphics2D g) {
    }

    @Override
    public int getTextXPosition() {
        return CupCarbonIcons.iotNodeImage[this.pic].getWidth(null) / 2;
    }

    @Override
    public int getTextYPosition() {
        return CupCarbonIcons.iotNodeImage[this.pic].getHeight(null) / 2;
    }

    @Override
    public int getXBattery() {
        return CupCarbonIcons.iotNodeImage[this.pic].getWidth(null) / 2 + 20;
    }

    @Override
    public int getXBuffer() {
        return CupCarbonIcons.iotNodeImage[this.pic].getWidth(null) / 2 + 30;
    }

    public void addIoTMessage(String message) {
        this.out.println(message);
        this.out.flush();
    }

    public String removeIoTMessage() {
        String s = "";
        try {
            s = this.in.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    @Override
    public int getSelectionRadius1() {
        return CupCarbonIcons.iotNodeImage[this.pic].getWidth(null) / 2;
    }

    @Override
    public int getSelectionRadius2() {
        return CupCarbonIcons.iotNodeImage[this.pic].getHeight(null) / 2;
    }

    @Override
    public void drawTheCenteredOval(Graphics2D g2, int r, int x, int y) {
    }

    @Override
    public void drawTheSelectionWithoutFile(Graphics2D g2, int x, int y) {
        int d = 5;
        if (this.getScriptFileName().equals("")) {
            g2.setColor(UColor.WHITE_LLLTRANSPARENT);
            g2.fillRoundRect(x - this.getSelectionRadius1() - d, y - this.getSelectionRadius2() - d, this.getSelectionRadius1() * 2 + 2 * d, this.getSelectionRadius2() * 2 + 2 * d, 10, 10);
            g2.setColor(Color.GRAY);
            if (this.selected) {
                g2.setColor(Color.RED);
            }
            g2.drawRoundRect(x - this.getSelectionRadius1() - d, y - this.getSelectionRadius2() - d, this.getSelectionRadius1() * 2 + 2 * d, this.getSelectionRadius2() * 2 + 2 * d, 10, 10);
        }
    }

    @Override
    public int getInsideRadius() {
        return 40;
    }

    @Override
    public void drawInfos(Graphics g) {
        super.drawInfos(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(0.6f));
        if (this.displayInfos && this.selected && this.infos != null) {
            g.setFont(new Font("arial", 1, 10));
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int lx1 = coord[0];
            int ly1 = coord[1];
            g.setColor(UColor.WHITE_TRANSPARENT);
            g.fillRect(lx1 + 20, ly1 - 25, 150, 90);
            g.setColor(UColor.BLACK_TRANSPARENT);
            g.drawRect(lx1 + 20, ly1 - 25, 150, 90);
            g.setColor(Color.black);
            g.drawString("Name: " + this.name, lx1 + 30, ly1 - 10);
            g.drawString("mmsi: " + this.mmsi, lx1 + 30, ly1);
            g.drawString("imo: " + this.imo, lx1 + 30, ly1 + 10);
            g.drawString("type: " + this.shipType, lx1 + 30, ly1 + 20);
            g.drawString("TimeStmp: " + this.timeStamp, lx1 + 30, ly1 + 30);
            g.drawString("destination: " + this.destination, lx1 + 30, ly1 + 40);
            g.drawString("speed: " + this.speed, lx1 + 30, ly1 + 50);
            g.drawString("course: " + this.course, lx1 + 30, ly1 + 60);
        }
    }

    @Override
    public void drawTheGpsMark(Graphics2D g, int x, int y) {
    }
}

