/*
 * Decompiled with CFR 0.152.
 */
package device;

import cupcarbon.CupCarbonIcons;
import device.DeviceList;
import device.SensorNode;
import geo_objects.GeoZoneList;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import map.MapLayer;
import markers.MarkerList;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import project.Project;
import visibility.VisibilityZones;

public abstract class MapObject
implements Runnable,
Cloneable {
    protected int id = 0;
    protected String userId = "";
    protected double longitude;
    protected double latitude;
    protected double elevation;
    protected double longitude_ori;
    protected double latitude_ori;
    protected double elevation_ori;
    protected double dLongitude;
    protected double dLatitude;
    protected double dElevation;
    protected double prevLongitude;
    protected double prevLatitude;
    protected double prevElevation;
    protected double radius = 0.0;
    protected double radiusOri = 0.0;
    protected boolean selected = false;
    protected boolean visible = true;
    protected boolean inside = false;
    protected int hide = 0;
    protected int pic = 0;
    protected GeoZoneList geoZoneList = null;
    protected boolean altDown = false;
    protected boolean shiftDown = false;
    protected int lastKeyCode = 0;
    protected int idm = 0;
    protected char key = '\u0000';

    public MapObject(double x, double y, double z, double radius, int id) {
        this.id = id == -1 ? DeviceList.number++ : id;
        this.userId = "_" + id;
        this.longitude = x;
        this.latitude = y;
        this.elevation = z;
        this.radius = radius;
        this.radiusOri = radius;
    }

    public MapObject() {
    }

    public void initSelection() {
        this.selected = false;
    }

    public int getInsideRadius() {
        return 10;
    }

    public void inside(int xs, int ys) {
        Point p = new Point(xs, ys);
        GeoPosition gp = MapLayer.mapViewer.convertPointToGeoPosition(p);
        Point2D p1 = MapLayer.mapViewer.getTileFactory().geoToPixel(gp, MapLayer.mapViewer.getZoom());
        GeoPosition gp2 = new GeoPosition(this.latitude, this.longitude);
        Point2D p2 = MapLayer.mapViewer.getTileFactory().geoToPixel(gp2, MapLayer.mapViewer.getZoom());
        double d1 = p1.getX() - p2.getX();
        double d2 = p1.getY() - p2.getY();
        this.inside = false;
        double v = Math.sqrt(d1 * d1 + d2 * d2);
        if (v < (double)this.getInsideRadius()) {
            this.inside = true;
        }
    }

    public abstract String getIdFL();

    public abstract String getName();

    public abstract int getType();

    public abstract void draw(Graphics var1);

    public double getDLongitude() {
        return this.dLongitude;
    }

    public double getDLatitude() {
        return this.dLatitude;
    }

    public double getDElevation() {
        return this.dElevation;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double x) {
        this.longitude = x;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double y) {
        this.latitude = y;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double getPrevLongitude() {
        return this.prevLongitude;
    }

    public void setPrevLongitude(double x) {
        this.prevLongitude = x;
    }

    public double getPrevLatitude() {
        return this.prevLatitude;
    }

    public void setPrevLatitude(double y) {
        this.prevLatitude = y;
    }

    public double getPrevElevation() {
        return this.prevElevation;
    }

    public void setPrevElevation(double elevation) {
        this.prevElevation = elevation;
    }

    public int getIdm() {
        return this.idm;
    }

    public void setIdm() {
        this.idm = MarkerList.size();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void invSelection() {
        this.selected = !this.selected;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void initDraw(Graphics g) {
    }

    public void calculateDxDy(int evx, int evy) {
        if (MapLayer.magnetic) {
            evx -= evx % MapLayer.magnetic_step;
            evy -= evy % MapLayer.magnetic_step;
        }
        Point p = new Point(evx, evy);
        GeoPosition gp = MapLayer.mapViewer.convertPointToGeoPosition(p);
        double ex = gp.getLongitude();
        double ey = gp.getLatitude();
        this.dLongitude = ex - this.longitude;
        this.dLatitude = ey - this.latitude;
    }

    public void calculateGpsDxDy(double ex, double ey) {
        this.dLongitude = ex - this.longitude;
        this.dLatitude = ey - this.latitude;
    }

    public abstract void initGeoZoneList();

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean isInside() {
        return this.inside;
    }

    public static void listSensorParameters(String fileName) {
        try {
            String[] str = null;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_id": {
                        System.out.println("Device id is: " + str[1]);
                        break;
                    }
                    case "device_longitude": {
                        System.out.println("Device longitude is: " + str[1]);
                        break;
                    }
                    case "device_latitude": {
                        System.out.println("Device latitude is: " + str[1]);
                        break;
                    }
                    case "device_elevation": {
                        System.out.println("Device elevation is: " + str[1]);
                        break;
                    }
                    case "device_radius": {
                        System.out.println("Device radius is: " + str[1]);
                        break;
                    }
                    case "device_sensor_unit_radius": {
                        System.out.println("Device sensor unit radius is: " + str[1]);
                        break;
                    }
                    case "device_gps_file_name": {
                        System.out.println("Device gps file name is: " + str[1]);
                        break;
                    }
                    case "device_script_file_name": {
                        System.out.println("Device script filename is: " + str[1]);
                        break;
                    }
                    case "device_type": {
                        System.out.println("Device type is: " + str[1]);
                        break;
                    }
                    case "device_hide": {
                        System.out.println("Device hide is: " + str[1]);
                        break;
                    }
                    case "device_draw_battery": {
                        System.out.println("Device draw battery is: " + str[1]);
                    }
                }
            }
            br.close();
            System.out.println("------------------------------------");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void listGasParameters(String fileName) {
        try {
            String[] str = null;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_id": {
                        System.out.println("Device id is: " + str[1]);
                        break;
                    }
                    case "device_longitude": {
                        System.out.println("Device longitude is: " + str[1]);
                        break;
                    }
                    case "device_latitude": {
                        System.out.println("Device latitude is: " + str[1]);
                        break;
                    }
                    case "device_elevation": {
                        System.out.println("Device elevation is: " + str[1]);
                        break;
                    }
                    case "device_radius": {
                        System.out.println("Device radius is: " + str[1]);
                        break;
                    }
                    case "device_gps_file_name": {
                        System.out.println("Device gps file name is: " + str[1]);
                        break;
                    }
                    case "device_type": {
                        System.out.println("Device type is: " + str[1]);
                        break;
                    }
                    case "device_hide": {
                        System.out.println("Device hide is: " + str[1]);
                        break;
                    }
                    case "device_draw_battery": {
                        System.out.println("Device draw battery is: " + str[1]);
                    }
                }
            }
            br.close();
            System.out.println("------------------------------------");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void listMobileparameters(String fileName) {
        try {
            String[] str = null;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "device_id": {
                        System.out.println("Device id is: " + str[1]);
                        break;
                    }
                    case "device_longitude": {
                        System.out.println("Device longitude is: " + str[1]);
                        break;
                    }
                    case "device_latitude": {
                        System.out.println("Device latitude is: " + str[1]);
                        break;
                    }
                    case "device_elevation": {
                        System.out.println("Device elevation is: " + str[1]);
                        break;
                    }
                    case "device_radius": {
                        System.out.println("Device radius is: " + str[1]);
                        break;
                    }
                    case "device_gps_file_name": {
                        System.out.println("Device gps file name is: " + str[1]);
                        break;
                    }
                    case "device_type": {
                        System.out.println("Device type is: " + str[1]);
                        break;
                    }
                    case "device_hide": {
                        System.out.println("Device hide is: " + str[1]);
                        break;
                    }
                    case "device_draw_battery": {
                        System.out.println("Device draw battery is: " + str[1]);
                    }
                }
            }
            br.close();
            System.out.println("------------------------------------");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void listRadioModuleParameters(String fileName) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String[] str = null;
            String line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                str = line.split(":");
                switch (str[0]) {
                    case "radio_name": {
                        System.out.println("The Radio name is: " + str[1]);
                        break;
                    }
                    case "current_radio_name": {
                        System.out.println("The Current Radio name is: " + str[1]);
                        break;
                    }
                    case "radio_standard": {
                        System.out.println("The Radio Standard is: " + str[1]);
                        break;
                    }
                    case "radio_my": {
                        System.out.println("The Radio My is: " + str[1]);
                        break;
                    }
                    case "radio_channel": {
                        System.out.println("The Radio Channel is: " + str[1]);
                        break;
                    }
                    case "radio_network_id": {
                        System.out.println("The Radio Network Id is: " + str[1]);
                        break;
                    }
                    case "radio_radius": {
                        System.out.println("The Radio Radius is: " + str[1]);
                        break;
                    }
                    case "radio_etx": {
                        System.out.println("The Radio Etx is: " + str[1]);
                        break;
                    }
                    case "radio_erx": {
                        System.out.println("The Radio Erx is: " + str[1]);
                        break;
                    }
                    case "radio_esleep": {
                        System.out.println("The Radio Energy Sleeping: " + str[1]);
                        break;
                    }
                    case "radio_elisten": {
                        System.out.println("The Radio Elisten is: " + str[1]);
                        break;
                    }
                    case "radio_data_rate": {
                        System.out.println("The Radio data rate is: " + str[1]);
                    }
                }
            }
            br.close();
            System.out.println("------------------------------------");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void listNodesParameters() {
        try {
            File nodeFolder = new File(Project.getProjectNodePath());
            File[] nodeFiles = nodeFolder.listFiles();
            int deviceType = -1;
            for (int i = 0; i < nodeFiles.length; ++i) {
                if (nodeFiles[i].getName().split("_")[0].startsWith(".")) continue;
                BufferedReader br = new BufferedReader(new FileReader(nodeFiles[i]));
                String line = br.readLine();
                line = br.readLine();
                line = br.readLine();
                deviceType = Integer.parseInt(line.split(":")[1]);
                switch (deviceType) {
                    case 1: {
                        MapObject.listSensorParameters(nodeFiles[i].getAbsolutePath());
                        break;
                    }
                    case 2: {
                        MapObject.listGasParameters(nodeFiles[i].getAbsolutePath());
                        break;
                    }
                    case 4: {
                        MapObject.listSensorParameters(nodeFiles[i].getAbsolutePath());
                        break;
                    }
                    case 5: {
                        MapObject.listSensorParameters(nodeFiles[i].getAbsolutePath());
                        break;
                    }
                    case 6: {
                        MapObject.listMobileparameters(nodeFiles[i].getAbsolutePath());
                    }
                }
                br.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void listRadioParameters() {
        File radioFolder = new File(Project.getProjectRadioPath());
        File[] radioFiles = radioFolder.listFiles();
        for (int i = 0; i < radioFiles.length; ++i) {
            if (radioFiles[i].getName().split("_")[0].startsWith(".")) continue;
            MapObject.listRadioModuleParameters(radioFiles[i].getAbsolutePath());
        }
    }

    public static void listMarkerParameters() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(Project.getProjectMarkerPath()));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] str = line.split(" ");
                System.out.println("Marker longitude is: " + str[1] + "Marker latitude is: " + str[2] + "Marker elevation is: " + str[3] + "Device radius is: " + str[4]);
            }
            br.close();
            System.out.println("------------------------------------");
        }
        catch (FileNotFoundException e) {
            System.out.println("No Markers!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void gpsMoveTo(double lo, double la, double el) {
        this.longitude = lo;
        this.latitude = la;
        this.elevation = el;
        if (this.geoZoneList != null && this.geoZoneList.size() > 0 && this.getType() == 1) {
            VisibilityZones vz = new VisibilityZones((SensorNode)this);
            vz.run();
        }
        if (DeviceList.sensors.size() <= 100 && DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
    }

    public void moveTo(int cx, int cy, int z) {
        if (MapLayer.magnetic) {
            cx -= cx % MapLayer.magnetic_step;
            cy -= cy % MapLayer.magnetic_step;
        }
        Point p = new Point(cx, cy);
        GeoPosition gp = MapLayer.mapViewer.convertPointToGeoPosition(p);
        double ex = gp.getLongitude();
        double ey = gp.getLatitude();
        this.setLongitude(ex - this.getDLongitude());
        this.setLatitude(ey - this.getDLatitude());
        if (this.geoZoneList != null && this.geoZoneList.size() > 0 && this.getType() == 1) {
            VisibilityZones vz = new VisibilityZones((SensorNode)this);
            vz.run();
        }
        MapLayer.repaint();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void switchVisible() {
        this.visible = !this.visible;
    }

    public void incHide() {
        if (this.hide++ == 5) {
            this.hide = 0;
        }
    }

    public void incPic() {
        if (this.pic++ == CupCarbonIcons.iotNodeImage.length - 1) {
            this.pic = 0;
        }
    }

    public void decPic() {
        if (this.pic-- == 0) {
            this.pic = CupCarbonIcons.iotNodeImage.length - 1;
        }
    }

    public void incRadius(int v) {
        this.radius += (double)v;
    }

    public void shift(double sLongitude, double sLatitude, double sElevation) {
        this.longitude += sLongitude;
        this.latitude += sLatitude;
        this.elevation += sElevation;
    }

    public void setPic(int pic) {
        this.pic = pic;
    }
}

