/*
 * Decompiled with CFR 0.152.
 */
package device;

import device.MobileGWR;
import java.awt.Color;
import java.awt.Graphics;
import utilities.MapCalc;
import utilities.UColor;

public abstract class MobileWithRadio
extends MobileGWR {
    private static String idFL = "W";

    public MobileWithRadio(double x, double y, double z, double rayon, double radioRadius, int id) {
        this(x, y, z, rayon, radioRadius, "", id);
        this.withRadio = true;
    }

    public MobileWithRadio(double x, double y, double z, double rayon, double radioRadius, String gpsFileName, int id) {
        super(x, y, z, rayon, radioRadius, gpsFileName, id);
    }

    public MobileWithRadio(String x, String y, String z, String rayon, String radioRadius, String gpsFileName, int id) {
        super(Double.valueOf(x), Double.valueOf(y), Double.valueOf(z), Double.valueOf(rayon), Double.valueOf(radioRadius), gpsFileName, id);
    }

    @Override
    public void draw(Graphics g) {
        if (this.visible) {
            this.initDraw(g);
            int[] coord = MapCalc.geoToPixelMapA(this.longitude, this.latitude);
            int x = coord[0];
            int y = coord[1];
            int rayon = MapCalc.radiusInPixels(this.getCurrentRadioModule().getRadioRangeRadius());
            int rayon2 = MapCalc.radiusInPixels(this.radius);
            if (this.inside || this.selected) {
                g.setColor(UColor.BLACK_TRANSPARENT);
                g.drawLine(x - rayon - 3, y - rayon - 3, x - rayon + 2, y - rayon - 3);
                g.drawLine(x - rayon - 3, y - rayon - 3, x - rayon - 3, y - rayon + 2);
                g.drawLine(x - rayon - 3, y + rayon + 3, x - rayon + 2, y + rayon + 3);
                g.drawLine(x - rayon - 3, y + rayon + 3, x - rayon - 3, y + rayon - 2);
                g.drawLine(x + rayon + 3, y - rayon - 3, x + rayon - 2, y - rayon - 3);
                g.drawLine(x + rayon + 3, y - rayon - 3, x + rayon + 3, y - rayon + 2);
                g.drawLine(x + rayon + 3, y + rayon + 3, x + rayon - 2, y + rayon + 3);
                g.drawLine(x + rayon + 3, y + rayon + 3, x + rayon + 3, y + rayon - 2);
            }
            switch (this.hide) {
                case 0: {
                    g.setColor(UColor.BLACK_TTTRANSPARENT);
                    g.fillOval(x - rayon, y - rayon, rayon * 2, rayon * 2);
                    g.fillOval(x - rayon2, y - rayon2, rayon2 * 2, rayon2 * 2);
                }
                case 1: {
                    g.setColor(UColor.WHITE_LTRANSPARENT);
                    g.drawOval(x - rayon, y - rayon, rayon * 2, rayon * 2);
                }
            }
            if (this.selected) {
                g.setColor(Color.gray);
                g.drawOval(x - rayon - 4, y - rayon - 4, (rayon + 4) * 2, (rayon + 4) * 2);
            }
            if (this.displayRadius) {
                this.drawRadius(x, y, rayon, g);
                this.drawRadioRadius(x, y, rayon2, g);
            }
            if (this.underSimulation) {
                g.setColor(UColor.GREEN);
                g.fillOval(x - 3, y - 3, 6, 6);
            } else {
                g.setColor(Color.BLUE);
                g.fillOval(x - 3, y - 3, 6, 6);
            }
            this.drawId(x, y, g);
        }
    }

    @Override
    public String getIdFL() {
        return idFL;
    }

    @Override
    public String getName() {
        return this.getIdFL() + this.id;
    }

    @Override
    public void loadScript() {
    }

    @Override
    public int execute() {
        return 0;
    }

    @Override
    public void initBattery() {
    }

    @Override
    public void initBuffer() {
    }

    @Override
    public void init() {
        super.init();
    }
}

