/*
 * Decompiled with CFR 0.152.
 */
package device;

import battery.Battery;
import cupcarbon.CupCarbonApp;
import cupcarbon.CupCarbonIcons;
import device.Device;
import device.DeviceList;
import device.DeviceWithRadio;
import device.IoTNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import map.MapLayer;
import natural_events.Weather;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import project.Project;
import radio_module.RadioModule;
import senscript.SenScript;
import senscript.SenScriptAddCommand;
import sensorunit.SensorUnit;
import simulation.Simulation;
import simulation.WisenSimulation;
import utilities.MapCalc;
import utilities.UColor;

public abstract class SensorNode
extends DeviceWithRadio {
    protected SensorUnit sensorUnit;
    protected boolean messageLost = false;
    protected boolean comEdgeDrawn = false;
    protected Random rnd = new Random();
    protected double variation = this.rnd.nextGaussian();
    protected int bufferSize = 102400;
    protected int bufferIndex = 0;
    protected byte[] buffer = new byte[this.bufferSize];
    protected boolean bufferReady = false;
    protected double drssi = 0.0;
    boolean animation = false;
    int derr = 0;
    int e = 1;

    public SensorNode() {
        this.addRadioModule("radio1", 1);
        this.currentRadioModule = (RadioModule)this.radioModuleList.get(0);
        this.battery = new Battery(this);
        this.withRadio = true;
        this.withSensor = true;
        this.calculateRadioSpace();
        this.initBuffer();
    }

    public SensorNode(double x, double y, double z, double radius, double radioRadius, int id) {
        super(x, y, z, radius, radioRadius, id);
        this.addRadioModule("radio1", 1);
        this.currentRadioModule = (RadioModule)this.radioModuleList.get(0);
        this.battery = new Battery(this);
        this.withRadio = true;
        this.withSensor = true;
        this.calculateRadioSpace();
        this.initBuffer();
    }

    public SensorNode(double x, double y, double z, double radius, double radioRadius, double suRadius, int id) {
        super(x, y, z, radius, radioRadius, id);
        this.addRadioModule("radio1", 1);
        this.currentRadioModule = (RadioModule)this.radioModuleList.get(0);
        this.battery = new Battery(this);
        this.withRadio = true;
        this.withSensor = true;
        this.calculateRadioSpace();
        this.initBuffer();
    }

    public SensorNode(String x, String y, String z, String radius, String radioRadius, String suRadius, int id) {
        super(Double.valueOf(x), Double.valueOf(y), Double.valueOf(z), Double.valueOf(radius), Double.valueOf(radioRadius), id);
        this.addRadioModule("radio1", 1);
        this.currentRadioModule = (RadioModule)this.radioModuleList.get(0);
        this.battery = new Battery(this);
        this.withRadio = true;
        this.withSensor = true;
        this.calculateRadioSpace();
        this.initBuffer();
    }

    public void addRadioModule(String name, String sStandard) {
        int standard = RadioModule.getStandardByName(sStandard);
        this.addRadioModule(name, standard);
    }

    public void addRadioModule(String name, int standard) {
        for (RadioModule radioModule : this.radioModuleList) {
            if (!radioModule.getName().equals(name) && !radioModule.getName().equals("")) continue;
            return;
        }
        RadioModule radioModule = RadioModule.newRadioModule(this, name, standard);
        this.radioModuleList.add(radioModule);
    }

    public void addRadioModule(RadioModule radioModule) {
        for (RadioModule rm : this.radioModuleList) {
            if (!rm.getName().equals(radioModule.getName()) && !rm.getName().equals("")) continue;
            return;
        }
        this.radioModuleList.add(radioModule);
    }

    public void calculateRadioSpace() {
        if (this.geoZoneList.isEmpty()) {
            this.nPoint = 20;
            if (this.getType() == 13) {
                this.nPoint = 40;
            }
            this.deg = Math.PI * 2 / (double)this.nPoint;
            this.polyX = new int[this.nPoint];
            this.polyY = new int[this.nPoint];
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int x = coord[0];
            int y = coord[1];
            int rayon = MapCalc.radiusInPixels(this.getCurrentRadioRangeRadius() * this.getCurrentRadioModule().getPl() / 100.0);
            double i = 0.0;
            for (int k = 0; k < this.nPoint; ++k) {
                double r2 = (double)rayon * Math.cos(i);
                double r3 = (double)rayon * Math.sin(i);
                this.polyX[k] = (int)((double)x + r2);
                this.polyY[k] = (int)((double)y + r3);
                i += this.deg;
            }
        } else {
            this.nPoint = 0;
            this.polyX = null;
            this.polyY = null;
        }
    }

    public void variateRadius() {
        this.variation = this.rnd.nextGaussian() / 0.2;
    }

    public void drawDetectionLink(Device device, Graphics g) {
        int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
        int lx1 = coord[0];
        int ly1 = coord[1];
        coord = MapCalc.geoToPixelMapA(device.getLatitude(), device.getLongitude());
        int lx2 = coord[0];
        int ly2 = coord[1];
        g.setColor(Color.RED);
        g.drawLine(lx1, ly1, lx2, ly2);
    }

    public void drawRadioRange(Graphics g) {
        if (this.visible) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(0.4f));
            if (this.hide == 0 || this.hide == 5) {
                this.geoZoneList.setSelected(this.selected);
                this.geoZoneList.draw(g2);
            }
            this.initDraw(g2);
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int x = coord[0];
            int y = coord[1];
            int rayon = MapCalc.radiusInPixels(this.getCurrentRadioRangeRadius() * this.getCurrentRadioModule().getPl() / 100.0);
            if (!Simulation.simulating && this.selected) {
                this.drawSelection(x, y, rayon, g2, 8, 6, true);
            }
            this.drawSelection(x, y, rayon, g2, 10, 3, false);
            if (!this.isDead()) {
                this.calculateRadioSpace();
                if ((this.hide == 0 || this.hide == 2 || this.hide == 3) && this.nPoint > 0) {
                    if (this.getType() != 13) {
                        g2.setColor(UColor.BLACK_TTRANSPARENT);
                        if (MapLayer.dark) {
                            g2.setColor(Color.GRAY);
                        }
                        g2.drawPolygon(this.polyX, this.polyY, this.nPoint);
                    } else {
                        g2.setColor(UColor.CYAN_TRANSPARENT);
                        if (this.marked) {
                            g2.setColor(UColor.RED);
                        }
                        g2.setStroke(new BasicStroke(2.0f));
                        g2.drawPolygon(this.polyX, this.polyY, this.nPoint);
                    }
                }
                g2.setColor(UColor.BLUED_TRANSPARENT);
                if (this.hide == 0 || this.hide == 5) {
                    if (this.getType() == 13) {
                        if (this.inside) {
                            g2.setColor(UColor.BLUE_TRANSPARENT);
                        } else {
                            g2.setColor(UColor.BLUE_TTRANSPARENT);
                        }
                        if (this.marked) {
                            g2.setColor(UColor.RED_TRANSPARENT);
                        }
                        if (this.nPoint > 0) {
                            g2.fillPolygon(this.polyX, this.polyY, this.nPoint);
                            g2.fillOval(x - rayon + this.derr, y - rayon + this.derr, (rayon - this.derr) * 2, (rayon - this.derr) * 2);
                            if (!this.animation) {
                                this.animation = true;
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        SensorNode.this.derr = SensorNode.this.random.nextInt(100);
                                        while (true) {
                                            if (Simulation.simulating) {
                                                SensorNode.this.derr += SensorNode.this.e;
                                                if (SensorNode.this.derr > 20) {
                                                    SensorNode.this.e = -1;
                                                }
                                                if (SensorNode.this.derr < 0) {
                                                    SensorNode.this.e = 1;
                                                }
                                            } else {
                                                SensorNode.this.derr = 0;
                                            }
                                            MapLayer.repaint();
                                            try {
                                                Thread.sleep(20L);
                                            }
                                            catch (InterruptedException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                    }
                                }).start();
                            }
                        }
                    } else {
                        if (this.inside) {
                            g2.setColor(this.currentRadioModule.getRadioRangeColor2());
                        } else {
                            g2.setColor(this.currentRadioModule.getRadioRangeColor1());
                        }
                        if (this.nPoint > 0) {
                            g2.fillPolygon(this.polyX, this.polyY, this.nPoint);
                        }
                    }
                }
            }
        }
    }

    public void drawSelection(int x, int y, int rayon, Graphics2D g, int d, int dash, boolean red) {
        if (this.inside || this.selected) {
            g.setColor(Color.LIGHT_GRAY);
            if (this.selected) {
                g.setColor(Color.GRAY);
            }
            if (red) {
                g.setColor(Color.RED);
            }
            int rayon1 = this.getSelectionRadius1();
            int rayon2 = this.getSelectionRadius2();
            if (rayon1 == -1) {
                rayon1 = rayon;
            }
            if (rayon2 == -1) {
                rayon2 = rayon;
            }
            g.drawLine(x - rayon1 - d, y - rayon2 - d, x - rayon1 - d + dash, y - rayon2 - d);
            g.drawLine(x - rayon1 - d, y - rayon2 - d, x - rayon1 - d, y - rayon2 - d + dash);
            g.drawLine(x + rayon1 + d, y + rayon2 + d, x + rayon1 + d - dash, y + rayon2 + d);
            g.drawLine(x + rayon1 + d, y + rayon2 + d, x + rayon1 + d, y + rayon2 + d - dash);
            g.drawLine(x - rayon1 - d, y + rayon2 + d, x - rayon1 - d + dash, y + rayon2 + d);
            g.drawLine(x - rayon1 - d, y + rayon2 + d, x - rayon1 - d, y + rayon2 + d - dash);
            g.drawLine(x + rayon1 + d, y - rayon2 - d, x + rayon1 + d - dash, y - rayon2 - d);
            g.drawLine(x + rayon1 + d, y - rayon2 - d, x + rayon1 + d, y - rayon2 - d + dash);
        }
    }

    public int getSelectionRadius1() {
        return -1;
    }

    public int getSelectionRadius2() {
        return -1;
    }

    public void drawOvalSelection(int x, int y, int rayon, Graphics2D g) {
        if (this.selected) {
            g.setColor(Color.GRAY);
            if (this.nPoint == 0) {
                g.drawOval(x - 2, y - 2, 4, 4);
            } else {
                g.drawOval(x - rayon - 6, y - rayon - 6, (rayon + 6) * 2, (rayon + 6) * 2);
            }
        }
    }

    @Override
    public void draw(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        g.setStroke(new BasicStroke(0.4f));
        int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
        int x = coord[0];
        int y = coord[1];
        int rayon = MapCalc.radiusInPixels(this.currentRadioModule.getRadioRangeRadius());
        int rayon2 = MapCalc.radiusInPixels(this.radius);
        if (this.visible && this instanceof IoTNode) {
            int dx = CupCarbonIcons.iotNodeImage[this.pic].getWidth(null) / 2;
            int dy = CupCarbonIcons.iotNodeImage[this.pic].getHeight(null) / 2;
            if (this.marked) {
                g.drawImage(CupCarbonIcons.iotNodeImageM[this.pic], x - dx, y - dy, null);
            } else {
                g.drawImage(CupCarbonIcons.iotNodeImage[this.pic], x - dx, y - dy, null);
            }
        }
        this.drawOvalSelection(x, y, rayon, g);
        this.drawRadius(x, y, rayon2, g);
        this.drawRadioRadius(x, y, rayon, g);
        this.drawTheCenter(g, x, y);
        if (this.drawBatteryLevel) {
            this.battery.draw(g, x, y, this.getXBattery());
            g.setColor(UColor.WHITE_LTRANSPARENT);
            g.fillRect(x - this.getXBuffer(), y - 25, 6, 50);
            g.setColor(Color.DARK_GRAY);
            g.fillRect(x - this.getXBuffer(), y - (int)((double)this.bufferIndex * 1.0 / (double)this.bufferSize * 100.0 / 2.0) + 25, 6, (int)((double)this.bufferIndex * 1.0 / (double)this.bufferSize * 100.0 / 2.0));
            if (MapLayer.dark) {
                g.setColor(Color.LIGHT_GRAY);
            }
            g.drawRect(x - this.getXBuffer(), y - 25, 6, 50);
            g.drawString("Buffer" + this.id + ": " + this.bufferIndex + "/" + this.bufferSize, x - this.getXBuffer(), y + 45);
        }
        this.drawId(x, y, g);
    }

    public int getXBuffer() {
        return 20;
    }

    public int getXBattery() {
        return 30;
    }

    public void drawTheGpsMark(Graphics2D g, int x, int y) {
        if (!this.getGPSFileName().equals("")) {
            int r = 6;
            g.setColor(Color.ORANGE);
            g.fillOval(x - r, y - r, r * 2, r * 2);
            g.setColor(UColor.BLACK_TTRANSPARENT);
            g.drawOval(x - r, y - r, r * 2, r * 2);
        }
    }

    public void drawTheCenter(Graphics g3, int x, int y) {
        Graphics2D g2 = (Graphics2D)g3;
        g2.setStroke(new BasicStroke(0.6f));
        this.drawTheGpsMark(g2, x, y);
        if (this.underSimulation) {
            g2.setColor(new Color(38, 194, 27));
        } else {
            g2.setColor(UColor.ORANGE);
            if (this.getScript() != null && this.getScript().isWaiting()) {
                g2.setColor(Color.RED);
            }
        }
        if (this.isDead()) {
            g2.setColor(Color.GRAY);
        }
        this.drawTheCenteredOval(g2, 3, x, y);
        this.drawTheSelectionWithoutFile(g2, x, y);
    }

    public void drawTheCenteredOval(Graphics2D g2, int r, int x, int y) {
        if (this.getScriptFileName().equals("")) {
            g2.setColor(Color.LIGHT_GRAY);
        }
        r = 3;
        g2.fillOval(x - r, y - r, r * 2, r * 2);
        g2.setColor(UColor.BLACK_TTRANSPARENT);
        g2.drawOval(x - r, y - r, r * 2, r * 2);
    }

    public void drawTheSelectionWithoutFile(Graphics2D g2, int x, int y) {
    }

    public void setBattery(Battery battery) {
        this.battery = battery;
    }

    @Override
    public String getName() {
        return this.getIdFL() + this.id;
    }

    @Override
    public void loadScript() {
        this.script = new SenScript(this);
        String projectScriptPath = Project.getProjectScriptPath() + File.separator + this.scriptFileName;
        String ext = this.scriptFileName.substring(this.scriptFileName.lastIndexOf(46) + 1);
        if (ext.equals("csc")) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(projectScriptPath));
                String s = "";
                while ((s = br.readLine()) != null) {
                    this.addCommand(s);
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                System.err.println("[CupCarbon ERROR] (S" + this.id + "): the SenScript file " + this.scriptFileName + " does not exist.");
                CupCarbonApp.cupCarbonController.stopSimulation();
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadScript(String fileName) {
        if (!((String)fileName).endsWith(".csc")) {
            fileName = (String)fileName + ".csc";
        }
        this.script = new SenScript(this);
        String projectScriptPath = Project.getProjectScriptPath() + File.separator + (String)fileName;
        try {
            BufferedReader br = new BufferedReader(new FileReader(projectScriptPath));
            String s = "";
            while ((s = br.readLine()) != null) {
                this.addCommand(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadScript2(String fileName, boolean reset) {
        if (!((String)fileName).endsWith(".csc")) {
            fileName = (String)fileName + ".csc";
        }
        if (reset) {
            this.script.init();
        } else {
            this.script.init2();
        }
        String projectScriptPath = Project.getProjectScriptPath() + File.separator + (String)fileName;
        try {
            BufferedReader br = new BufferedReader(new FileReader(projectScriptPath));
            String s = "";
            while ((s = br.readLine()) != null) {
                this.addCommand(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addMessageToBuffer(String message) {
        try {
            for (int i = 0; i < message.length(); ++i) {
                this.buffer[this.bufferIndex] = (byte)message.charAt(i);
                ++this.bufferIndex;
                if (this.bufferIndex < this.bufferSize) continue;
                System.err.println("S" + this.getId() + ": ERROR FULL BUFFER!");
                break;
            }
            this.buffer[this.bufferIndex] = 13;
            ++this.bufferIndex;
        }
        catch (Exception e) {
            System.err.println("S" + this.getId() + " [EMPTY MESSAGE]");
        }
    }

    public String readMessage(String var) {
        int i = 0;
        Object s = "";
        while (this.buffer[i] != 13) {
            s = (String)s + (char)this.buffer[i];
            ++i;
        }
        WisenSimulation.simLog.add("S" + this.getId() + " is reading from its buffer \"" + (String)s + "\" and puts it in " + var);
        this.script.putVariable(var, (String)s);
        int k = 0;
        for (int j = i + 1; j < this.bufferSize; ++j) {
            this.buffer[k] = this.buffer[j];
            ++k;
        }
        this.bufferIndex -= i + 1;
        if (this.bufferIndex < 0) {
            this.bufferIndex = 0;
            this.bufferReady = false;
        }
        return s;
    }

    public int pickMessage(String var) {
        int i = 0;
        Object s = "";
        while (this.buffer[i] != 13) {
            s = (String)s + (char)this.buffer[i];
            ++i;
        }
        WisenSimulation.simLog.add("S" + this.getId() + " pick from its buffer \"" + (String)s + "\" and put it in " + var);
        this.script.putVariable(var, (String)s);
        return i;
    }

    @Override
    public void initBuffer() {
        this.bufferIndex = 0;
        this.bufferReady = false;
        for (int i = 0; i < this.bufferSize; ++i) {
            this.buffer[i] = 13;
        }
    }

    public boolean dataAvailable() {
        this.verifyData();
        return this.bufferReady;
    }

    public void verifyData() {
        this.bufferReady = this.buffer[0] != 13 && this.bufferIndex > 0;
    }

    public int getDataSize() {
        int i = 0;
        while (this.buffer[i] != 13) {
            ++i;
        }
        return i;
    }

    public List<SensorNode> getSensorNodeNeighbors() {
        LinkedList<SensorNode> neighnodes = new LinkedList<SensorNode>();
        for (SensorNode snode : DeviceList.sensors) {
            if (!this.radioDetect(snode) || this == snode || this.isDead() || !this.canCommunicateWith(snode)) continue;
            neighnodes.add(snode);
        }
        return neighnodes;
    }

    public boolean isNeighborOf(SensorNode node) {
        for (SensorNode neighbor : this.getSensorNodeNeighbors()) {
            if (node != neighbor) continue;
            return true;
        }
        return false;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public boolean isRadioDetecting() {
        for (DeviceWithRadio deviceWithRadio : DeviceList.sensors) {
            if (!this.radioDetect(deviceWithRadio) || this == deviceWithRadio) continue;
            return true;
        }
        return false;
    }

    public void addCommand(String instStr) {
        SenScriptAddCommand.addCommand(instStr.trim(), this, this.script);
    }

    public boolean isComEdgeDrawn() {
        return this.comEdgeDrawn;
    }

    public void setComEdgeDrawn(boolean comEdgeDrawn) {
        this.comEdgeDrawn = comEdgeDrawn;
    }

    @Override
    public void initForSimulation() {
        super.initForSimulation();
        this.message = "";
        this.setMarked(false);
        this.setVisited(false);
        this.setLedColor(0);
        this.initBattery();
        this.radioLinkColor = new Color(221, 0, 0, 190);
        this.driftTime = 1.0;
        this.initBuffer();
        this.setDead(false);
        this.loadScript();
        this.getScript().init();
        this.setEvent(0.0);
        this.setEvent2(0.0);
        this.setEvent3(0.0);
        this.setAckReceived(false);
        this.setAckWaiting(false);
        this.setSending(false);
        this.setReceiving(false);
    }

    @Override
    public void init() {
        super.init();
        this.setVisible(true);
        this.setSending(false);
        this.setReceiving(false);
        if (this.getScript() != null) {
            this.getScript().setWaiting(false);
        }
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    @Override
    public int execute() {
        if (this.event == 0.0) {
            boolean cont = true;
            int firstIndex = -1;
            while (cont) {
                if (this.script.getIndex() == firstIndex && !this.script.getCurrent().toString().equals("WAIT")) {
                    System.out.println(this.script.getCurrent().toString());
                    System.err.println("(S" + this.getId() + ") -> No next event -> infinite loop: add delays in your script");
                    return 1;
                }
                if (firstIndex == -1) {
                    firstIndex = this.script.getIndex();
                }
                this.script.executeCommand();
                if (this.script.getEvent() == 0.0) {
                    this.script.next();
                    continue;
                }
                cont = false;
            }
            WisenSimulation.consolPrint(this.event + " : ");
            this.event = this.script.getEvent();
            WisenSimulation.consolPrint(this.event + " | ");
        }
        return 0;
    }

    public String getSensorValues() {
        Object s = "";
        boolean first = true;
        for (Device device : DeviceList.devices) {
            if (device.getClass().equals(Weather.class) || !this.detect(device)) continue;
            if (!first) {
                s = (String)s + "#";
            }
            s = (String)s + device.getId() + "#" + device.getValue();
            first = false;
        }
        s = ((String)s).equals("") ? "X" : "S#" + (String)s;
        return s;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public double[] getIntPosition() {
        double[] position = new double[3];
        int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
        position[0] = coord[0];
        position[1] = coord[1];
        position[2] = 10.0;
        return position;
    }

    public double[] getPosition() {
        double[] position = new double[]{this.latitude, this.longitude, this.elevation};
        return position;
    }

    public void setPosition(double d, double e, double z) {
        this.longitude = d;
        this.latitude = e;
        this.elevation = z;
    }

    public boolean canSee(SensorNode sn) {
        GeoPosition gp1 = new GeoPosition(sn.getLatitude(), sn.getLongitude());
        Point2D p = MapLayer.mapViewer.getTileFactory().geoToPixel(gp1, MapLayer.mapViewer.getZoom());
        return this.geoZoneList.contains((Point)p);
    }

    public boolean isSensorDetecting() {
        for (Device device : DeviceList.devices) {
            if (!this.detect(device) || this == device) continue;
            return true;
        }
        for (Device device : DeviceList.sensors) {
            if (device.getClass().equals(Weather.class) || !this.detect(device) || this == device) continue;
            return true;
        }
        return false;
    }

    public SensorUnit getSensorUnit() {
        return this.sensorUnit;
    }

    public void setSensorUnit(SensorUnit sensorUnit) {
        this.sensorUnit = sensorUnit;
    }

    public boolean detect(Device device) {
        return this.sensorUnit.detect(device);
    }

    public void setSensorUnitRadius(double radius) {
        this.getSensorUnit().setRadius(radius);
    }

    public abstract SensorNode createNewWithTheSameType();

    @Override
    public SensorNode duplicate() {
        this.selected = false;
        SensorNode nSensor = this.createNewWithTheSameType();
        nSensor.setHide(this.hide);
        nSensor.setDrawBatteryLevel(this.drawBatteryLevel);
        nSensor.setSensorUnitRadius(this.sensorUnit.getRadius());
        nSensor.getBattery().setEMax(this.getBattery().getEMax());
        nSensor.setScriptFileName(this.scriptFileName);
        nSensor.setGPSFileName(this.gpsFileName);
        nSensor.setPic(this.pic);
        nSensor.getRadioModuleList().removeAll(nSensor.getRadioModuleList());
        for (RadioModule radioModule : this.radioModuleList) {
            RadioModule nRadioModule = radioModule.duplicate(nSensor);
            nSensor.addRadioModule(nRadioModule);
            if (!radioModule.getName().equals(this.getCurrentRadioModule().getName())) continue;
            nSensor.selectCurrentRadioModule(this.getCurrentRadioModule().getName());
        }
        nSensor.setSelected(true);
        return nSensor;
    }

    @Override
    public SensorNode duplicateWithShift(double sLongitude, double sLatitude, double sElevation) {
        SensorNode nSensor = this.duplicate();
        nSensor.shift(sLongitude, sLatitude, sElevation);
        return nSensor;
    }

    @Override
    public int getStandard() {
        return this.getCurrentRadioModule().getStandard();
    }

    @Override
    public int getNumberOfNeighbors() {
        if (DeviceList.propagationsCalculated) {
            return this.neighbors.size();
        }
        return 0;
    }

    @Override
    public double getESensing() {
        return this.getSensorUnit().getESensing();
    }

    public abstract boolean detectBuildings();

    public abstract String getParamsStr();

    public void setMessageLost(boolean messageLost) {
        this.messageLost = messageLost;
    }

    public boolean getMessageLost() {
        return this.messageLost;
    }

    public Vector<RadioModule> getRadioModuleList() {
        return this.radioModuleList;
    }

    public RadioModule getRadioModuleByName(String name) {
        for (RadioModule radioModule : this.radioModuleList) {
            if (!radioModule.getName().equals(name)) continue;
            return radioModule;
        }
        return null;
    }

    public void saveRadioModule(String fileName) {
        try {
            PrintStream fos = null;
            fos = new PrintStream(new FileOutputStream(fileName));
            fos.println(" List of radio Modules for the Sensor" + this.getId());
            fos.println("------------------------------------------");
            for (RadioModule radioModule : this.getRadioModuleList()) {
                radioModule.save(fos, this.currentRadioModule);
            }
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public double getDrssi() {
        return this.drssi;
    }

    public void setDrssi(double drssi) {
        this.drssi = drssi;
    }

    public GeoPosition getGeoCenter() {
        return new GeoPosition(this.latitude, this.longitude);
    }

    @Override
    public double getSUCoverage() {
        return this.getSensorUnit().getCoverage();
    }

    @Override
    public double getSUDirection() {
        return this.getSensorUnit().getDirection();
    }

    public void runIoTScript() {
    }

    public abstract void drawSensorUnit(Graphics var1);
}

