/*
 * Decompiled with CFR 0.152.
 */
package enegy_conso_model;

import cupcarbon.CupCarbonApp;
import enegy_conso_model.EnergyConsumptionModel;
import enegy_conso_model.EnergyConsumptionToken;
import enegy_conso_model.EnergyConsumptionTokenStack;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class EnergyConsumptionExpression {
    private EnergyConsumptionTokenStack operatorStack = new EnergyConsumptionTokenStack();
    private EnergyConsumptionTokenStack argumentStack = new EnergyConsumptionTokenStack();
    private boolean error = false;

    private void processOperator(EnergyConsumptionToken token) {
        EnergyConsumptionToken arg1 = null;
        EnergyConsumptionToken arg2 = null;
        if (this.argumentStack.isEmpty()) {
            CupCarbonApp.cupCarbonController.displayShortErrMessage("ERROR!");
            System.err.println(">> ERREOR Energy consumption evaluation!");
            System.err.println(">> Type: " + EnergyConsumptionModel.type + " - Sensor: S" + EnergyConsumptionModel.id + " - Radio: " + EnergyConsumptionModel.rn);
            System.err.println(">> Expression error 1.");
            this.error = true;
            return;
        }
        arg2 = this.argumentStack.top();
        this.argumentStack.pop();
        if (this.argumentStack.isEmpty()) {
            CupCarbonApp.cupCarbonController.displayShortErrMessage("ERROR!");
            System.err.println(">> ERREOR Energy consumption evaluation!");
            System.err.println(">> Type: " + EnergyConsumptionModel.type + " - Sensor: S" + EnergyConsumptionModel.id + " - Radio: " + EnergyConsumptionModel.rn);
            System.err.println(">> Expression error 2 (problem in the model!)");
            this.error = true;
            return;
        }
        arg1 = this.argumentStack.top();
        this.argumentStack.pop();
        EnergyConsumptionToken result = token.operation(arg1.getValue(), arg2.getValue());
        this.argumentStack.push(result);
    }

    public String processInput(String expression) {
        expression.replaceAll("\\s+", "");
        ArrayList<EnergyConsumptionToken> tokens = new ArrayList<EnergyConsumptionToken>();
        StringTokenizer st = new StringTokenizer(expression, "()+-*/%^", true);
        Object script = "";
        String currentToken = "";
        boolean operand = false;
        Object operandToken = "";
        while (st.hasMoreTokens()) {
            currentToken = st.nextToken();
            if (currentToken.startsWith("n") || currentToken.startsWith("r") || currentToken.startsWith("t") || currentToken.startsWith("p") || currentToken.startsWith("etx") || currentToken.startsWith("erx")) {
                if (!((String)operandToken).isEmpty() && !((String)operandToken).matches(".*\\d.*")) {
                    operandToken = (String)operandToken + "1";
                    tokens.add(new EnergyConsumptionToken((String)operandToken));
                    tokens.add(new EnergyConsumptionToken("*"));
                    operandToken = "";
                }
                operandToken = (String)operandToken + EnergyConsumptionModel.getVariableValue(currentToken);
                operand = true;
                continue;
            }
            if (currentToken.equals("(")) {
                if (!((String)operandToken).isEmpty() && !((String)operandToken).matches(".*\\d.*")) {
                    operandToken = (String)operandToken + "1";
                    tokens.add(new EnergyConsumptionToken((String)operandToken));
                    tokens.add(new EnergyConsumptionToken("*"));
                }
                tokens.add(new EnergyConsumptionToken(currentToken));
                operandToken = "";
                continue;
            }
            if (operand) {
                if (Character.isDigit(currentToken.charAt(0))) {
                    operandToken = (String)operandToken + currentToken;
                    continue;
                }
                if (currentToken.equals(")")) {
                    if (!((String)operandToken).isEmpty()) {
                        tokens.add(new EnergyConsumptionToken((String)operandToken));
                    }
                    tokens.add(new EnergyConsumptionToken(currentToken));
                    operandToken = "";
                    continue;
                }
                if (!((String)operandToken).isEmpty()) {
                    tokens.add(new EnergyConsumptionToken((String)operandToken));
                }
                tokens.add(new EnergyConsumptionToken(currentToken));
                operandToken = "";
                operand = false;
                continue;
            }
            if (Character.isDigit(currentToken.charAt(0))) {
                operand = true;
            }
            operandToken = (String)operandToken + currentToken;
        }
        if (!((String)operandToken).isEmpty()) {
            tokens.add(new EnergyConsumptionToken((String)operandToken));
        }
        for (int n = 0; n < tokens.size(); ++n) {
            EnergyConsumptionToken toProcess;
            EnergyConsumptionToken nextToken = (EnergyConsumptionToken)tokens.get(n);
            if (nextToken.getType() == 0) {
                this.argumentStack.push(nextToken);
                continue;
            }
            if (nextToken.getType() == 1) {
                if (this.operatorStack.isEmpty() || nextToken.getPrecedence() > this.operatorStack.top().getPrecedence()) {
                    this.operatorStack.push(nextToken);
                    continue;
                }
                while (!this.operatorStack.isEmpty() && nextToken.getPrecedence() <= this.operatorStack.top().getPrecedence()) {
                    toProcess = this.operatorStack.top();
                    this.operatorStack.pop();
                    this.processOperator(toProcess);
                }
                this.operatorStack.push(nextToken);
                continue;
            }
            if (nextToken.getType() == 2) {
                this.operatorStack.push(nextToken);
                continue;
            }
            if (nextToken.getType() != 3) continue;
            while (!this.operatorStack.isEmpty() && this.operatorStack.top().getType() == 1) {
                toProcess = this.operatorStack.top();
                this.operatorStack.pop();
                this.processOperator(toProcess);
            }
            if (!this.operatorStack.isEmpty() && this.operatorStack.top().getType() == 2) {
                this.operatorStack.pop();
                continue;
            }
            CupCarbonApp.cupCarbonController.displayShortErrMessage("ERROR!");
            System.err.println(">> ERREOR Energy consumption evaluation!");
            System.err.println(">> Type: " + EnergyConsumptionModel.type + " - Sensor: S" + EnergyConsumptionModel.id + " - Radio: " + EnergyConsumptionModel.rn);
            System.err.println(">> Error: unbalanced parenthesis.");
            this.error = true;
        }
        while (!this.operatorStack.isEmpty() && this.operatorStack.top().getType() == 1) {
            EnergyConsumptionToken toProcess = this.operatorStack.top();
            this.operatorStack.pop();
            this.processOperator(toProcess);
        }
        if (!this.error) {
            EnergyConsumptionToken result = this.argumentStack.top();
            this.argumentStack.pop();
            if (!this.operatorStack.isEmpty() || !this.argumentStack.isEmpty()) {
                CupCarbonApp.cupCarbonController.displayShortErrMessage("ERROR!");
                System.err.println(">> ERREOR Energy consumption evaluation!");
                System.err.println(">> Type: " + EnergyConsumptionModel.type + " - Sensor: S" + EnergyConsumptionModel.id + " - Radio: " + EnergyConsumptionModel.rn);
                System.err.println(">> Expression error 3");
                return ">> Expression error 3";
            }
            script = " " + result.getValue();
            return script;
        }
        CupCarbonApp.cupCarbonController.displayShortErrMessage("ERROR!");
        System.err.println(">> ERREOR Energy consumption evaluation!");
        System.err.println(">> Type: " + EnergyConsumptionModel.type + " - Sensor: S" + EnergyConsumptionModel.id + " - Radio: " + EnergyConsumptionModel.rn);
        System.err.println(">> May be a variable in the energy consumption model does not exist!");
        return "Expression error 4";
    }
}

