/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.util.Iterator;
import java.util.LinkedList;

public class Vertex {
    private String name = "";
    private int number;
    private LinkedList<Integer> neighbors = new LinkedList();
    private boolean selected = false;

    public Vertex(int number, String name) {
        this.number = number;
        this.name = name;
    }

    public void addNeighbor(int s) {
        this.neighbors.addFirst(s);
    }

    public LinkedList<Integer> getNeighbors() {
        return this.neighbors;
    }

    public void display() {
        System.out.print(this.getNumber() + " : ");
        Iterator iterator2 = this.neighbors.iterator();
        while (iterator2.hasNext()) {
            int s = (Integer)iterator2.next();
            System.out.print(s + " ");
        }
    }

    public StringBuilder displayNames() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNumber() + ": ");
        System.out.print(this.getNumber() + ": ");
        Iterator iterator2 = this.neighbors.iterator();
        while (iterator2.hasNext()) {
            int s = (Integer)iterator2.next();
            sb.append(s + " ");
            System.out.print(s + " ");
        }
        return sb;
    }

    public int getNbNeignbors() {
        return this.neighbors.size();
    }

    public boolean hasNeighbor(int s) {
        for (int i = 0; i < this.neighbors.size(); ++i) {
            if (this.getNeighbors().get(i) != s) continue;
            return true;
        }
        return false;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void remove(int i) {
        this.neighbors.remove(this.neighbors.indexOf(i));
    }

    public void setSelection(boolean b) {
        this.selected = b;
    }

    public boolean getSelection() {
        return this.selected;
    }

    public int size() {
        return this.neighbors.size();
    }
}

