/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Attribute;
import nu.xom.CDATASection;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XOMHandler;
import org.xml.sax.Attributes;

class NonVerifyingHandler
extends XOMHandler {
    NonVerifyingHandler(NodeFactory factory2) {
        super(factory2);
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        String qName;
        int i;
        String baseURI;
        this.flushText();
        Element element = Element.build(qualifiedName, namespaceURI, localName);
        if (this.parent == this.document) {
            this.document.setRootElement(element);
            this.inProlog = false;
        }
        this.current = element;
        this.parents.add(element);
        if (this.parent != this.document) {
            this.parent.fastInsertChild(element, this.parent.getChildCount());
        }
        if ((baseURI = this.locator.getSystemId()) != null && !baseURI.equals(this.documentBaseURI)) {
            element.setActualBaseURI(baseURI);
        }
        int length = attributes.getLength();
        for (i = 0; i < length; ++i) {
            qName = attributes.getQName(i);
            if (qName.startsWith("xmlns:") || qName.equals("xmlns")) continue;
            String namespace = attributes.getURI(i);
            String value = attributes.getValue(i);
            Attribute attribute = Attribute.build(qName, namespace, value, NonVerifyingHandler.convertStringToType(attributes.getType(i)), attributes.getLocalName(i));
            element.fastAddAttribute(attribute);
        }
        for (i = 0; i < length; ++i) {
            String namespacePrefix;
            String currentValue;
            String namespaceName;
            qName = attributes.getQName(i);
            if (qName.startsWith("xmlns:")) {
                namespaceName = attributes.getValue(i);
                if (namespaceName.equals(currentValue = element.getNamespaceURI(namespacePrefix = qName.substring(6)))) continue;
                element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                continue;
            }
            if (!qName.equals("xmlns") || (namespaceName = attributes.getValue(i)).equals(currentValue = element.getNamespaceURI(namespacePrefix = ""))) continue;
            element.addNamespaceDeclaration(namespacePrefix, namespaceName);
        }
        this.parent = element;
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        this.current = (ParentNode)this.parents.remove(this.parents.size() - 1);
        this.flushText();
        this.parent = this.current.getParent();
        if (this.parent.isDocument()) {
            Document doc = (Document)this.parent;
            doc.setRootElement((Element)this.current);
        }
    }

    protected void flushText() {
        if (this.buffer != null) {
            this.textString = this.buffer.toString();
            this.buffer = null;
        }
        if (this.textString != null) {
            Text result = !this.inCDATA ? Text.build(this.textString) : CDATASection.build(this.textString);
            this.parent.fastInsertChild(result, this.parent.getChildCount());
            this.textString = null;
        }
        this.inCDATA = false;
        this.finishedCDATA = false;
    }

    public void processingInstruction(String target, String data) {
        if (!this.inDTD) {
            this.flushText();
        } else if (!this.inInternalSubset()) {
            return;
        }
        ProcessingInstruction result = ProcessingInstruction.build(target, data);
        if (!this.inDTD) {
            if (this.inProlog) {
                this.parent.fastInsertChild(result, this.position);
                ++this.position;
            } else {
                this.parent.fastInsertChild(result, this.parent.getChildCount());
            }
        } else {
            this.internalDTDSubset.append("  ");
            this.internalDTDSubset.append(result.toXML());
            this.internalDTDSubset.append("\n");
        }
    }

    public void startDTD(String rootName, String publicID, String systemID) {
        this.inDTD = true;
        DocType doctype = DocType.build(rootName, publicID, systemID);
        this.document.fastInsertChild(doctype, this.position);
        ++this.position;
        this.internalDTDSubset = new StringBuffer();
        this.doctype = doctype;
    }

    public void comment(char[] text, int start, int length) {
        if (!this.inDTD) {
            this.flushText();
        } else if (!this.inInternalSubset()) {
            return;
        }
        Comment result = Comment.build(new String(text, start, length));
        if (!this.inDTD) {
            if (this.inProlog) {
                this.parent.insertChild(result, this.position);
                ++this.position;
            } else {
                this.parent.fastInsertChild(result, this.parent.getChildCount());
            }
        } else {
            this.internalDTDSubset.append("  ");
            this.internalDTDSubset.append(result.toXML());
            this.internalDTDSubset.append("\n");
        }
    }
}

