/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XPathContext;
import nu.xom.canonical.CanonicalizationException;
import org.xml.sax.helpers.NamespaceSupport;

public class Canonicalizer {
    private boolean withComments;
    private boolean exclusive = false;
    private CanonicalXMLSerializer serializer;
    private List inclusiveNamespacePrefixes = new ArrayList();
    private static Comparator comparator = new AttributeComparator();
    public static final String CANONICAL_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String CANONICAL_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCLUSIVE_XML_CANONICALIZATION = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    public Canonicalizer(OutputStream out) {
        this(out, true, false);
    }

    public Canonicalizer(OutputStream out, boolean withComments) {
        this(out, withComments, false);
    }

    private Canonicalizer(OutputStream out, boolean withComments, boolean exclusive) {
        this.serializer = new CanonicalXMLSerializer(out);
        this.serializer.setLineSeparator("\n");
        this.withComments = withComments;
        this.exclusive = exclusive;
    }

    public Canonicalizer(OutputStream out, String algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("Null algorithm");
        }
        this.serializer = new CanonicalXMLSerializer(out);
        this.serializer.setLineSeparator("\n");
        if (algorithm.equals(CANONICAL_XML)) {
            this.withComments = false;
            this.exclusive = false;
        } else if (algorithm.equals(CANONICAL_XML_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = false;
        } else if (algorithm.equals(EXCLUSIVE_XML_CANONICALIZATION)) {
            this.withComments = false;
            this.exclusive = true;
        } else if (algorithm.equals(EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = true;
        } else {
            throw new CanonicalizationException("Unsupported canonicalization algorithm: " + algorithm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Node node) throws IOException {
        if (node instanceof Element) {
            Document doc = node.getDocument();
            Element pseudoRoot = null;
            if (doc == null) {
                pseudoRoot = new Element("pseudo");
                doc = new Document(pseudoRoot);
                ParentNode root = (ParentNode)node;
                while (root.getParent() != null) {
                    root = root.getParent();
                }
                pseudoRoot.appendChild(root);
            }
            try {
                this.write(node.query(".//. | .//@* | .//namespace::*"));
            }
            finally {
                if (pseudoRoot != null) {
                    pseudoRoot.removeChild(0);
                }
            }
        } else {
            this.serializer.nodes = null;
            this.serializer.write(node);
        }
        this.serializer.flush();
    }

    public final void write(Nodes documentSubset) throws IOException {
        if (documentSubset.size() > 0) {
            Document doc = documentSubset.get(0).getDocument();
            if (doc == null) {
                throw new CanonicalizationException("Canonicalization is not defined for detached nodes");
            }
            Nodes result = this.sort(documentSubset);
            this.serializer.nodes = result;
            this.serializer.write(doc);
            this.serializer.flush();
        }
    }

    public final void setInclusiveNamespacePrefixList(String inclusiveNamespacePrefixes) throws IOException {
        this.inclusiveNamespacePrefixes.clear();
        if (this.exclusive && inclusiveNamespacePrefixes != null) {
            StringTokenizer tokenizer = new StringTokenizer(inclusiveNamespacePrefixes, " \t\r\n", false);
            while (tokenizer.hasMoreTokens()) {
                this.inclusiveNamespacePrefixes.add(tokenizer.nextToken());
            }
        }
    }

    private Nodes sort(Nodes in) {
        Document root = in.get(0).getDocument();
        if (in.size() > 1) {
            Nodes out = new Nodes();
            ArrayList<Node> list = new ArrayList<Node>(in.size());
            ArrayList<Node> namespaces = new ArrayList<Node>();
            for (int i = 0; i < in.size(); ++i) {
                Node node = in.get(i);
                list.add(node);
                if (!(node instanceof Namespace)) continue;
                namespaces.add(node);
            }
            Canonicalizer.sort(list, namespaces, out, root);
            if (!list.isEmpty()) {
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Node next = (Node)iterator2.next();
                    if (root == next.getDocument()) continue;
                    throw new CanonicalizationException("Cannot canonicalize subsets that contain nodes from more than one document");
                }
            }
            return out;
        }
        return new Nodes(in.get(0));
    }

    private static void sort(List in, List namespaces, Nodes out, ParentNode parent) {
        if (in.isEmpty()) {
            return;
        }
        if (in.contains(parent)) {
            out.append(parent);
            in.remove(parent);
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Node child = parent.getChild(i);
            if (child instanceof Element) {
                Element element = (Element)child;
                if (in.contains(element)) {
                    out.append(element);
                    in.remove(element);
                }
                if (!namespaces.isEmpty()) {
                    Iterator iterator2 = in.iterator();
                    while (iterator2.hasNext()) {
                        Namespace n;
                        Object o = iterator2.next();
                        if (!(o instanceof Namespace) || element != (n = (Namespace)o).getParent()) continue;
                        out.append(n);
                        iterator2.remove();
                    }
                }
                for (int a = 0; a < element.getAttributeCount(); ++a) {
                    Attribute att = element.getAttribute(a);
                    if (!in.contains(att)) continue;
                    out.append(att);
                    in.remove(att);
                    if (!in.isEmpty()) continue;
                    return;
                }
                Canonicalizer.sort(in, namespaces, out, element);
                continue;
            }
            if (!in.contains(child)) continue;
            out.append(child);
            in.remove(child);
            if (!in.isEmpty()) continue;
            return;
        }
    }

    private class CanonicalXMLSerializer
    extends Serializer {
        private Nodes nodes;
        private NamespaceSupport inScope;
        private final XPathContext xmlcontext = new XPathContext("xml", "http://www.w3.org/XML/1998/namespace");

        CanonicalXMLSerializer(OutputStream out) {
            super(out);
            this.setLineSeparator("\n");
        }

        public final void write(Document doc) throws IOException {
            Node child;
            this.inScope = new NamespaceSupport();
            int position = 0;
            do {
                child = doc.getChild(position);
                if (this.nodes == null || child instanceof Element || this.nodes.contains(child)) {
                    this.writeChild(child);
                    if (child instanceof ProcessingInstruction) {
                        this.breakLine();
                    } else if (child instanceof Comment && Canonicalizer.this.withComments) {
                        this.breakLine();
                    }
                }
                ++position;
            } while (!(child instanceof Element));
            for (int i = position; i < doc.getChildCount(); ++i) {
                Node child2 = doc.getChild(i);
                if (this.nodes != null && !(child2 instanceof Element) && !this.nodes.contains(child2)) continue;
                if (child2 instanceof ProcessingInstruction) {
                    this.breakLine();
                } else if (child2 instanceof Comment && Canonicalizer.this.withComments) {
                    this.breakLine();
                }
                this.writeChild(child2);
            }
            this.flush();
        }

        protected final void write(Element element) throws IOException {
            if (element.getChildCount() == 0) {
                this.writeStartTag(element, false);
                this.writeEndTag(element);
            } else {
                Node current = element;
                boolean end = false;
                int index = -1;
                int[] indexes = new int[10];
                int top = 0;
                indexes[0] = -1;
                while (true) {
                    if (!end && ((Node)current).getChildCount() > 0) {
                        this.writeStartTag((Element)current, false);
                        current = ((Node)current).getChild(0);
                        index = 0;
                        indexes = this.grow(indexes, ++top);
                        indexes[top] = 0;
                        continue;
                    }
                    if (end) {
                        this.writeEndTag((Element)current);
                        if (current == element) {
                            break;
                        }
                    } else {
                        this.writeChild(current);
                    }
                    end = false;
                    ParentNode parent = current.getParent();
                    if (parent.getChildCount() - 1 == index) {
                        current = parent;
                        --top;
                        if (current != element) {
                            index = indexes[top];
                        }
                        end = true;
                        continue;
                    }
                    indexes[top] = ++index;
                    current = parent.getChild(index);
                }
            }
        }

        private int[] grow(int[] indexes, int top) {
            if (top < indexes.length) {
                return indexes;
            }
            int[] result = new int[indexes.length * 2];
            System.arraycopy(indexes, 0, result, 0, indexes.length);
            return result;
        }

        protected void writeStartTag(Element element, boolean isEmpty) throws IOException {
            boolean writeElement;
            boolean bl = writeElement = this.nodes == null || this.nodes.contains(element);
            if (writeElement) {
                this.inScope.pushContext();
                this.writeRaw("<");
                this.writeRaw(element.getQualifiedName());
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.nodes == null) {
                ParentNode parent = element.getParent();
                Element parentElement = null;
                if (parent instanceof Element) {
                    parentElement = (Element)parent;
                }
                for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
                    String prefix = element.getNamespacePrefix(i);
                    String uri = element.getNamespaceURI(prefix);
                    if (uri.equals(this.inScope.getURI(prefix))) continue;
                    if (Canonicalizer.this.exclusive) {
                        if (!this.needToDeclareNamespace(element, prefix, uri)) continue;
                        map.put(prefix, uri);
                        continue;
                    }
                    if (uri.equals("")) {
                        if (parentElement == null || "".equals(parentElement.getNamespaceURI(""))) continue;
                        map.put(prefix, uri);
                        continue;
                    }
                    map.put(prefix, uri);
                }
                this.writeNamespaceDeclarations(map);
            } else {
                Node next;
                int position = this.indexOf(element);
                if (position != -1 && "".equals(element.getNamespaceURI())) {
                    String uri;
                    ParentNode parent = element.getParent();
                    while (parent instanceof Element && !this.nodes.contains(parent)) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof Element && !"".equals(uri = ((Element)parent).getNamespaceURI(""))) {
                        map.put("", "");
                    }
                }
                for (int i = position + 1; i < this.nodes.size() && (next = this.nodes.get(i)) instanceof Namespace; ++i) {
                    Namespace namespace = (Namespace)next;
                    String prefix = namespace.getPrefix();
                    String uri = namespace.getValue();
                    if (uri.equals(this.inScope.getURI(prefix))) continue;
                    if (Canonicalizer.this.exclusive) {
                        if (!this.needToDeclareNamespace(element, prefix, uri)) continue;
                        map.put(prefix, uri);
                        continue;
                    }
                    map.put(prefix, uri);
                }
                this.writeNamespaceDeclarations(map);
            }
            Attribute[] sorted2 = this.sortAttributes(element);
            for (int i = 0; i < sorted2.length; ++i) {
                if (this.nodes != null && !this.nodes.contains(sorted2[i]) && (!sorted2[i].getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") || sorted2[i].getParent() == element)) continue;
                this.write(sorted2[i]);
            }
            if (writeElement) {
                this.writeRaw(">");
            }
        }

        private void writeNamespaceDeclarations(SortedMap map) throws IOException {
            Iterator prefixes = map.entrySet().iterator();
            while (prefixes.hasNext()) {
                Map.Entry entry = prefixes.next();
                String prefix = (String)entry.getKey();
                String uri = (String)entry.getValue();
                this.writeRaw(" ");
                this.writeNamespaceDeclaration(prefix, uri);
                this.inScope.declarePrefix(prefix, uri);
            }
        }

        private boolean needToDeclareNamespace(Element parent, String prefix, String uri) {
            boolean match = this.visiblyUtilized(parent, prefix, uri);
            if (match || Canonicalizer.this.inclusiveNamespacePrefixes.contains(prefix)) {
                return this.noOutputAncestorUsesPrefix(parent, prefix, uri);
            }
            return false;
        }

        private boolean visiblyUtilized(Element element, String prefix, String uri) {
            boolean match = false;
            String pfx = element.getNamespacePrefix();
            String local = element.getNamespaceURI();
            if (prefix.equals(pfx) && local.equals(uri)) {
                match = true;
            } else {
                for (int i = 0; i < element.getAttributeCount(); ++i) {
                    Attribute attribute = element.getAttribute(i);
                    if (this.nodes != null && !this.nodes.contains(attribute) || !prefix.equals(pfx = attribute.getNamespacePrefix())) continue;
                    match = true;
                    break;
                }
            }
            return match;
        }

        private boolean noOutputAncestorUsesPrefix(Element original, String prefix, String uri) {
            ParentNode parent = original.getParent();
            if (parent instanceof Document && "".equals(uri)) {
                return false;
            }
            while (parent != null && !(parent instanceof Document)) {
                if (this.nodes == null || this.nodes.contains(parent)) {
                    Element element = (Element)parent;
                    String pfx = element.getNamespacePrefix();
                    if (pfx.equals(prefix)) {
                        String newURI = element.getNamespaceURI(prefix);
                        return !newURI.equals(uri);
                    }
                    for (int i = 0; i < element.getAttributeCount(); ++i) {
                        Attribute attribute = element.getAttribute(i);
                        String current = attribute.getNamespacePrefix();
                        if (!current.equals(prefix)) continue;
                        String newURI = element.getNamespaceURI(prefix);
                        return !newURI.equals(uri);
                    }
                }
                parent = parent.getParent();
            }
            return true;
        }

        private int indexOf(Element element) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (this.nodes.get(i) != element) continue;
                return i;
            }
            return -1;
        }

        protected void write(Attribute attribute) throws IOException {
            this.writeRaw(" ");
            this.writeRaw(attribute.getQualifiedName());
            this.writeRaw("=\"");
            this.writeRaw(this.prepareAttributeValue(attribute));
            this.writeRaw("\"");
        }

        protected void writeEndTag(Element element) throws IOException {
            if (this.nodes == null || this.nodes.contains(element)) {
                this.writeRaw("</");
                this.writeRaw(element.getQualifiedName());
                this.writeRaw(">");
                this.inScope.popContext();
            }
        }

        private Attribute[] sortAttributes(Element element) {
            TreeMap<String, Attribute> nearest = new TreeMap<String, Attribute>();
            if (!Canonicalizer.this.exclusive && this.nodes != null && this.nodes.contains(element) && !this.nodes.contains(element.getParent())) {
                Nodes attributes = element.query("ancestor::*/@xml:*", this.xmlcontext);
                if (attributes.size() != 0) {
                    for (int i = attributes.size() - 1; i >= 0; --i) {
                        Attribute a = (Attribute)attributes.get(i);
                        String name = a.getLocalName();
                        if (element.getAttribute(name, "http://www.w3.org/XML/1998/namespace") != null || nearest.containsKey(name)) continue;
                        Element parent = (Element)a.getParent();
                        if (!this.nodes.contains(parent)) {
                            nearest.put(name, a);
                            continue;
                        }
                        nearest.put(name, null);
                    }
                }
                Iterator iterator2 = nearest.values().iterator();
                while (iterator2.hasNext()) {
                    if (iterator2.next() != null) continue;
                    iterator2.remove();
                }
            }
            int localCount = element.getAttributeCount();
            Attribute[] result = new Attribute[localCount + nearest.size()];
            for (int i = 0; i < localCount; ++i) {
                result[i] = element.getAttribute(i);
            }
            Iterator iterator3 = nearest.values().iterator();
            for (int j = localCount; j < result.length; ++j) {
                result[j] = (Attribute)iterator3.next();
            }
            Arrays.sort(result, comparator);
            return result;
        }

        private String prepareAttributeValue(Attribute attribute) {
            String value = attribute.getValue();
            StringBuffer result = new StringBuffer(value.length());
            if (attribute.getType().equals(Attribute.Type.CDATA) || attribute.getType().equals(Attribute.Type.UNDECLARED)) {
                char[] data = value.toCharArray();
                for (int i = 0; i < data.length; ++i) {
                    char c = data[i];
                    if (c == '\t') {
                        result.append("&#x9;");
                        continue;
                    }
                    if (c == '\n') {
                        result.append("&#xA;");
                        continue;
                    }
                    if (c == '\r') {
                        result.append("&#xD;");
                        continue;
                    }
                    if (c == '\"') {
                        result.append("&quot;");
                        continue;
                    }
                    if (c == '&') {
                        result.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        result.append("&lt;");
                        continue;
                    }
                    result.append(c);
                }
            } else {
                char[] data = value.toCharArray();
                boolean seenFirstNonSpace = false;
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == ' ') {
                        if (i == data.length - 1 || data[i + 1] == ' ' || !seenFirstNonSpace) continue;
                        result.append(data[i]);
                        continue;
                    }
                    seenFirstNonSpace = true;
                    if (data[i] == '\t') {
                        result.append("&#x9;");
                        continue;
                    }
                    if (data[i] == '\n') {
                        result.append("&#xA;");
                        continue;
                    }
                    if (data[i] == '\r') {
                        result.append("&#xD;");
                        continue;
                    }
                    if (data[i] == '\"') {
                        result.append("&quot;");
                        continue;
                    }
                    if (data[i] == '&') {
                        result.append("&amp;");
                        continue;
                    }
                    if (data[i] == '<') {
                        result.append("&lt;");
                        continue;
                    }
                    result.append(data[i]);
                }
            }
            return result.toString();
        }

        protected final void write(Text text) throws IOException {
            if (this.nodes == null || this.nodes.contains(text)) {
                String input = text.getValue();
                StringBuffer result = new StringBuffer(input.length());
                for (int i = 0; i < input.length(); ++i) {
                    char c = input.charAt(i);
                    if (c == '\r') {
                        result.append("&#xD;");
                        continue;
                    }
                    if (c == '&') {
                        result.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        result.append("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        result.append("&gt;");
                        continue;
                    }
                    result.append(c);
                }
                this.writeRaw(result.toString());
            }
        }

        protected final void write(Comment comment) throws IOException {
            if (Canonicalizer.this.withComments && (this.nodes == null || this.nodes.contains(comment))) {
                super.write(comment);
            }
        }

        protected final void write(ProcessingInstruction pi) throws IOException {
            if (this.nodes == null || this.nodes.contains(pi)) {
                super.write(pi);
            }
        }

        protected final void write(DocType doctype) {
        }

        public void write(Node node) throws IOException {
            if (node instanceof Document) {
                this.write((Document)node);
            } else if (node instanceof Attribute) {
                this.write((Attribute)node);
            } else if (node instanceof Namespace) {
                this.write((Namespace)node);
            } else {
                this.writeChild(node);
            }
        }

        private void write(Namespace namespace) throws IOException {
            String prefix = namespace.getPrefix();
            String uri = namespace.getValue();
            this.writeRaw(" xmlns");
            if (!"".equals(prefix)) {
                this.writeRaw(":");
                this.writeRaw(prefix);
            }
            this.writeRaw("=\"");
            this.writeAttributeValue(uri);
            this.writeRaw("\"");
        }
    }

    private static class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            String namespace2;
            Attribute a1 = (Attribute)o1;
            Attribute a2 = (Attribute)o2;
            String namespace1 = a1.getNamespaceURI();
            if (namespace1.equals(namespace2 = a2.getNamespaceURI())) {
                return a1.getLocalName().compareTo(a2.getLocalName());
            }
            if (namespace1.equals("")) {
                return -1;
            }
            if (namespace2.equals("")) {
                return 1;
            }
            return namespace1.compareTo(namespace2);
        }
    }
}

