/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

class XSLTHandler
implements ContentHandler,
LexicalHandler {
    private final Nodes result;
    private final ArrayList parents;
    private final NodeFactory factory;
    private StringBuffer buffer;
    private Element current;
    private AttributesImpl namespaceDeclarations = new AttributesImpl();

    XSLTHandler(NodeFactory factory2) {
        this.factory = factory2;
        this.result = new Nodes();
        this.parents = new ArrayList();
        this.buffer = new StringBuffer();
    }

    Nodes getResult() {
        this.flushText();
        return this.result;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        int i;
        this.flushText();
        int length = attributes.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            this.namespaceDeclarations.addAttribute(attributes.getURI(i2), attributes.getLocalName(i2), attributes.getQName(i2), attributes.getType(i2), attributes.getValue(i2));
        }
        attributes = this.namespaceDeclarations;
        Element element = this.factory.startMakingElement(qualifiedName, namespaceURI);
        if (this.parents.isEmpty()) {
            this.current = element;
        } else {
            ParentNode parent = (ParentNode)this.parents.get(this.parents.size() - 1);
            parent.appendChild(element);
        }
        this.parents.add(element);
        length = attributes.getLength();
        for (i = 0; i < length; ++i) {
            String attributeName = attributes.getQName(i);
            if (attributeName.equals("xmlns") || attributeName.startsWith("xmlns:")) continue;
            String namespace = attributes.getURI(i);
            String value = attributes.getValue(i);
            Nodes nodes = this.factory.makeAttribute(attributeName, namespace, value, Attribute.Type.UNDECLARED);
            int size = nodes.size();
            block8: for (int j = 0; j < size; ++j) {
                Node node = nodes.get(j);
                if (node instanceof Attribute) {
                    Attribute attribute = (Attribute)node;
                    while (true) {
                        try {
                            element.addAttribute(attribute);
                            continue block8;
                        }
                        catch (NamespaceConflictException ex) {
                            attribute.setNamespace("p" + attribute.getNamespacePrefix(), attribute.getNamespaceURI());
                            continue;
                        }
                        break;
                    }
                }
                element.appendChild(node);
            }
        }
        for (i = 0; i < length; ++i) {
            String namespacePrefix;
            String currentValue;
            String namespaceName;
            String qName = attributes.getQName(i);
            if (qName.startsWith("xmlns:")) {
                namespaceName = attributes.getValue(i);
                if (namespaceName.equals(currentValue = element.getNamespaceURI(namespacePrefix = qName.substring(6)))) continue;
                try {
                    element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                }
                catch (NamespaceConflictException ex) {}
                continue;
            }
            if (!qName.equals("xmlns")) continue;
            namespaceName = attributes.getValue(i);
            if (namespaceName == null) {
                namespaceName = "";
            }
            if (namespaceName.equals(currentValue = element.getNamespaceURI(namespacePrefix = ""))) continue;
            try {
                element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                continue;
            }
            catch (NamespaceConflictException ex) {
                if (!"http://www.w3.org/XML/1998/namespace".equals(namespaceName) || !"".equals(namespacePrefix)) continue;
                element.addNamespaceDeclaration("", "");
            }
        }
        this.namespaceDeclarations = new AttributesImpl();
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        this.flushText();
        Element element = (Element)this.parents.remove(this.parents.size() - 1);
        if (this.parents.isEmpty()) {
            Nodes nodes = this.factory.finishMakingElement(this.current);
            for (int i = 0; i < nodes.size(); ++i) {
                this.result.append(nodes.get(i));
            }
            this.current = null;
        } else {
            Nodes nodes = this.factory.finishMakingElement(element);
            ParentNode parent = element.getParent();
            element.detach();
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    ((Element)parent).addAttribute((Attribute)node);
                    continue;
                }
                parent.appendChild(node);
            }
        }
    }

    public void characters(char[] text, int start, int length) {
        this.buffer.append(text, start, length);
    }

    private void flushText() {
        if (this.buffer.length() > 0) {
            Nodes text = this.factory.makeText(this.buffer.toString());
            this.addToResultTree(text);
            this.buffer = new StringBuffer();
        }
    }

    public void ignorableWhitespace(char[] text, int start, int length) {
        this.characters(text, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if ("saxon:warning".equals(target)) {
            throw new SAXException("continue");
        }
        if ("javax.xml.transform.disable-output-escaping".equals(target) || "javax.xml.transform.enable-output-escaping".equals(target)) {
            return;
        }
        this.flushText();
        int position = data.indexOf("?>");
        while (position != -1) {
            data = data.substring(0, position) + "? >" + data.substring(position + 2);
            position = data.indexOf("?>");
        }
        Nodes nodes = this.factory.makeProcessingInstruction(target, data);
        this.addToResultTree(nodes);
    }

    private void addToResultTree(Nodes nodes) {
        if (this.parents.isEmpty()) {
            for (int i = 0; i < nodes.size(); ++i) {
                this.result.append(nodes.get(i));
            }
        } else {
            ParentNode parent = (ParentNode)this.parents.get(this.parents.size() - 1);
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    ((Element)parent).addAttribute((Attribute)node);
                    continue;
                }
                parent.appendChild(node);
            }
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void startPrefixMapping(String prefix, String uri) {
        if ("".equals(prefix)) {
            this.namespaceDeclarations.addAttribute("", "xmlns", "xmlns", "CDATA", uri);
        } else {
            this.namespaceDeclarations.addAttribute("", "xmlns:" + prefix, "xmlns:" + prefix, "CDATA", uri);
        }
    }

    public void skippedEntity(String name) {
        this.flushText();
        throw new XMLException("Could not resolve entity " + name);
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startDTD(String name, String publicID, String systemID) {
    }

    public void endDTD() {
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void comment(char[] text, int start, int length) {
        this.flushText();
        String data = new String(text, start, length);
        int position = data.indexOf("--");
        while (position != -1) {
            data = data.substring(0, position) + "- -" + data.substring(position + 2);
            position = data.indexOf("--");
        }
        if (data.endsWith("-")) {
            data = data + ' ';
        }
        this.addToResultTree(this.factory.makeComment(data));
    }
}

