/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xpath;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.dom.SimpleNodeList;
import org.jdesktop.xpath.function.XPathFunctionResolverImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtils {
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final XPathFunctionResolverImpl functionResolver = new XPathFunctionResolverImpl();

    private XPathUtils() {
    }

    public static synchronized SimpleNodeList getElements(String expression, Node node) throws XPathExpressionException {
        SimpleNodeList nodes = new SimpleNodeList((NodeList)xpath.evaluate(expression, node, XPathConstants.NODESET));
        return nodes;
    }

    public static synchronized Node getElement(String expression, Node node) throws XPathExpressionException {
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        return n;
    }

    public static synchronized String getString(String expression, Node node) throws XPathExpressionException {
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        return n == null ? null : n.getTextContent();
    }

    public static synchronized String getString(String expression, Node node, String namespace, String namespacePrefix) throws XPathExpressionException {
        functionResolver.addNamespaceMapping(namespacePrefix, namespace);
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        functionResolver.removeNamespaceMapping(namespacePrefix);
        return n == null ? null : n.getTextContent();
    }

    public static synchronized SimpleNodeList getElements(XPathExpression expression, Node node) throws XPathExpressionException {
        SimpleNodeList nodes = new SimpleNodeList((NodeList)expression.evaluate(node, XPathConstants.NODESET));
        return nodes;
    }

    public static synchronized Node getElement(XPathExpression expression, Node node) throws XPathExpressionException {
        Node n = (Node)expression.evaluate(node, XPathConstants.NODE);
        return n;
    }

    public static synchronized String getString(XPathExpression expression, Node node) throws XPathExpressionException {
        Node n = (Node)expression.evaluate(node, XPathConstants.NODE);
        return n == null ? null : n.getTextContent();
    }

    public static synchronized XPathExpression compile(String expression) throws XPathExpressionException {
        return xpath.compile(expression);
    }

    public static String toXML(Document dom) {
        return XPathUtils.toXML(dom, null);
    }

    public static String toXML(Document dom, Properties outputProperties) {
        try {
            DOMSource source2 = new DOMSource(dom);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            if (outputProperties != null) {
                tx.setOutputProperties(outputProperties);
            }
            tx.transform(source2, result);
            String s = writer.toString();
            writer.close();
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        xpath.setNamespaceContext(functionResolver);
        xpath.setXPathFunctionResolver(functionResolver);
    }
}

