/*
 * Decompiled with CFR 0.152.
 */
package overpass;

import action.CupActionAddBuilding;
import action.CupActionBlock;
import action.CupActionStack;
import buildings.Building;
import buildings.BuildingList;
import cupcarbon.CupCarbonApp;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import map.MapLayer;
import overpass.Osm;
import overpass.OsmNd;
import overpass.OsmNode;
import overpass.OsmWay;

public class OsmOverpass {
    protected double bottomLeftLat;
    protected double bottomLeftLng;
    protected double topRightLat;
    protected double topRightLng;

    public OsmOverpass(double bottomLeftLat, double bottomLeftLng, double topRightLat, double topRightLng) {
        this.bottomLeftLat = Math.min(bottomLeftLat, topRightLat);
        this.bottomLeftLng = Math.min(bottomLeftLng, topRightLng);
        this.topRightLat = Math.max(bottomLeftLat, topRightLat);
        this.topRightLng = Math.max(bottomLeftLng, topRightLng);
    }

    public void load() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                BuildingList.isLoading = true;
                CupCarbonApp.cupCarbonController.displayPermanentErrMessage_th("Loading ...");
                try {
                    URL url = new URL("http://overpass-api.de/api/map?bbox=" + OsmOverpass.this.bottomLeftLat + "," + OsmOverpass.this.bottomLeftLng + "," + OsmOverpass.this.topRightLat + "," + OsmOverpass.this.topRightLng);
                    System.out.println(url);
                    System.out.println("[Buildings] File downloading...");
                    Osm data = (Osm)JAXBContext.newInstance(Osm.class).createUnmarshaller().unmarshal(url);
                    System.out.println("[Buildings] File downloaded.");
                    System.out.println("[Buildings] Processing...");
                    CupCarbonApp.cupCarbonController.displayPermanentErrMessage_th("Processing ...");
                    List<OsmWay> ways = data.getWay();
                    List<OsmNode> nodes = data.getNode();
                    CupActionBlock block = new CupActionBlock();
                    for (OsmWay way : ways) {
                        if (!way.isBuilding()) continue;
                        List<OsmNd> nds = way.getNd();
                        Building building = new Building(nds.size());
                        block4: for (int i = nds.size() - 1; i >= 0; --i) {
                            for (OsmNode node : nodes) {
                                if (!nds.get(i).getRef().equals(node.getId())) continue;
                                building.set(node.getLon(), node.getLat(), i);
                                continue block4;
                            }
                        }
                        MapLayer.mapViewer.addMouseListener(building);
                        MapLayer.mapViewer.addKeyListener(building);
                        CupActionAddBuilding action = new CupActionAddBuilding(building);
                        block.addAction(action);
                    }
                    if (block.size() > 0) {
                        CupActionStack.add(block);
                        CupActionStack.execute();
                    }
                    BuildingList.isLoading = false;
                    MapLayer.repaint();
                    System.out.println("[Buildings] Building loaded: SECCESS!");
                    CupCarbonApp.cupCarbonController.displayShortGoodMessage_th("Success ...");
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

