/*
 * Decompiled with CFR 0.152.
 */
package radio_module;

import device.SensorNode;
import interference.LoRaTransceiver;
import interference.WiFiTransceiver;
import interference.ZigBeeTransceiver;
import simulation.SimulationInputs;

public class ErrorBits {
    public static final int PROBABILITY = 0;
    public static final int ALPHA_D = 1;
    public static final int AWGN = 2;

    public static boolean errorBitsOk(String message, SensorNode transmitter, SensorNode receiver) {
        if (SimulationInputs.ack) {
            if (SimulationInputs.ackType == 0.0) {
                return Math.random() <= SimulationInputs.ackProba;
            }
            if (SimulationInputs.ackType == 1.0 && transmitter.getStandard() == receiver.getStandard() && transmitter.getStandard() == 1) {
                double errorBits = ZigBeeTransceiver.getNumberOfReceivedErrorBits(message, transmitter.getNeighbors().size(), (int)transmitter.getCurrentRadioModule().getRadioRangeRadius(), transmitter.getPerActiveNodes());
                return errorBits == 0.0;
            }
            if (SimulationInputs.ackType == 1.0 && transmitter.getStandard() == receiver.getStandard() && transmitter.getStandard() == 2) {
                double errorBits = WiFiTransceiver.getNumberOfReceivedErrorBits(message, transmitter.getNeighbors().size(), (int)transmitter.getCurrentRadioModule().getRadioRangeRadius(), transmitter.getPerActiveNodes());
                return errorBits == 0.0;
            }
            if (SimulationInputs.ackType == 2.0 && transmitter.getStandard() == receiver.getStandard() && transmitter.getStandard() == 3) {
                double errorBits = LoRaTransceiver.getNumberOfReceivedErrorBits(message, transmitter.getCurrentRadioModule().getSpreadingFactor(), transmitter.getCurrentRadioModule().getCodeRate());
                return errorBits == 0.0;
            }
            System.err.println("[ErrorBits] -> This kind of interference is not considered!");
            return false;
        }
        return true;
    }
}

