/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import java.util.List;
import radio_module.XBeeFrameGenerator;
import radio_module.XBeeToArduinoFrameGenerator;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_ATND
extends Command {
    protected String arg1 = "";
    protected String arg2 = "";
    protected double arg3 = 0.001;

    public Command_ATND(SensorNode sensor, String arg1) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = "";
    }

    public Command_ATND(SensorNode sensor, String arg1, String arg2) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public double execute() {
        String message;
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " ATND " + this.arg1 + " " + this.arg2 + "+arg3");
        List<SensorNode> snList = this.sensor.getSensorNodeNeighbors();
        int n = snList.size();
        this.sensor.getScript().addVariable(this.arg1, "" + n);
        if (!this.arg2.equals("")) {
            this.sensor.getScript().putVector(this.arg2, n);
            String[] vector = this.sensor.getScript().getVector(this.arg2);
            for (int i = 0; i < n; ++i) {
                vector[i] = "" + snList.get(i).getId();
            }
        }
        String frame = message = "ND";
        if (this.sensor.getStandard() == 1) {
            frame = XBeeFrameGenerator.at(message);
        }
        double ratio = 1.0 / (double)this.sensor.getUartDataRate();
        return this.arg3 + ratio * ((double)frame.length() * 8.0);
    }

    @Override
    public String getArduinoForm() {
        String s = XBeeToArduinoFrameGenerator.nd();
        return s;
    }

    @Override
    public String toString() {
        return "ATND";
    }

    @Override
    public boolean isSend() {
        return true;
    }

    @Override
    public String finishMessage() {
        return "S" + this.sensor.getId() + " ATND: " + this.sensor.getSensorNodeNeighbors().size();
    }
}

