/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.DeviceList;
import device.SensorNode;
import map.MapLayer;
import radio_module.XBeeFrameGenerator;
import radio_module.XBeeToArduinoFrameGenerator;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_ATPL
extends Command {
    protected String arg = "";

    public Command_ATPL(SensorNode sensor, String arg) {
        this.sensor = sensor;
        this.arg = arg;
    }

    @Override
    public double execute() {
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " ATPL " + this.arg);
        String args2 = this.sensor.getScript().getVariableValue(this.arg);
        double v = Double.valueOf(args2);
        this.sensor.setPl(v);
        MapLayer.repaint();
        if (DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
        String message = "PL" + Integer.toHexString(Double.valueOf(v).intValue()).toUpperCase();
        Object frame = message;
        if (this.sensor.getStandard() == 1) {
            frame = XBeeFrameGenerator.at(message);
        }
        double ratio = 1.0 / (double)this.sensor.getUartDataRate();
        return ratio * ((double)((String)frame).length() * 8.0);
    }

    @Override
    public String getArduinoForm() {
        String s = XBeeToArduinoFrameGenerator.at("PL" + this.arg);
        return s;
    }

    @Override
    public String toString() {
        return "ATPL";
    }
}

