/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_DELAY
extends Command {
    protected String arg = "";

    public Command_DELAY(SensorNode sensor, String arg) {
        this.sensor = sensor;
        this.arg = arg;
    }

    @Override
    public double execute() {
        double carg = Double.parseDouble(this.sensor.getScript().getVariableValue(this.arg));
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " starts delaying for " + carg + " milliseconds");
        return carg / 1000.0 * this.sensor.getDriftTime();
    }

    @Override
    public boolean isDelay() {
        return true;
    }

    @Override
    public String getArduinoForm() {
        return "\tdelay(" + Integer.valueOf(this.arg) + ");";
    }

    @Override
    public String toString() {
        return "DELAY";
    }

    @Override
    public String finishMessage() {
        return "S" + this.sensor.getId() + " has finished the delay.";
    }
}

