/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import arduino.BeginInstructions;
import device.SensorNode;
import senscript.Command;
import simulation.WisenSimulation;
import utilities.UColor;

public class Command_LED
extends Command {
    protected String arg1 = "";
    protected String arg2 = "";

    public Command_LED(SensorNode sensor, String arg1, String arg2) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public double execute() {
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " LED " + this.arg1 + " -> Color = " + this.arg2);
        int ledColor = Double.valueOf(this.sensor.getScript().getVariableValue(this.arg2)).intValue();
        ledColor = ledColor > UColor.colorTab.length - 1 ? ledColor % UColor.colorTab.length + 1 : (ledColor %= UColor.colorTab.length + 1);
        this.sensor.setLedColor(ledColor);
        return 0.0;
    }

    @Override
    public String getArduinoForm() {
        BeginInstructions.add("pinMode(" + this.arg1 + ", OUTPUT);");
        Object s = "";
        String v = "'" + this.arg2.charAt(0) + "'";
        if (this.arg2.charAt(0) == '$') {
            v = this.arg2.substring(1) + ".charAt(0)";
        }
        s = "\tdigitalWrite(13, 1-('1'-" + v + "));";
        return s;
    }

    @Override
    public String toString() {
        return "LED";
    }
}

