/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import cupcarbon.CupCarbonApp;
import device.SensorNode;
import senscript.Command;
import senscript.SenScriptException;
import simulation.WisenSimulation;

public class Command_RDATA
extends Command {
    protected String data = "";
    protected String[] args = null;

    public Command_RDATA(SensorNode sensor, String[] args2) {
        this.sensor = sensor;
        this.args = args2;
    }

    @Override
    public double execute() {
        Object symbole = "#";
        if (this.args[1].charAt(0) == '!') {
            symbole = "" + this.args[1].charAt(1);
            this.data = this.sensor.getScript().getVariableValue(this.args[2]);
        } else {
            this.data = this.sensor.getScript().getVariableValue(this.args[1]);
        }
        if (this.data == null) {
            String errMessage = "[CupCarbon ERROR] (S" + this.sensor.getId() + "): The first argument of RDATA cannot be null";
            System.err.println(errMessage);
            CupCarbonApp.cupCarbonController.displayShortErrMessageTh("ERROR");
            throw new SenScriptException(errMessage);
        }
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " Read DATA: " + this.data);
        String[] tab = this.data.split((String)symbole);
        int i = 2;
        int j = 2;
        if (this.args[1].charAt(0) == '!') {
            i = 3;
            j = 3;
        }
        while (i < this.args.length) {
            try {
                this.sensor.getScript().addVariable(this.args[i], tab[i - j]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return 0.0;
    }

    @Override
    public String toString() {
        return "RDATA";
    }
}

