/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import senscript.Command;
import senscript.SenScript;
import senscript.SenScriptCondition;
import senscript.SenScriptConditionElement;
import senscript.SenScriptEvalCondition;
import senscript_functions.AddFullParentheses;
import simulation.WisenSimulation;

public class Command_WHILE
extends Command {
    protected boolean resultOfCondition = true;
    protected String arg = "";
    protected String left = "";
    protected String right = "";
    protected String ineq = "";
    protected int index = -1;
    protected int endWhileIndex = -1;
    protected Command_WHILE parent = null;

    public Command_WHILE getParent() {
        return this.parent;
    }

    public void setParent(Command_WHILE parent) {
        this.parent = parent;
    }

    public Command_WHILE(SensorNode sensor, String arg) {
        this.sensor = sensor;
        this.arg = AddFullParentheses.addParentheses(arg);
        String[] inst = SenScriptCondition.getTwoParts(arg);
        this.left = inst[0];
        this.right = inst[1];
        this.ineq = inst[2];
    }

    public String getRight() {
        return this.right;
    }

    public String getLeft() {
        return this.left;
    }

    public String getIneq() {
        return this.ineq;
    }

    @Override
    public double execute() {
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " WHILE ");
        this.index = this.sensor.getScript().getIndex();
        SenScript script = this.sensor.getScript();
        String condition = this.getArg().replaceFirst("while", "");
        SenScriptEvalCondition evalCondtion = new SenScriptEvalCondition(this.sensor);
        SenScriptConditionElement conditionElement = evalCondtion.initCondition(condition);
        this.resultOfCondition = conditionElement.evaluate();
        if (!this.resultOfCondition) {
            script.setIndex(this.endWhileIndex);
        }
        return 0.0;
    }

    public boolean getResultOfCondition() {
        return this.resultOfCondition;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getEndWhileIndex() {
        return this.endWhileIndex;
    }

    public void setEndWhileIndex(int endWhileIndex) {
        this.endWhileIndex = endWhileIndex;
    }

    public String getArg() {
        return this.arg;
    }

    @Override
    public String toString() {
        return "WHILE";
    }
}

