/*
 * Decompiled with CFR 0.152.
 */
package sensorunit;

import device.Device;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import map.MapLayer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import sensorunit.SensorUnit;
import utilities.MapCalc;
import utilities.UColor;

public class DirectionalSensorUnit
extends SensorUnit
implements Cloneable {
    public DirectionalSensorUnit(double longitude, double latitude, double elevation, Device node) {
        super(longitude, latitude, elevation, node);
        this.radius = 100.0;
        this.n = 12;
        this.coverage = 0.1;
        this.direction = 0.0;
        this.eSensing = 1.0;
        this.calculateSensingArea();
    }

    public DirectionalSensorUnit(double longitude, double latitude, double elevation, double radius, double angle, double dec, int n, Device node) {
        super(longitude, latitude, elevation, node);
        this.radius = radius;
        this.coverage = angle;
        this.direction = dec;
        this.n = n;
        this.radius = radius;
        this.calculateSensingArea();
    }

    @Override
    public void calculateSensingArea() {
        int rayon = MapCalc.radiusInPixels(this.radius);
        double r2 = 0.0;
        double r3 = 0.0;
        this.polyX[0] = (int)this.longitude;
        this.polyY[0] = (int)this.latitude;
        double i = this.direction;
        for (int k = 1; k < this.n; ++k) {
            r2 = (double)rayon * Math.cos(i);
            r3 = (double)rayon * Math.sin(i);
            this.polyX[k] = (int)(this.longitude + r2);
            this.polyY[k] = (int)(this.latitude + r3);
            i += this.coverage;
        }
    }

    @Override
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Override
    public void setPosition(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    @Override
    public boolean detect(Device device) {
        if (device.getRadius() > 0.0) {
            Polygon poly = new Polygon(this.polyX, this.polyY, this.n);
            GeoPosition gp = new GeoPosition(device.getLatitude(), device.getLongitude());
            Point2D p1 = MapLayer.mapViewer.getTileFactory().geoToPixel(gp, MapLayer.mapViewer.getZoom());
            return poly.contains(p1);
        }
        return false;
    }

    @Override
    public void draw(Graphics g, int mode, boolean detection, boolean buildingDetection) {
        this.calculateSensingArea();
        if (!detection) {
            g.setColor(UColor.WHITE_LLTRANSPARENT);
        } else {
            g.setColor(UColor.GREEND_TTRANSPARENT);
        }
        if (mode == 0) {
            g.fillPolygon(this.polyX, this.polyY, this.n);
        }
        g.setColor(UColor.BLACK_TTTRANSPARENT);
        g.drawPolygon(this.polyX, this.polyY, this.n);
    }

    @Override
    public void setNode(Device node) {
        this.node = node;
    }

    public int getN() {
        return this.n;
    }

    @Override
    public DirectionalSensorUnit clone() throws CloneNotSupportedException {
        DirectionalSensorUnit newCU = (DirectionalSensorUnit)super.clone();
        return newCU;
    }

    @Override
    public void incRadius(int u) {
        this.radius += (double)u;
    }

    @Override
    public double getCoverage() {
        return this.coverage;
    }

    @Override
    public double getDirection() {
        return this.direction;
    }

    @Override
    public void setCoverage(double angle) {
        this.coverage = angle;
    }

    @Override
    public void setDirection(double direction) {
        this.direction = direction;
    }
}

