/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import com.sun.j3d.utils.behaviors.sensor.SensorButtonListener;
import com.sun.j3d.utils.behaviors.sensor.SensorEvent;
import com.sun.j3d.utils.behaviors.sensor.SensorReadListener;
import com.sun.j3d.utils.timer.J3DTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;

public class SensorEventAgent {
    private long t0 = 0L;
    private Object source = null;
    private SensorEvent e = new SensorEvent();
    private List bindingsList = new ArrayList();
    private SensorBinding[] bindings = new SensorBinding[0];
    private boolean listsDirty = false;

    public SensorEventAgent(Object object) {
        this.source = object;
    }

    private SensorBinding getSensorBinding(Sensor sensor) {
        for (int i = 0; i < this.bindingsList.size(); ++i) {
            SensorBinding sensorBinding = (SensorBinding)this.bindingsList.get(i);
            if (sensorBinding.sensor != sensor) continue;
            return sensorBinding;
        }
        return null;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, int n, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (n >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + n + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        SensorButtonListener[] sensorButtonListenerArray = new SensorButtonListener[sensorBinding.buttons.length];
        sensorButtonListenerArray[n] = sensorButtonListener;
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, true);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        SensorButtonListener[] sensorButtonListenerArray = new SensorButtonListener[sensorBinding.buttons.length];
        for (int i = 0; i < sensorBinding.buttons.length; ++i) {
            sensorButtonListenerArray[i] = sensorButtonListener;
        }
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, true);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListeners(Sensor sensor, SensorButtonListener[] sensorButtonListenerArray) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        if (sensorBinding.buttons.length != sensorButtonListenerArray.length) {
            throw new IllegalArgumentException("\nbuttonListeners length " + sensorButtonListenerArray.length + " must equal sensor button count " + sensorBinding.buttons.length);
        }
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, false);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public SensorButtonListener[] getSensorButtonListeners(Sensor sensor, int n) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (n >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + n + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return null;
        }
        ArrayList<SensorButtonListener> arrayList = new ArrayList<SensorButtonListener>();
        for (int i = 0; i < sensorBinding.buttonBindingsList.size(); ++i) {
            SensorButtonBinding sensorButtonBinding = (SensorButtonBinding)sensorBinding.buttonBindingsList.get(i);
            if (sensorButtonBinding.listeners[n] == null) continue;
            arrayList.add(sensorButtonBinding.listeners[n]);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new SensorButtonListener[arrayList.size()]);
    }

    private void removeSensorButtonListener(SensorBinding sensorBinding, SensorButtonListener sensorButtonListener) {
        Iterator iterator2 = sensorBinding.buttonBindingsList.iterator();
        while (iterator2.hasNext()) {
            int n = 0;
            SensorButtonBinding sensorButtonBinding = (SensorButtonBinding)iterator2.next();
            for (int i = 0; i < sensorButtonBinding.listeners.length; ++i) {
                if (sensorButtonBinding.listeners[i] == sensorButtonListener) {
                    sensorButtonBinding.listeners[i] = null;
                    continue;
                }
                if (sensorButtonBinding.listeners[i] == null) continue;
                ++n;
            }
            if (n != 0) continue;
            iterator2.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(Sensor sensor, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return;
        }
        this.removeSensorButtonListener(sensorBinding, sensorButtonListener);
        if (sensorBinding.buttonBindingsList.size() == 0 && sensorBinding.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(SensorButtonListener sensorButtonListener) {
        Iterator iterator2 = this.bindingsList.iterator();
        while (iterator2.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator2.next();
            this.removeSensorButtonListener(sensorBinding, sensorButtonListener);
            if (sensorBinding.buttonBindingsList.size() != 0 || sensorBinding.readBindingsList.size() != 0) continue;
            iterator2.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void addSensorReadListener(Sensor sensor, SensorReadListener sensorReadListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        sensorBinding.readBindingsList.add(sensorReadListener);
        this.listsDirty = true;
    }

    public SensorReadListener[] getSensorReadListeners(Sensor sensor) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return null;
        }
        if (sensorBinding.readBindingsList.size() == 0) {
            return null;
        }
        return sensorBinding.readBindingsList.toArray(new SensorReadListener[sensorBinding.readBindingsList.size()]);
    }

    private void removeSensorReadListener(SensorBinding sensorBinding, SensorReadListener sensorReadListener) {
        Iterator iterator2 = sensorBinding.readBindingsList.iterator();
        while (iterator2.hasNext()) {
            if ((SensorReadListener)iterator2.next() != sensorReadListener) continue;
            iterator2.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(Sensor sensor, SensorReadListener sensorReadListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return;
        }
        this.removeSensorReadListener(sensorBinding, sensorReadListener);
        if (sensorBinding.buttonBindingsList.size() == 0 && sensorBinding.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(SensorReadListener sensorReadListener) {
        Iterator iterator2 = this.bindingsList.iterator();
        while (iterator2.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator2.next();
            this.removeSensorReadListener(sensorBinding, sensorReadListener);
            if (sensorBinding.buttonBindingsList.size() != 0 || sensorBinding.readBindingsList.size() != 0) continue;
            iterator2.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorBinding(Sensor sensor) {
        Iterator iterator2 = this.bindingsList.iterator();
        while (iterator2.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator2.next();
            if (sensorBinding.sensor != sensor) continue;
            iterator2.remove();
            break;
        }
        this.listsDirty = true;
    }

    public Sensor[] getSensors() {
        if (this.bindingsList.size() == 0) {
            return null;
        }
        Sensor[] sensorArray = new Sensor[this.bindingsList.size()];
        for (int i = 0; i < this.bindingsList.size(); ++i) {
            sensorArray[i] = ((SensorBinding)this.bindingsList.get((int)i)).sensor;
        }
        return sensorArray;
    }

    private synchronized void updateArrays() {
        this.bindings = this.bindingsList.toArray(new SensorBinding[this.bindingsList.size()]);
        for (int i = 0; i < this.bindings.length; ++i) {
            this.bindings[i].updateArrays();
        }
    }

    public void dispatchEvents() {
        long l = this.t0;
        this.t0 = J3DTimer.getValue();
        if (this.listsDirty) {
            this.updateArrays();
            this.listsDirty = false;
        }
        for (int i = 0; i < this.bindings.length; ++i) {
            int n;
            SensorBinding sensorBinding = this.bindings[i];
            Sensor sensor = sensorBinding.sensor;
            Transform3D transform3D = sensorBinding.read;
            int[] nArray = sensorBinding.buttons;
            int n2 = 0;
            boolean bl = true;
            boolean bl2 = false;
            sensor.getRead(transform3D);
            sensor.lastButtons(nArray);
            for (n = 0; n < sensorBinding.buttonBindings.length; ++n) {
                SensorButtonBinding sensorButtonBinding = sensorBinding.buttonBindings[n];
                for (int j = 0; j < nArray.length; ++j) {
                    if (sensorButtonBinding.listeners[j] == null) continue;
                    if (sensorButtonBinding.prevButtons[j]) {
                        if (nArray[j] == 0) {
                            this.e.set(this.source, 2, sensor, transform3D, nArray, j, this.t0, l);
                            sensorButtonBinding.listeners[j].released(this.e);
                            sensorButtonBinding.prevButtons[j] = false;
                            --sensorButtonBinding.buttonsHandled;
                        } else {
                            bl2 = true;
                            n2 = j;
                        }
                        bl = false;
                        continue;
                    }
                    if (nArray[j] != 1 || sensorButtonBinding.buttonsHandled != 0 && !sensorButtonBinding.multiButton) continue;
                    this.e.set(this.source, 1, sensor, transform3D, nArray, j, this.t0, l);
                    sensorButtonBinding.listeners[j].pressed(this.e);
                    sensorButtonBinding.prevButtons[j] = true;
                    ++sensorButtonBinding.buttonsHandled;
                    bl = false;
                }
                if (!bl2) continue;
                this.e.set(this.source, 3, sensor, transform3D, nArray, -1, this.t0, l);
                sensorButtonBinding.listeners[n2].dragged(this.e);
            }
            if (!bl) continue;
            this.e.set(this.source, 4, sensor, transform3D, nArray, -1, this.t0, l);
            for (n = 0; n < sensorBinding.readBindings.length; ++n) {
                sensorBinding.readBindings[n].read(this.e);
            }
        }
    }

    public String toString() {
        String string = "SensorEventAgent@" + Integer.toHexString(this.hashCode());
        string = string + "\nsensor bindings:\n\n";
        for (int i = 0; i < this.bindingsList.size(); ++i) {
            string = string + ((SensorBinding)this.bindingsList.get(i)).toString() + "\n";
        }
        return string;
    }

    private static class SensorBinding {
        Sensor sensor = null;
        int[] buttons = null;
        Transform3D read = null;
        List buttonBindingsList = new ArrayList();
        SensorButtonBinding[] buttonBindings = new SensorButtonBinding[0];
        List readBindingsList = new ArrayList();
        SensorReadListener[] readBindings = new SensorReadListener[0];

        SensorBinding(Sensor sensor) {
            this.sensor = sensor;
            this.buttons = new int[sensor.getSensorButtonCount()];
            this.read = new Transform3D();
        }

        void updateArrays() {
            this.buttonBindings = this.buttonBindingsList.toArray(new SensorButtonBinding[this.buttonBindingsList.size()]);
            this.readBindings = this.readBindingsList.toArray(new SensorReadListener[this.readBindingsList.size()]);
        }

        public String toString() {
            int n;
            String string = new String();
            string = "sensor " + this.sensor + "\nbutton listener arrays:\n";
            for (n = 0; n < this.buttonBindingsList.size(); ++n) {
                string = string + (SensorButtonBinding)this.buttonBindingsList.get(n);
            }
            string = string + "read listeners:\n";
            for (n = 0; n < this.readBindingsList.size(); ++n) {
                string = string + "  " + (SensorReadListener)this.readBindingsList.get(n) + "\n";
            }
            return string;
        }
    }

    private static class SensorButtonBinding {
        int buttonsHandled = 0;
        boolean[] prevButtons = null;
        boolean multiButton = false;
        SensorButtonListener[] listeners = null;

        SensorButtonBinding(SensorButtonListener[] sensorButtonListenerArray, boolean bl) {
            this.prevButtons = new boolean[sensorButtonListenerArray.length];
            this.listeners = new SensorButtonListener[sensorButtonListenerArray.length];
            for (int i = 0; i < sensorButtonListenerArray.length; ++i) {
                this.prevButtons[i] = false;
                this.listeners[i] = sensorButtonListenerArray[i];
            }
            this.multiButton = bl;
        }

        public String toString() {
            String string = new String();
            string = "  length " + this.listeners.length + ", mutual exclusion " + !this.multiButton + "\n";
            for (int i = 0; i < this.listeners.length; ++i) {
                string = string + "    " + (this.listeners[i] == null ? "null" : this.listeners[i].toString()) + "\n";
            }
            return string;
        }
    }
}

