/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon;

import cupcarbon.CupCarbonApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import project.Project;

public class SenScriptController
implements Initializable {
    @FXML
    private TextArea zone;
    @FXML
    private ComboBox<String> txtLoadFileName;
    @FXML
    private TextField txtFileName;

    @FXML
    private void loopCom() {
        this.zone.replaceSelection("loop\n");
    }

    @FXML
    private void setCom() {
        this.zone.replaceSelection("set x 0\n");
    }

    @FXML
    private void sendCom() {
        this.zone.replaceSelection("send 1\n");
    }

    @FXML
    private void delayCom() {
        this.zone.replaceSelection("delay 1000\n");
    }

    @FXML
    private void example1_1Com() {
        this.zone.clear();
        this.zone.replaceSelection("//Transmitter\nloop\nsend 1\ndelay 1000\nsend 0\ndelay 1000");
    }

    @FXML
    private void example1_2Com() {
        this.zone.clear();
        this.zone.replaceSelection("//Transmitter\natget id id\nloop\ndata p id \"A\"\nsend p\ndelay 1000\ndata p id \"B\"\nsend p\ndelay 1000");
    }

    @FXML
    private void example2_1Com() {
        this.zone.clear();
        this.zone.replaceSelection("//Router\nloop\nwait\nread v\nsend v 2");
    }

    @FXML
    private void example2_2Com() {
        this.zone.clear();
        this.zone.replaceSelection("//Router\natget id id\nloop\nwait\nread rp\nrdata rp rid v\ndata p id v\nsend p * rid");
    }

    @FXML
    private void example3_1Com() {
        this.zone.clear();
        this.zone.replaceSelection("//Receiver\nloop\nwait\nread v\nmark v");
    }

    @FXML
    private void example3_2Com() {
        this.zone.clear();
        this.zone.replaceSelection("//Receiver\nloop\nwait\nread rp\nrdata rp rid v\nif(v==\"A\")\n\t  mark 1\nelse\n  mark 0\nend");
    }

    @FXML
    private void ifthenelseCom() {
        this.zone.replaceSelection("if()\n\nelse\n\nend\n");
    }

    @FXML
    private void waitCom() {
        this.zone.replaceSelection("wait\n");
    }

    @FXML
    private void readCom() {
        this.zone.replaceSelection("read x\n");
    }

    @FXML
    private void forCom() {
        this.zone.replaceSelection("for i 0 9\n\nend\n");
    }

    @FXML
    private void incCom() {
        this.zone.replaceSelection("inc x\n");
    }

    @FXML
    public void load() {
        if (this.txtLoadFileName.getSelectionModel().getSelectedIndex() > 0) {
            this.txtFileName.setText(((String)this.txtLoadFileName.getSelectionModel().getSelectedItem()).toString());
            this.zone.setText("");
            try {
                FileInputStream in = new FileInputStream(new File(Project.getScriptFileFromName(((String)this.txtLoadFileName.getSelectionModel().getSelectedItem()).toString())));
                byte[] bytes = new byte[in.available()];
                in.read(bytes);
                this.zone.setText(new String(bytes));
                in.close();
            }
            catch (Exception exception) {}
        } else {
            this.txtFileName.setText("");
            this.zone.setText("loop\n");
            this.zone.requestFocus();
        }
    }

    @FXML
    public void save() {
        if (!this.txtFileName.getText().equals("")) {
            try {
                String fileName = this.txtFileName.getText();
                fileName = fileName.trim();
                fileName = fileName.replaceAll(" ", "");
                PrintStream ps = new PrintStream(new FileOutputStream(Project.getScriptFileFromName(Project.getScriptFileExtension(fileName))));
                ps.print(this.zone.getText());
                ps.close();
                this.zone.setText("");
                this.txtFileName.setText("");
                File scriptFiles = new File(Project.getProjectScriptPath());
                String[] c = scriptFiles.list();
                this.txtLoadFileName.getItems().removeAll((Collection<?>)this.txtLoadFileName.getItems());
                this.txtLoadFileName.getItems().add("New scenario ...");
                for (int i = 0; i < c.length; ++i) {
                    this.txtLoadFileName.getItems().add(c[i]);
                }
                CupCarbonApp.cupCarbonController.initScriptGpsEventComboBoxes();
                CupCarbonApp.cupCarbonController.createContextMenu();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.initComboBox();
    }

    public void initComboBox() {
        File scriptFiles = new File(Project.getProjectScriptPath());
        String[] c = scriptFiles.list();
        this.txtLoadFileName.getItems().removeAll((Collection<?>)this.txtLoadFileName.getItems());
        this.txtLoadFileName.getItems().add("New script ...");
        if (scriptFiles.isDirectory() && c != null) {
            for (int i = 0; i < c.length; ++i) {
                this.txtLoadFileName.getItems().add(c[i]);
            }
        }
    }
}

