/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import device.BaseStation;
import device.DeviceList;
import device.DirectionalSensorNode;
import device.Mobile;
import device.MobileG;
import device.SensorNode;
import device.StdSensorNode;
import markers.Marker;
import markers.MarkerList;
import natural_events.Gas;

public class CupCommand_ADD
extends CupCommand {
    protected String type;
    protected String longitude;
    protected String latitude;
    protected String elevation;
    protected String sType;
    protected String sLongitude;
    protected String sLatitude;
    protected String sElevation;

    public CupCommand_ADD(CupScript script, String type, String longitude, String latitude, String elevation) {
        this.script = script;
        this.type = type;
        this.longitude = longitude;
        this.latitude = latitude;
        this.elevation = elevation;
    }

    @Override
    public String execute() {
        currentExecution = false;
        Object rep = "";
        this.sType = this.script.getVariableValue(this.type);
        this.sLongitude = this.script.getVariableValue(this.longitude);
        this.sLatitude = this.script.getVariableValue(this.latitude);
        this.sElevation = this.script.getVariableValue(this.elevation);
        MobileG device = null;
        SensorNode sensor = null;
        if (isExecuted) {
            switch (this.sType) {
                case "stdsensor": {
                    sensor = new StdSensorNode(Double.parseDouble(this.sLongitude), Double.parseDouble(this.sLatitude), Double.parseDouble(this.sElevation), 0.0, 100.0, 20.0, -1);
                    DeviceList.add(sensor);
                    rep = "000 Adding Sensor: Id=" + sensor.getId() + ", name=" + sensor.getName();
                    currentExecution = true;
                    break;
                }
                case "base_station": {
                    sensor = new BaseStation(Double.parseDouble(this.sLongitude), Double.parseDouble(this.sLatitude), Double.parseDouble(this.sElevation), 0.0, 100.0, 20.0, -1);
                    DeviceList.add(sensor);
                    rep = "000 Adding Base Station: Id=" + sensor.getId() + ", name=" + sensor.getName();
                    currentExecution = true;
                    break;
                }
                case "directional_sensor": {
                    sensor = new DirectionalSensorNode(Double.parseDouble(this.sLongitude), Double.parseDouble(this.sLatitude), Double.parseDouble(this.sElevation), 0.0, 100.0, 20.0, -1, 0.0, 0.0, 0);
                    DeviceList.add(sensor);
                    rep = "000 Adding Directional Sensor: Id=" + sensor.getId() + ", name=" + sensor.getName();
                    currentExecution = true;
                    break;
                }
                case "mobile": {
                    device = new Mobile(Double.parseDouble(this.sLongitude), Double.parseDouble(this.sLatitude), Double.parseDouble(this.sElevation), 0.0, -1);
                    DeviceList.add(device);
                    rep = "000 Adding Mobile: Id=" + device.getId() + ", name=" + device.getName();
                    currentExecution = true;
                    break;
                }
                case "gas": {
                    device = new Gas(Double.parseDouble(this.sLongitude), Double.parseDouble(this.sLatitude), Double.parseDouble(this.sElevation), 0.0, -1);
                    DeviceList.add(device);
                    rep = "000 Adding Gas: Id=" + device.getId() + ", name=" + device.getName();
                    currentExecution = true;
                    break;
                }
                case "marker": {
                    Marker marker = new Marker(Double.parseDouble(this.sLongitude), Double.parseDouble(this.sLatitude), Double.parseDouble(this.sElevation), 0.0);
                    MarkerList.add(marker);
                    rep = "000 Adding Marker";
                    currentExecution = true;
                    break;
                }
                default: {
                    rep = "[ERROR] Unknown type " + this.sType;
                    currentExecution = false;
                    break;
                }
            }
        } else {
            rep = "ERROR IN EXECUTING THE PREVIOUS STEP, THE SCRIPT WILL NOT CONTINUE TO EXECUTE";
            this.script.setBreaked(true);
        }
        System.out.println((String)rep);
        CupScript.slog.println((String)rep);
        isExecuted = currentExecution;
        return rep;
    }

    @Override
    public String toString() {
        return "add " + this.sType + " " + this.sLongitude + " " + this.sLatitude + " " + this.sElevation;
    }
}

